/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking.event;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import me.syntaxjason.syntaxjasonapi.networking.event.Event;

public class EventManager {
    private final Map<Class<? extends Event>, Consumer<? extends Event>> listeners = new ConcurrentHashMap<Class<? extends Event>, Consumer<? extends Event>>();

    public <T extends Event> void registerListener(Class<T> eventClass, Consumer<T> listener) {
        this.listeners.put(eventClass, listener);
    }

    public <T extends Event> void registerWildcardListener(Consumer<T> listener) {
        this.listeners.put(Event.class, listener);
    }

    public <T extends Event> void triggerEvent(T event) {
        Consumer<? extends Event> wildcardListener;
        Consumer<? extends Event> listener = this.listeners.get(event.getClass());
        if (listener != null) {
            listener.accept(event);
        }
        if ((wildcardListener = this.listeners.get(Event.class)) != null) {
            wildcardListener.accept(event);
        }
    }
}

