/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking.channel;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.ExecutionException;
import me.syntaxjason.syntaxjasonapi.networking.buffer.BufferPool;
import me.syntaxjason.syntaxjasonapi.networking.channel.AsyncClientChannel;
import me.syntaxjason.syntaxjasonapi.networking.channel.IChannel;

public class ServerChannel
implements IChannel {
    private AsynchronousServerSocketChannel channel;
    private String host;
    private int port;

    public ServerChannel(String host, int port) {
        this.host = host;
        this.port = port;
        try {
            this.channel = AsynchronousServerSocketChannel.open();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void open() {
        try {
            this.channel.bind(new InetSocketAddress(this.host, this.port));
            System.out.println("Server started on " + this.host + ":" + this.port);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        try {
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close();
                System.out.println("Server closed.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public AsyncClientChannel accept() throws IOException {
        AsynchronousSocketChannel clientChannel = null;
        try {
            clientChannel = this.channel.accept().get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        if (clientChannel != null) {
            return new AsyncClientChannel((InetSocketAddress)clientChannel.getRemoteAddress(), new BufferPool(512, 10280, 4));
        }
        return null;
    }

    public AsynchronousServerSocketChannel getChannel() {
        return this.channel;
    }

    @Override
    public void read() {
    }

    @Override
    public void write(byte[] data) {
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }
}

