/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking.channel;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.NotYetConnectedException;
import me.syntaxjason.syntaxjasonapi.networking.buffer.BufferPool;
import me.syntaxjason.syntaxjasonapi.networking.channel.IChannel;
import me.syntaxjason.syntaxjasonapi.networking.exceptions.NetworkingException;

public class AsyncClientChannel
implements IChannel {
    private final AsynchronousSocketChannel channel;
    private final BufferPool bufferPool;
    private ByteBuffer buffer;

    public AsyncClientChannel(InetSocketAddress address, BufferPool bufferPool) {
        this.bufferPool = bufferPool;
        try {
            this.channel = AsynchronousSocketChannel.open();
            this.buffer = bufferPool.acquire();
            this.channel.connect(address, null, new ConnectionHandler());
        }
        catch (IOException e) {
            throw new NetworkingException("Failed to open AsynchronousSocketChannel", e);
        }
    }

    public AsyncClientChannel(AsynchronousSocketChannel channel, BufferPool bufferPool) {
        this.channel = channel;
        this.bufferPool = bufferPool;
        this.buffer = bufferPool.acquire();
    }

    public void startRead() {
        try {
            if (this.channel.isOpen()) {
                this.buffer.clear();
                this.channel.read(this.buffer, null, new ReadHandler());
            } else {
                System.out.println("Channel not yet connected, read operation delayed.");
            }
        }
        catch (NotYetConnectedException e) {
            System.err.println("Attempted read on a not-yet-connected channel.");
        }
    }

    @Override
    public void write(byte[] data) {
        this.buffer.clear();
        this.buffer.put(data);
        this.buffer.flip();
        this.channel.write(this.buffer, null, new WriteHandler(this));
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
        this.bufferPool.release(this.buffer);
        try {
            if (this.channel.isOpen()) {
                this.channel.close();
                System.out.println("Connection closed and resources released.");
            }
        }
        catch (IOException e) {
            throw new NetworkingException("Failed to close the channel", e);
        }
    }

    @Override
    public void read() {
        this.startRead();
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public AsynchronousSocketChannel getChannel() {
        return this.channel;
    }

    private class ConnectionHandler
    implements CompletionHandler<Void, Void> {
        private ConnectionHandler() {
        }

        @Override
        public void completed(Void result, Void attachment) {
            System.out.println("Connected to server successfully.");
            AsyncClientChannel.this.startRead();
        }

        @Override
        public void failed(Throwable exc, Void attachment) {
            System.err.println("Failed to connect: " + exc.getMessage());
            throw new NetworkingException("Failed to connect to server", exc);
        }
    }

    private class ReadHandler
    implements CompletionHandler<Integer, Void> {
        private ReadHandler() {
        }

        @Override
        public void completed(Integer bytesRead, Void attachment) {
            if (bytesRead == -1) {
                System.out.println("Server closed the connection.");
                AsyncClientChannel.this.close();
                return;
            }
            AsyncClientChannel.this.buffer.flip();
            byte[] data = new byte[AsyncClientChannel.this.buffer.remaining()];
            AsyncClientChannel.this.buffer.get(data);
            AsyncClientChannel.this.startRead();
        }

        @Override
        public void failed(Throwable exc, Void attachment) {
            System.err.println("Read operation failed: " + exc.getMessage());
            throw new NetworkingException("Read failed", exc);
        }
    }

    private class WriteHandler
    implements CompletionHandler<Integer, Void> {
        private WriteHandler(AsyncClientChannel asyncClientChannel) {
        }

        @Override
        public void completed(Integer result, Void attachment) {
        }

        @Override
        public void failed(Throwable exc, Void attachment) {
            System.err.println("Write operation failed: " + exc.getMessage());
            throw new NetworkingException("Write failed", exc);
        }
    }
}

