/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking.buffer;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;

public class BufferPool {
    private final ConcurrentLinkedQueue<ByteBuffer> pool = new ConcurrentLinkedQueue();
    private final int defaultBufferSize;
    private final int maxBufferSize;

    public BufferPool(int defaultBufferSize, int maxBufferSize, int initialPoolSize) {
        this.defaultBufferSize = defaultBufferSize;
        this.maxBufferSize = maxBufferSize;
        for (int i = 0; i < initialPoolSize; ++i) {
            this.pool.add(ByteBuffer.allocateDirect(defaultBufferSize));
        }
    }

    public ByteBuffer acquire(int requiredSize) {
        ByteBuffer buffer = this.pool.poll();
        if (buffer == null || buffer.capacity() < requiredSize) {
            buffer = ByteBuffer.allocateDirect(Math.min(requiredSize, this.maxBufferSize));
            return buffer;
        }
        buffer.clear();
        return buffer;
    }

    public ByteBuffer acquire() {
        ByteBuffer buffer = this.pool.poll();
        if (buffer == null || buffer.capacity() < this.defaultBufferSize) {
            buffer = ByteBuffer.allocateDirect(Math.min(this.defaultBufferSize, this.maxBufferSize));
            return buffer;
        }
        buffer.clear();
        return buffer;
    }

    public void release(ByteBuffer buffer) {
        buffer.clear();
        if (buffer.capacity() <= this.maxBufferSize) {
            this.pool.offer(buffer);
        }
    }
}

