/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking;

import java.io.IOException;
import me.syntaxjason.syntaxjasonapi.networking.exceptions.NetworkingException;
import me.syntaxjason.syntaxjasonapi.networking.pipe.PipelineOrchestrator;
import me.syntaxjason.syntaxjasonapi.networking.util.NetworkProperties;

public class UltraServer {
    private static boolean debug = false;
    private PipelineOrchestrator network;

    public UltraServer(String host, int port) throws IOException {
        this.network = new PipelineOrchestrator(new NetworkProperties(host, port, 1024, 1024, 10, 4, 4));
    }

    public void start() {
        try {
            this.network.start();
        }
        catch (IOException e) {
            throw new NetworkingException(e);
        }
    }

    public void stop() {
        try {
            this.network.shutdown();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public PipelineOrchestrator getNetwork() {
        return this.network;
    }

    public static void setDebug(boolean debug) {
        UltraServer.debug = debug;
    }

    public static boolean isDebug() {
        return debug;
    }
}

