/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import me.syntaxjason.syntaxjasonapi.networking.buffer.BufferPool;
import me.syntaxjason.syntaxjasonapi.networking.channel.AsyncClientChannel;
import me.syntaxjason.syntaxjasonapi.networking.event.Event;
import me.syntaxjason.syntaxjasonapi.networking.event.EventManager;
import me.syntaxjason.syntaxjasonapi.networking.event.channel.ChannelMessageReceivedEvent;
import me.syntaxjason.syntaxjasonapi.networking.event.connection.ConnectionClosedEvent;
import me.syntaxjason.syntaxjasonapi.networking.event.connection.ConnectionEstablishedEvent;
import me.syntaxjason.syntaxjasonapi.networking.event.packet.PacketReceivedEvent;
import me.syntaxjason.syntaxjasonapi.networking.packet.Packet;
import me.syntaxjason.syntaxjasonapi.networking.packet.PacketResolver;

public class UltraClient {
    private AsyncClientChannel channel;
    private EventManager eventManager = new EventManager();
    private Thread readThread;
    private volatile boolean running;
    private int port;
    private String host;

    public UltraClient(String host, int port) {
        this.channel = new AsyncClientChannel(new InetSocketAddress(host, port), new BufferPool(1024, 1024, 10));
        this.port = port;
        this.host = host;
    }

    public UltraClient(String host, int port, int bufferSize) {
        this.channel = new AsyncClientChannel(new InetSocketAddress(host, port), new BufferPool(1024, bufferSize, 10));
    }

    public UltraClient(AsyncClientChannel clientChannel) {
        this.channel = clientChannel;
    }

    public <T extends Event> void registerEvent(Class<T> event, Consumer<T> listener) {
        this.eventManager.registerListener(event, listener);
    }

    public void connect() {
        this.channel.open();
        System.out.println("Connected to " + this.host + ":" + this.port);
        this.eventManager.triggerEvent(new ConnectionEstablishedEvent(this.channel));
        this.startReadingPackets();
    }

    public void disconnect() {
        this.channel.close();
        this.eventManager.triggerEvent(new ConnectionClosedEvent(this.channel));
    }

    public AsyncClientChannel getChannel() {
        return this.channel;
    }

    private void startReadingPackets() {
        this.running = true;
        this.readThread = new Thread(() -> {
            while (this.running) {
                try {
                    ByteBuffer buffer = this.channel.getBuffer();
                    Packet packet = PacketResolver.resolve(buffer);
                    if (packet != null) {
                        this.eventManager.triggerEvent(new PacketReceivedEvent(this.channel, packet));
                        return;
                    }
                    this.eventManager.triggerEvent(new ChannelMessageReceivedEvent(this.channel, buffer.array()));
                }
                catch (Exception e) {
                    e.fillInStackTrace();
                    this.running = false;
                }
            }
        });
        this.readThread.start();
    }
}

