/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.cloudnet.player;

import eu.cloudnetservice.modules.bridge.player.CloudPlayer;
import eu.cloudnetservice.modules.bridge.player.NetworkServiceInfo;
import eu.cloudnetservice.modules.bridge.player.PlayerManager;
import eu.cloudnetservice.modules.bridge.player.executor.ServerSelectorType;
import net.kyori.adventure.text.Component;

public class SimpleCloudPlayer {
    private final CloudPlayer cloudPlayer;
    private final PlayerManager playerManager;

    public SimpleCloudPlayer(CloudPlayer cloudPlayer, PlayerManager playerManager) {
        this.cloudPlayer = cloudPlayer;
        this.playerManager = playerManager;
    }

    public void sendToLobby() {
        this.sendToRandomTask("Lobby");
    }

    public void kickPlayer(String reason) {
        this.playerManager.playerExecutor(this.cloudPlayer.uniqueId()).kick(Component.text(reason));
    }

    public void sendToService(String serviceName) {
        this.playerManager.playerExecutor(this.cloudPlayer.uniqueId()).connect(serviceName);
    }

    public void sendToRandomTask(String taskName) {
        this.playerManager.playerExecutor(this.cloudPlayer.uniqueId()).connectToTask(taskName, ServerSelectorType.RANDOM);
    }

    public void sendToHighestTask(String taskName) {
        this.playerManager.playerExecutor(this.cloudPlayer.uniqueId()).connectToTask(taskName, ServerSelectorType.HIGHEST_PLAYERS);
    }

    public void sendToLowestTask(String taskName) {
        this.playerManager.playerExecutor(this.cloudPlayer.uniqueId()).connectToTask(taskName, ServerSelectorType.LOWEST_PLAYERS);
    }

    public void sendMessage(String message) {
        this.playerManager.playerExecutor(this.cloudPlayer.uniqueId()).sendChatMessage(Component.text(message));
    }

    public NetworkServiceInfo getService() {
        return this.cloudPlayer.connectedService();
    }
}

