/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.Enumeration;

public final class SocketUtils {
    private static final Enumeration<Object> EMPTY = Collections.enumeration(Collections.emptyList());

    private SocketUtils() {
    }

    private static <T> Enumeration<T> empty() {
        return EMPTY;
    }

    public static void connect(Socket socket, SocketAddress remoteAddress, int timeout) throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                socket.connect(remoteAddress, timeout);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static void bind(Socket socket, SocketAddress bindpoint) throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                socket.bind(bindpoint);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static boolean connect(SocketChannel socketChannel, SocketAddress remoteAddress) throws IOException {
        try {
            return AccessController.doPrivileged(() -> socketChannel.connect(remoteAddress));
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static void bind(SocketChannel socketChannel, SocketAddress address) throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                socketChannel.bind(address);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static SocketChannel accept(ServerSocketChannel serverSocketChannel) throws IOException {
        try {
            return AccessController.doPrivileged(serverSocketChannel::accept);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static void bind(DatagramChannel networkChannel, SocketAddress address) throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                networkChannel.bind(address);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static SocketAddress localSocketAddress(ServerSocket socket) {
        return AccessController.doPrivileged(socket::getLocalSocketAddress);
    }

    public static InetAddress addressByName(String hostname) throws UnknownHostException {
        try {
            return AccessController.doPrivileged(() -> InetAddress.getByName(hostname));
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getCause();
        }
    }

    public static InetAddress[] allAddressesByName(String hostname) throws UnknownHostException {
        try {
            return AccessController.doPrivileged(() -> InetAddress.getAllByName(hostname));
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getCause();
        }
    }

    public static InetSocketAddress socketAddress(String hostname, int port) {
        return AccessController.doPrivileged(() -> new InetSocketAddress(hostname, port));
    }

    public static Enumeration<InetAddress> addressesFromNetworkInterface(NetworkInterface intf) {
        Enumeration addresses = AccessController.doPrivileged(intf::getInetAddresses);
        if (addresses == null) {
            return SocketUtils.empty();
        }
        return addresses;
    }

    public static InetAddress loopbackAddress() {
        return AccessController.doPrivileged(InetAddress::getLoopbackAddress);
    }

    public static byte[] hardwareAddressFromNetworkInterface(NetworkInterface intf) throws SocketException {
        try {
            return AccessController.doPrivileged(intf::getHardwareAddress);
        }
        catch (PrivilegedActionException e) {
            throw (SocketException)e.getCause();
        }
    }
}

