/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.internal;

import io.netty5.util.ReferenceCounted;
import io.netty5.util.Resource;
import io.netty5.util.internal.logging.InternalLogger;

public final class SilentDispose {
    public static void dispose(Object obj, InternalLogger logger) {
        try {
            Resource.dispose(obj);
        }
        catch (Throwable throwable) {
            logger.warn("Failed to dispose object: {}.", obj, (Object)throwable);
        }
    }

    public static void trySilentDispose(Object obj, InternalLogger logger) {
        if (Resource.isAccessible(obj, false)) {
            SilentDispose.dispose(obj, logger);
        }
    }

    public static void tryPropagatingDispose(Object obj) {
        if (Resource.isAccessible(obj, false)) {
            Resource.dispose(obj);
        }
    }

    public static AutoCloseable autoClosing(Object obj) {
        if (obj instanceof AutoCloseable) {
            return (AutoCloseable)obj;
        }
        if (obj instanceof ReferenceCounted) {
            return () -> ((ReferenceCounted)obj).release();
        }
        return null;
    }

    private SilentDispose() {
    }
}

