/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.internal;

import io.netty5.util.Resource;
import io.netty5.util.Send;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.function.Supplier;

public class SendFromSupplier<T extends Resource<T>>
implements Send<T> {
    private static final VarHandle GATE;
    private final Class<T> concreteObjectType;
    private final Supplier<? extends T> supplier;
    private volatile boolean gate;

    public SendFromSupplier(Class<T> concreteObjectType, Supplier<? extends T> supplier) {
        this.concreteObjectType = Objects.requireNonNull(concreteObjectType, "Concrete type cannot be null.");
        this.supplier = Objects.requireNonNull(supplier, "Supplier cannot be null.");
    }

    @Override
    public T receive() {
        if (this.passGate()) {
            throw new IllegalStateException("This object has already been received.");
        }
        return (T)((Resource)this.supplier.get());
    }

    @Override
    public boolean referentIsInstanceOf(Class<?> cls) {
        return cls.isAssignableFrom(this.concreteObjectType);
    }

    @Override
    public void close() {
        if (!this.passGate()) {
            ((Resource)this.supplier.get()).close();
        }
    }

    private boolean passGate() {
        return GATE.getAndSet(this, true);
    }

    static {
        try {
            GATE = MethodHandles.lookup().findVarHandle(SendFromSupplier.class, "gate", Boolean.TYPE);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

