/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.concurrent;

import io.netty5.util.concurrent.FastThreadLocalThread;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

final class InternalThreadLocalMap {
    private static final ThreadLocal<InternalThreadLocalMap> slowThreadLocalMap = new ThreadLocal();
    private static final AtomicInteger nextIndex = new AtomicInteger();
    private static final int ARRAY_LIST_CAPACITY_EXPAND_THRESHOLD = 0x40000000;
    private static final int ARRAY_LIST_CAPACITY_MAX_SIZE = 0x7FFFFFF7;
    private static final int INDEXED_VARIABLE_TABLE_INITIAL_SIZE = 32;
    static final Object UNSET = new Object();
    private Object[] indexedVariables = InternalThreadLocalMap.newIndexedVariableTable();

    static InternalThreadLocalMap getIfSet() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            return ((FastThreadLocalThread)thread).threadLocalMap();
        }
        return slowThreadLocalMap.get();
    }

    static InternalThreadLocalMap get() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            return InternalThreadLocalMap.fastGet((FastThreadLocalThread)thread);
        }
        return InternalThreadLocalMap.slowGet();
    }

    private static InternalThreadLocalMap fastGet(FastThreadLocalThread thread) {
        InternalThreadLocalMap threadLocalMap = thread.threadLocalMap();
        if (threadLocalMap == null) {
            threadLocalMap = new InternalThreadLocalMap();
            thread.setThreadLocalMap(threadLocalMap);
        }
        return threadLocalMap;
    }

    private static InternalThreadLocalMap slowGet() {
        InternalThreadLocalMap ret = slowThreadLocalMap.get();
        if (ret == null) {
            ret = new InternalThreadLocalMap();
            slowThreadLocalMap.set(ret);
        }
        return ret;
    }

    static void remove() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            ((FastThreadLocalThread)thread).setThreadLocalMap(null);
        } else {
            slowThreadLocalMap.remove();
        }
    }

    static void destroy() {
        slowThreadLocalMap.remove();
    }

    static int nextVariableIndex() {
        int index = nextIndex.getAndIncrement();
        if (index >= 0x7FFFFFF7 || index < 0) {
            nextIndex.set(0x7FFFFFF7);
            throw new IllegalStateException("too many thread-local indexed variables");
        }
        return index;
    }

    static int lastVariableIndex() {
        return nextIndex.get() - 1;
    }

    private InternalThreadLocalMap() {
    }

    private static Object[] newIndexedVariableTable() {
        Object[] array = new Object[32];
        Arrays.fill(array, UNSET);
        return array;
    }

    int size() {
        int count = 0;
        for (Object o : this.indexedVariables) {
            if (o == UNSET) continue;
            ++count;
        }
        return count - 1;
    }

    Object indexedVariable(int index) {
        Object[] lookup = this.indexedVariables;
        return index < lookup.length ? lookup[index] : UNSET;
    }

    boolean setIndexedVariable(int index, Object value) {
        Object[] lookup = this.indexedVariables;
        if (index < lookup.length) {
            Object oldValue = lookup[index];
            lookup[index] = value;
            return oldValue == UNSET;
        }
        this.expandIndexedVariableTableAndSet(index, value);
        return true;
    }

    private void expandIndexedVariableTableAndSet(int index, Object value) {
        int newCapacity;
        Object[] oldArray = this.indexedVariables;
        int oldCapacity = oldArray.length;
        if (index < 0x40000000) {
            newCapacity = index;
            newCapacity |= newCapacity >>> 1;
            newCapacity |= newCapacity >>> 2;
            newCapacity |= newCapacity >>> 4;
            newCapacity |= newCapacity >>> 8;
            newCapacity |= newCapacity >>> 16;
            ++newCapacity;
        } else {
            newCapacity = 0x7FFFFFF7;
        }
        Object[] newArray = Arrays.copyOf(oldArray, newCapacity);
        Arrays.fill(newArray, oldCapacity, newArray.length, UNSET);
        newArray[index] = value;
        this.indexedVariables = newArray;
    }

    Object removeIndexedVariable(int index) {
        Object[] lookup = this.indexedVariables;
        if (index < lookup.length) {
            Object v = lookup[index];
            lookup[index] = UNSET;
            return v;
        }
        return UNSET;
    }

    boolean isIndexedVariableSet(int index) {
        Object[] lookup = this.indexedVariables;
        return index < lookup.length && lookup[index] != UNSET;
    }
}

