/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.concurrent;

import io.netty5.util.concurrent.AsynchronousResult;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.StringUtil;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public interface FutureCompletionStage<V>
extends CompletionStage<V>,
java.util.concurrent.Future<V>,
AsynchronousResult<V> {
    public FutureCompletionStage<V> sync() throws InterruptedException;

    default public <T> T join(BiFunction<V, Throwable, T> resultHandler) throws InterruptedException {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.await();
        Future<V> fut = this.future();
        if (fut.isSuccess()) {
            return resultHandler.apply(fut.getNow(), null);
        }
        return resultHandler.apply(null, fut.cause());
    }

    public FutureCompletionStage<V> await() throws InterruptedException;

    public boolean await(long var1, TimeUnit var3) throws InterruptedException;

    default public Throwable getCause() throws InterruptedException {
        this.await();
        return this.cause();
    }

    public Future<V> future();

    @Override
    default public boolean cancel() {
        return this.future().cancel();
    }

    @Override
    default public boolean isSuccess() {
        return this.future().isSuccess();
    }

    @Override
    default public boolean isFailed() {
        return this.future().isFailed();
    }

    @Override
    default public boolean isCancellable() {
        return this.future().isCancellable();
    }

    @Override
    default public V getNow() {
        return this.future().getNow();
    }

    @Override
    default public Throwable cause() {
        return this.future().cause();
    }

    @Override
    default public EventExecutor executor() {
        return this.future().executor();
    }

    @Override
    default public CompletableFuture<V> toCompletableFuture() {
        throw new UnsupportedOperationException("Not supported by " + StringUtil.simpleClassName(FutureCompletionStage.class));
    }

    @Override
    public <U> FutureCompletionStage<U> thenApply(Function<? super V, ? extends U> var1);

    @Override
    public <U> FutureCompletionStage<U> thenApplyAsync(Function<? super V, ? extends U> var1);

    public FutureCompletionStage<Void> thenAccept(Consumer<? super V> var1);

    public FutureCompletionStage<Void> thenAcceptAsync(Consumer<? super V> var1);

    public FutureCompletionStage<Void> thenRun(Runnable var1);

    public FutureCompletionStage<Void> thenRunAsync(Runnable var1);

    @Override
    public <U, V1> FutureCompletionStage<V1> thenCombine(CompletionStage<? extends U> var1, BiFunction<? super V, ? super U, ? extends V1> var2);

    @Override
    public <U, V1> FutureCompletionStage<V1> thenCombineAsync(CompletionStage<? extends U> var1, BiFunction<? super V, ? super U, ? extends V1> var2);

    public <U> FutureCompletionStage<Void> thenAcceptBoth(CompletionStage<? extends U> var1, BiConsumer<? super V, ? super U> var2);

    public <U> FutureCompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> var1, BiConsumer<? super V, ? super U> var2);

    public FutureCompletionStage<Void> runAfterBoth(CompletionStage<?> var1, Runnable var2);

    public FutureCompletionStage<Void> runAfterBothAsync(CompletionStage<?> var1, Runnable var2);

    @Override
    public <U> FutureCompletionStage<U> applyToEither(CompletionStage<? extends V> var1, Function<? super V, U> var2);

    @Override
    public <U> FutureCompletionStage<U> applyToEitherAsync(CompletionStage<? extends V> var1, Function<? super V, U> var2);

    public FutureCompletionStage<Void> acceptEither(CompletionStage<? extends V> var1, Consumer<? super V> var2);

    public FutureCompletionStage<Void> acceptEitherAsync(CompletionStage<? extends V> var1, Consumer<? super V> var2);

    public FutureCompletionStage<Void> runAfterEither(CompletionStage<?> var1, Runnable var2);

    public FutureCompletionStage<Void> runAfterEitherAsync(CompletionStage<?> var1, Runnable var2);

    @Override
    public <U> FutureCompletionStage<U> thenCompose(Function<? super V, ? extends CompletionStage<U>> var1);

    @Override
    public <U> FutureCompletionStage<U> thenComposeAsync(Function<? super V, ? extends CompletionStage<U>> var1);

    @Override
    public FutureCompletionStage<V> whenComplete(BiConsumer<? super V, ? super Throwable> var1);

    @Override
    public FutureCompletionStage<V> whenCompleteAsync(BiConsumer<? super V, ? super Throwable> var1);

    @Override
    public <U> FutureCompletionStage<U> handle(BiFunction<? super V, Throwable, ? extends U> var1);

    @Override
    public <U> FutureCompletionStage<U> handleAsync(BiFunction<? super V, Throwable, ? extends U> var1);

    @Override
    public <U> FutureCompletionStage<U> thenApplyAsync(Function<? super V, ? extends U> var1, Executor var2);

    public FutureCompletionStage<Void> thenAcceptAsync(Consumer<? super V> var1, Executor var2);

    public FutureCompletionStage<Void> thenRunAsync(Runnable var1, Executor var2);

    @Override
    public <U, V1> FutureCompletionStage<V1> thenCombineAsync(CompletionStage<? extends U> var1, BiFunction<? super V, ? super U, ? extends V1> var2, Executor var3);

    public <U> FutureCompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> var1, BiConsumer<? super V, ? super U> var2, Executor var3);

    public FutureCompletionStage<Void> runAfterBothAsync(CompletionStage<?> var1, Runnable var2, Executor var3);

    @Override
    public <U> FutureCompletionStage<U> applyToEitherAsync(CompletionStage<? extends V> var1, Function<? super V, U> var2, Executor var3);

    public FutureCompletionStage<Void> acceptEitherAsync(CompletionStage<? extends V> var1, Consumer<? super V> var2, Executor var3);

    public FutureCompletionStage<Void> runAfterEitherAsync(CompletionStage<?> var1, Runnable var2, Executor var3);

    @Override
    public <U> FutureCompletionStage<U> thenComposeAsync(Function<? super V, ? extends CompletionStage<U>> var1, Executor var2);

    @Override
    public FutureCompletionStage<V> exceptionally(Function<Throwable, ? extends V> var1);

    @Override
    public FutureCompletionStage<V> whenCompleteAsync(BiConsumer<? super V, ? super Throwable> var1, Executor var2);

    @Override
    public <U> FutureCompletionStage<U> handleAsync(BiFunction<? super V, Throwable, ? extends U> var1, Executor var2);

    public static <U> FutureCompletionStage<U> toFutureCompletionStage(CompletionStage<U> stage, EventExecutor executor) {
        CompletableFuture future;
        Objects.requireNonNull(stage, "stage");
        Objects.requireNonNull(executor, "executor");
        if (stage instanceof FutureCompletionStage && ((FutureCompletionStage)stage).executor() == executor) {
            return (FutureCompletionStage)stage;
        }
        if (stage instanceof CompletableFuture && (future = (CompletableFuture)stage).isDone() && !future.isCompletedExceptionally()) {
            return executor.newSucceededFuture(future.getNow(null)).asStage();
        }
        Promise promise = executor.newPromise();
        stage.whenComplete((? super T v, ? super Throwable cause) -> {
            if (cause != null) {
                promise.setFailure((Throwable)cause);
            } else {
                promise.setSuccess(v);
            }
        });
        return promise.asFuture().asStage();
    }
}

