/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util;

import io.netty5.util.ResourceLeakDetector;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.SystemPropertyUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Constructor;
import java.util.Objects;

public abstract class ResourceLeakDetectorFactory {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ResourceLeakDetectorFactory.class);
    private static volatile ResourceLeakDetectorFactory factoryInstance = new DefaultResourceLeakDetectorFactory();

    public static ResourceLeakDetectorFactory instance() {
        return factoryInstance;
    }

    public static void setResourceLeakDetectorFactory(ResourceLeakDetectorFactory factory) {
        factoryInstance = Objects.requireNonNull(factory, "factory");
    }

    public final <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> resource) {
        return this.newResourceLeakDetector(resource, ResourceLeakDetector.SAMPLING_INTERVAL);
    }

    public abstract <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> var1, int var2);

    private static final class DefaultResourceLeakDetectorFactory
    extends ResourceLeakDetectorFactory {
        private final Constructor<?> customClassConstructor;

        DefaultResourceLeakDetectorFactory() {
            String customLeakDetector;
            try {
                customLeakDetector = SystemPropertyUtil.get("io.netty5.customResourceLeakDetector");
            }
            catch (Throwable cause) {
                logger.error("Could not access System property: io.netty5.customResourceLeakDetector", cause);
                customLeakDetector = null;
            }
            this.customClassConstructor = customLeakDetector == null ? null : DefaultResourceLeakDetectorFactory.customClassConstructor(customLeakDetector);
        }

        private static Constructor<?> customClassConstructor(String customLeakDetector) {
            try {
                Class<?> detectorClass = Class.forName(customLeakDetector, true, PlatformDependent.getSystemClassLoader());
                if (ResourceLeakDetector.class.isAssignableFrom(detectorClass)) {
                    return detectorClass.getConstructor(Class.class, Integer.TYPE);
                }
                logger.error("Class {} does not inherit from ResourceLeakDetector.", (Object)customLeakDetector);
            }
            catch (Throwable t) {
                logger.error("Could not load custom resource leak detector class provided: {}", (Object)customLeakDetector, (Object)t);
            }
            return null;
        }

        @Override
        public <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> resource, int samplingInterval) {
            ObjectUtil.checkPositive(samplingInterval, "samplingInterval");
            if (this.customClassConstructor != null) {
                try {
                    ResourceLeakDetector leakDetector = (ResourceLeakDetector)this.customClassConstructor.newInstance(resource, samplingInterval);
                    logger.debug("Loaded custom ResourceLeakDetector: {}", (Object)this.customClassConstructor.getDeclaringClass().getName());
                    return leakDetector;
                }
                catch (Throwable t) {
                    logger.error("Could not load custom resource leak detector provided: {} with the given resource: {}", this.customClassConstructor.getDeclaringClass().getName(), resource, t);
                }
            }
            ResourceLeakDetector resourceLeakDetector = new ResourceLeakDetector(resource, samplingInterval);
            logger.debug("Loaded default ResourceLeakDetector: {}", (Object)resourceLeakDetector);
            return resourceLeakDetector;
        }
    }
}

