/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.timeout;

import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.timeout.WriteTimeoutException;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureListener;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class WriteTimeoutHandler
implements ChannelHandler {
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final long timeoutNanos;
    private WriteTimeoutTask lastTask;
    private boolean closed;

    public WriteTimeoutHandler(int timeoutSeconds) {
        this(timeoutSeconds, TimeUnit.SECONDS);
    }

    public WriteTimeoutHandler(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        this.timeoutNanos = timeout <= 0L ? 0L : Math.max(unit.toNanos(timeout), MIN_TIMEOUT_NANOS);
    }

    @Override
    public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
        Future<Void> f = ctx.write(msg);
        if (this.timeoutNanos > 0L) {
            this.scheduleTimeout(ctx, f);
        }
        return f;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        assert (ctx.executor().inEventLoop());
        WriteTimeoutTask task = this.lastTask;
        this.lastTask = null;
        while (task != null) {
            assert (task.ctx.executor().inEventLoop());
            task.scheduledFuture.cancel();
            WriteTimeoutTask prev = task.prev;
            task.prev = null;
            task.next = null;
            task = prev;
        }
    }

    private void scheduleTimeout(ChannelHandlerContext ctx, Future<Void> future) {
        WriteTimeoutTask task = new WriteTimeoutTask(ctx, future);
        task.scheduledFuture = ctx.executor().schedule(task, this.timeoutNanos, TimeUnit.NANOSECONDS);
        if (!task.scheduledFuture.isDone()) {
            this.addWriteTimeoutTask(task);
            future.addListener(task);
        }
    }

    private void addWriteTimeoutTask(WriteTimeoutTask task) {
        assert (task.ctx.executor().inEventLoop());
        if (this.lastTask != null) {
            this.lastTask.next = task;
            task.prev = this.lastTask;
        }
        this.lastTask = task;
    }

    private void removeWriteTimeoutTask(WriteTimeoutTask task) {
        assert (task.ctx.executor().inEventLoop());
        if (task == this.lastTask) {
            assert (task.next == null);
            this.lastTask = this.lastTask.prev;
            if (this.lastTask != null) {
                this.lastTask.next = null;
            }
        } else {
            if (task.prev == null && task.next == null) {
                return;
            }
            if (task.prev == null) {
                task.next.prev = null;
            } else {
                task.prev.next = task.next;
                task.next.prev = task.prev;
            }
        }
        task.prev = null;
        task.next = null;
    }

    protected void writeTimedOut(ChannelHandlerContext ctx) throws Exception {
        if (!this.closed) {
            ctx.fireChannelExceptionCaught(WriteTimeoutException.INSTANCE);
            ctx.close();
            this.closed = true;
        }
    }

    private final class WriteTimeoutTask
    implements Runnable,
    FutureListener<Void> {
        private final ChannelHandlerContext ctx;
        private final Future<Void> future;
        WriteTimeoutTask prev;
        WriteTimeoutTask next;
        Future<?> scheduledFuture;

        WriteTimeoutTask(ChannelHandlerContext ctx, Future<Void> future) {
            this.ctx = ctx;
            this.future = future;
        }

        @Override
        public void run() {
            if (!this.future.isDone()) {
                try {
                    WriteTimeoutHandler.this.writeTimedOut(this.ctx);
                }
                catch (Throwable t) {
                    this.ctx.fireChannelExceptionCaught(t);
                }
            }
            WriteTimeoutHandler.this.removeWriteTimeoutTask(this);
        }

        @Override
        public void operationComplete(Future<? extends Void> future) throws Exception {
            this.scheduledFuture.cancel();
            if (this.ctx.executor().inEventLoop()) {
                WriteTimeoutHandler.this.removeWriteTimeoutTask(this);
            } else {
                assert (future.isDone());
                this.ctx.executor().execute(this);
            }
        }
    }
}

