/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.stream;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ComponentIterator;
import io.netty5.handler.stream.ChunkedInput;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Objects;

public class ChunkedStream
implements ChunkedInput<Buffer> {
    static final int DEFAULT_CHUNK_SIZE = 8192;
    private final PushbackInputStream in;
    private final int chunkSize;
    private long offset;
    private boolean closed;
    private byte[] cachedArray;

    public ChunkedStream(InputStream in) {
        this(in, 8192);
    }

    public ChunkedStream(InputStream in, int chunkSize) {
        Objects.requireNonNull(in, "in");
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize: " + chunkSize + " (expected: a positive integer)");
        }
        this.in = in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in);
        this.chunkSize = chunkSize;
    }

    public long transferredBytes() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        if (this.closed) {
            return true;
        }
        if (this.in.available() > 0) {
            return false;
        }
        int b = this.in.read();
        if (b < 0) {
            return true;
        }
        this.in.unread(b);
        return false;
    }

    @Override
    public void close() throws Exception {
        this.closed = true;
        this.in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer readChunk(BufferAllocator allocator) throws Exception {
        if (this.isEndOfInput()) {
            return null;
        }
        int availableBytes = this.in.available();
        int chunkSize = availableBytes <= 0 ? this.chunkSize : Math.min(this.chunkSize, this.in.available());
        boolean release = true;
        Buffer buffer = allocator.allocate(chunkSize);
        try {
            Buffer buffer2;
            int written;
            try (ComponentIterator iter = buffer.forEachComponent();){
                BufferComponent component = (BufferComponent)iter.firstWritable();
                if (component.hasWritableArray()) {
                    written = this.in.read(component.writableArray(), component.writableArrayOffset(), component.writableArrayLength());
                } else {
                    int size = Math.min(component.writableBytes(), chunkSize);
                    if (this.cachedArray == null || this.cachedArray.length < size) {
                        this.cachedArray = new byte[size];
                    }
                    if ((written = this.in.read(this.cachedArray, 0, size)) > 0) {
                        buffer.writeBytes(this.cachedArray, 0, written);
                    }
                }
            }
            if (written < 0) {
                buffer2 = null;
                return buffer2;
            }
            this.offset += (long)written;
            release = false;
            buffer2 = buffer;
            return buffer2;
        }
        finally {
            if (release) {
                buffer.close();
            }
        }
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public long progress() {
        return this.offset;
    }
}

