/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ssl;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.buffer.internal.InternalBufferUtils;
import io.netty5.buffer.internal.ResourceSupport;
import io.netty5.handler.ssl.PemEncoded;
import io.netty5.handler.ssl.PemValue;
import io.netty5.handler.ssl.SslUtils;
import io.netty5.util.Resource;
import io.netty5.util.Send;
import io.netty5.util.internal.ObjectUtil;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.Set;

public final class PemX509Certificate
extends X509Certificate
implements PemEncoded,
Resource<PemX509Certificate> {
    private static final byte[] BEGIN_CERT = "-----BEGIN CERTIFICATE-----\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] END_CERT = "\n-----END CERTIFICATE-----\n".getBytes(StandardCharsets.US_ASCII);
    private final Buffer content;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PemEncoded toPEM(BufferAllocator alloc, X509Certificate ... chain) throws CertificateEncodingException {
        X509Certificate first;
        ObjectUtil.checkNonEmpty(chain, "chain");
        if (chain.length == 1 && (first = chain[0]) instanceof PemEncoded) {
            return ((PemEncoded)((Object)first)).copy();
        }
        boolean success = false;
        Resource pem = null;
        try {
            for (X509Certificate cert : chain) {
                if (cert == null) {
                    throw new IllegalArgumentException("Null element in chain: " + Arrays.toString(chain));
                }
                pem = cert instanceof PemEncoded ? PemX509Certificate.append(alloc, (PemEncoded)((Object)cert), chain.length, (Buffer)pem) : PemX509Certificate.append(alloc, cert, chain.length, (Buffer)pem);
            }
            PemValue value = new PemValue((Buffer)pem);
            success = true;
            PemValue pemValue = value;
            return pemValue;
        }
        finally {
            if (!success && pem != null) {
                pem.close();
            }
        }
    }

    private static Buffer append(BufferAllocator alloc, PemEncoded encoded, int count, Buffer pem) {
        Buffer content = encoded.content();
        if (pem == null) {
            pem = alloc.allocate(content.readableBytes() * count);
        } else {
            pem.ensureWritable(content.readableBytes());
        }
        int length = content.readableBytes();
        pem.skipWritableBytes(length);
        content.copyInto(content.readerOffset(), pem, pem.writerOffset(), length);
        return pem;
    }

    private static Buffer append(BufferAllocator alloc, X509Certificate cert, int count, Buffer pem) throws CertificateEncodingException {
        try (Buffer encoded = alloc.copyOf(cert.getEncoded());
             Buffer base64 = SslUtils.toBase64(alloc, encoded);){
            int length = BEGIN_CERT.length + base64.readableBytes() + END_CERT.length;
            if (pem == null) {
                pem = alloc.allocate(length * count);
            } else {
                pem.ensureWritable(length);
            }
            pem.writeBytes(BEGIN_CERT);
            pem.writeBytes(base64);
            pem.writeBytes(END_CERT);
        }
        return pem;
    }

    public static PemX509Certificate valueOf(byte[] key) {
        return PemX509Certificate.valueOf(DefaultBufferAllocators.offHeapAllocator().copyOf(key));
    }

    public static PemX509Certificate valueOf(Buffer key) {
        return new PemX509Certificate(key);
    }

    private PemX509Certificate(Buffer content) {
        this.content = Objects.requireNonNull(content, "content").makeReadOnly();
    }

    @Override
    public Buffer content() {
        if (!this.content.isAccessible()) {
            throw InternalBufferUtils.attachTrace((ResourceSupport)((Object)this.content), new IllegalStateException("PemX509Certificate is closed."));
        }
        return this.content;
    }

    @Override
    public void close() {
        this.content.close();
    }

    @Override
    public PemX509Certificate copy() {
        return new PemX509Certificate(this.content.copy(true));
    }

    @Override
    public Send<PemX509Certificate> send() {
        return this.content.send().map(PemX509Certificate.class, PemX509Certificate::new);
    }

    @Override
    public boolean isAccessible() {
        return this.content.isAccessible();
    }

    @Override
    public byte[] getEncoded() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkValidity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkValidity(Date date) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger getSerialNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Principal getIssuerDN() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Principal getSubjectDN() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getNotBefore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getNotAfter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getTBSCertificate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getSignature() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSigAlgName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSigAlgOID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getSigAlgParams() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean[] getKeyUsage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getBasicConstraints() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void verify(PublicKey key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void verify(PublicKey key, String sigProvider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PublicKey getPublicKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PemX509Certificate)) {
            return false;
        }
        PemX509Certificate other = (PemX509Certificate)o;
        return this.content.equals(other.content);
    }

    @Override
    public int hashCode() {
        return this.content.hashCode();
    }

    @Override
    public String toString() {
        return this.content.toString(StandardCharsets.UTF_8);
    }
}

