/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ssl;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ComponentIterator;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.buffer.StandardAllocationTypes;
import io.netty5.handler.ssl.JdkApplicationProtocolNegotiator;
import io.netty5.handler.ssl.JdkSslEngine;
import io.netty5.handler.ssl.SslUtils;
import io.netty5.handler.ssl.VectoredUnwrap;
import io.netty5.util.internal.EmptyArrays;
import io.netty5.util.internal.SystemPropertyUtil;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.conscrypt.AllocatedBuffer;
import org.conscrypt.BufferAllocator;
import org.conscrypt.Conscrypt;
import org.conscrypt.HandshakeListener;

abstract class ConscryptAlpnSslEngine
extends JdkSslEngine
implements VectoredUnwrap {
    private static final boolean USE_BUFFER_ALLOCATOR = SystemPropertyUtil.getBoolean("io.netty5.handler.ssl.conscrypt.useBufferAllocator", true);

    static ConscryptAlpnSslEngine newClientEngine(SSLEngine engine, io.netty5.buffer.BufferAllocator alloc, JdkApplicationProtocolNegotiator applicationNegotiator) {
        return new ClientEngine(engine, alloc, applicationNegotiator);
    }

    static ConscryptAlpnSslEngine newServerEngine(SSLEngine engine, io.netty5.buffer.BufferAllocator alloc, JdkApplicationProtocolNegotiator applicationNegotiator) {
        return new ServerEngine(engine, alloc, applicationNegotiator);
    }

    private ConscryptAlpnSslEngine(SSLEngine engine, io.netty5.buffer.BufferAllocator alloc, List<String> protocols) {
        super(engine);
        if (USE_BUFFER_ALLOCATOR) {
            Conscrypt.setBufferAllocator((SSLEngine)engine, (BufferAllocator)new BufferAllocatorAdapter(alloc));
        }
        Conscrypt.setApplicationProtocols((SSLEngine)engine, (String[])protocols.toArray(EmptyArrays.EMPTY_STRINGS));
    }

    final int calculateOutNetBufSize(int plaintextBytes, int numBuffers) {
        long maxOverhead = (long)Conscrypt.maxSealOverhead((SSLEngine)this.getWrappedEngine()) * (long)numBuffers;
        return (int)Math.min(Integer.MAX_VALUE, (long)plaintextBytes + maxOverhead);
    }

    @Override
    public final SSLEngineResult unwrap(ByteBuffer[] srcs, ByteBuffer[] dests) throws SSLException {
        return Conscrypt.unwrap((SSLEngine)this.getWrappedEngine(), (ByteBuffer[])srcs, (ByteBuffer[])dests);
    }

    private static final class BufferAdapter
    extends AllocatedBuffer {
        private final Buffer nettyBuffer;
        private final ByteBuffer buffer;

        BufferAdapter(io.netty5.buffer.BufferAllocator allocator, int capacity) {
            this.nettyBuffer = allocator.allocate(capacity);
            try (ComponentIterator iteration = this.nettyBuffer.forEachComponent();){
                this.buffer = ((BufferComponent)iteration.firstWritable()).writableBuffer();
            }
        }

        public ByteBuffer nioBuffer() {
            return this.buffer;
        }

        public AllocatedBuffer retain() {
            throw new UnsupportedOperationException("This method is not supposed to be used.");
        }

        public AllocatedBuffer release() {
            this.nettyBuffer.close();
            return this;
        }
    }

    private static final class BufferAllocatorAdapter
    extends BufferAllocator {
        private final io.netty5.buffer.BufferAllocator alloc;

        BufferAllocatorAdapter(io.netty5.buffer.BufferAllocator alloc) {
            if (alloc.getAllocationType() != StandardAllocationTypes.OFF_HEAP) {
                alloc = DefaultBufferAllocators.offHeapAllocator();
            }
            this.alloc = alloc;
        }

        public AllocatedBuffer allocateDirectBuffer(int capacity) {
            return new BufferAdapter(this.alloc, capacity);
        }
    }

    private static final class ServerEngine
    extends ConscryptAlpnSslEngine {
        private final JdkApplicationProtocolNegotiator.ProtocolSelector protocolSelector;

        ServerEngine(SSLEngine engine, io.netty5.buffer.BufferAllocator alloc, JdkApplicationProtocolNegotiator applicationNegotiator) {
            super(engine, alloc, applicationNegotiator.protocols());
            Conscrypt.setHandshakeListener((SSLEngine)engine, (HandshakeListener)new HandshakeListener(){

                public void onHandshakeFinished() throws SSLException {
                    this.selectProtocol();
                }
            });
            this.protocolSelector = Objects.requireNonNull(applicationNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(applicationNegotiator.protocols())), "protocolSelector");
        }

        private void selectProtocol() throws SSLException {
            try {
                String protocol = Conscrypt.getApplicationProtocol((SSLEngine)this.getWrappedEngine());
                this.protocolSelector.select(protocol != null ? Collections.singletonList(protocol) : Collections.emptyList());
            }
            catch (Throwable e) {
                throw SslUtils.toSSLHandshakeException(e);
            }
        }
    }

    private static final class ClientEngine
    extends ConscryptAlpnSslEngine {
        private final JdkApplicationProtocolNegotiator.ProtocolSelectionListener protocolListener;

        ClientEngine(SSLEngine engine, io.netty5.buffer.BufferAllocator alloc, JdkApplicationProtocolNegotiator applicationNegotiator) {
            super(engine, alloc, applicationNegotiator.protocols());
            Conscrypt.setHandshakeListener((SSLEngine)engine, (HandshakeListener)new HandshakeListener(){

                public void onHandshakeFinished() throws SSLException {
                    this.selectProtocol();
                }
            });
            this.protocolListener = Objects.requireNonNull(applicationNegotiator.protocolListenerFactory().newListener(this, applicationNegotiator.protocols()), "protocolListener");
        }

        private void selectProtocol() throws SSLException {
            String protocol = Conscrypt.getApplicationProtocol((SSLEngine)this.getWrappedEngine());
            try {
                this.protocolListener.selected(protocol);
            }
            catch (Throwable e) {
                throw SslUtils.toSSLHandshakeException(e);
            }
        }
    }
}

