/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ipfilter;

import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.ipfilter.AbstractRemoteAddressFilter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class UniqueIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final Set<InetAddress> connected = ConcurrentHashMap.newKeySet();

    @Override
    public boolean isSharable() {
        return true;
    }

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) {
        InetAddress remoteIp = remoteAddress.getAddress();
        if (!this.connected.add(remoteIp)) {
            return false;
        }
        ctx.channel().closeFuture().addListener(future -> this.connected.remove(remoteIp));
        return true;
    }
}

