/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ipfilter;

import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.ipfilter.AbstractRemoteAddressFilter;
import io.netty5.handler.ipfilter.IpFilterRule;
import io.netty5.handler.ipfilter.IpFilterRuleType;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RuleBasedIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final boolean acceptIfNotFound;
    private final List<IpFilterRule> rules;

    public RuleBasedIpFilter(IpFilterRule ... rules) {
        this(true, rules);
    }

    public RuleBasedIpFilter(boolean acceptIfNotFound, IpFilterRule ... rules) {
        Objects.requireNonNull(rules, "rules");
        this.acceptIfNotFound = acceptIfNotFound;
        this.rules = new ArrayList<IpFilterRule>(rules.length);
        for (IpFilterRule rule : rules) {
            if (rule == null) continue;
            this.rules.add(rule);
        }
    }

    @Override
    public boolean isSharable() {
        return true;
    }

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        for (IpFilterRule rule : this.rules) {
            if (!rule.matches(remoteAddress)) continue;
            return rule.ruleType() == IpFilterRuleType.ACCEPT;
        }
        return this.acceptIfNotFound;
    }
}

