/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.string;

import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.MessageToMessageEncoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;

public class StringEncoder
extends MessageToMessageEncoder<CharSequence> {
    private final Charset charset;

    public StringEncoder() {
        this(Charset.defaultCharset());
    }

    public StringEncoder(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        this.charset = charset;
    }

    @Override
    public boolean isSharable() {
        return true;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, CharSequence msg, List<Object> out) throws Exception {
        if (msg.length() == 0) {
            return;
        }
        out.add(ctx.bufferAllocator().copyOf(msg.toString(), this.charset));
    }
}

