/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.BufferUtil;
import io.netty5.handler.codec.compression.DecompressionException;
import io.netty5.handler.codec.compression.Decompressor;
import io.netty5.handler.codec.compression.Snappy;
import java.util.function.Supplier;

public final class SnappyDecompressor
implements Decompressor {
    private static final int SNAPPY_IDENTIFIER_LEN = 6;
    private static final int MAX_UNCOMPRESSED_DATA_SIZE = 65540;
    private static final int MAX_DECOMPRESSED_DATA_SIZE = 65536;
    private static final int MAX_COMPRESSED_CHUNK_SIZE = 0xFFFFFF;
    private final Snappy snappy = new Snappy();
    private final boolean validateChecksums;
    private boolean started;
    private int numBytesToSkip;
    private State state = State.DECODING;

    private SnappyDecompressor(boolean validateChecksums) {
        this.validateChecksums = validateChecksums;
    }

    public static Supplier<SnappyDecompressor> newFactory() {
        return SnappyDecompressor.newFactory(false);
    }

    public static Supplier<SnappyDecompressor> newFactory(boolean validateChecksums) {
        return () -> new SnappyDecompressor(validateChecksums);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Buffer decompress(Buffer in, BufferAllocator allocator) throws DecompressionException {
        switch (1.$SwitchMap$io$netty5$handler$codec$compression$SnappyDecompressor$State[this.state.ordinal()]) {
            case 1: 
            case 2: {
                return allocator.allocate(0);
            }
            case 3: {
                throw new DecompressionException("Decompressor closed");
            }
            case 4: {
                if (this.numBytesToSkip != 0) {
                    skipBytes = Math.min(this.numBytesToSkip, in.readableBytes());
                    in.skipReadableBytes(skipBytes);
                    this.numBytesToSkip -= skipBytes;
                    return null;
                }
                idx = in.readerOffset();
                inSize = in.readableBytes();
                if (inSize < 4) {
                    return null;
                }
                chunkTypeVal = in.getUnsignedByte(idx);
                chunkType = SnappyDecompressor.mapChunkType((byte)chunkTypeVal);
                chunkLength = BufferUtil.reverseUnsignedMedium(in.getUnsignedMedium(idx + 1));
                switch (1.$SwitchMap$io$netty5$handler$codec$compression$SnappyDecompressor$ChunkType[chunkType.ordinal()]) {
                    case 1: {
                        if (chunkLength != 6) {
                            this.streamCorrupted("Unexpected length of stream identifier: " + chunkLength);
                        }
                        if (inSize < 10) {
                            return null;
                        }
                        in.skipReadableBytes(4);
                        offset = in.readerOffset();
                        in.skipReadableBytes(6);
                        SnappyDecompressor.checkByte(in.getByte(offset++), (byte)115);
                        SnappyDecompressor.checkByte(in.getByte(offset++), (byte)78);
                        SnappyDecompressor.checkByte(in.getByte(offset++), (byte)97);
                        SnappyDecompressor.checkByte(in.getByte(offset++), (byte)80);
                        SnappyDecompressor.checkByte(in.getByte(offset++), (byte)112);
                        SnappyDecompressor.checkByte(in.getByte(offset), (byte)89);
                        this.started = true;
                        return null;
                    }
                    case 2: {
                        if (!this.started) {
                            this.streamCorrupted("Received RESERVED_SKIPPABLE tag before STREAM_IDENTIFIER");
                        }
                        in.skipReadableBytes(4);
                        skipBytes = Math.min(chunkLength, in.readableBytes());
                        in.skipReadableBytes(skipBytes);
                        if (skipBytes != chunkLength) {
                            this.numBytesToSkip = chunkLength - skipBytes;
                        }
                        return null;
                    }
                    case 3: {
                        this.streamCorrupted("Found reserved unskippable chunk type: 0x" + Integer.toHexString(chunkTypeVal));
                    }
                    case 4: {
                        if (!this.started) {
                            this.streamCorrupted("Received UNCOMPRESSED_DATA tag before STREAM_IDENTIFIER");
                        }
                        if (chunkLength > 65540) {
                            this.streamCorrupted("Received UNCOMPRESSED_DATA larger than 65540 bytes");
                        }
                        if (inSize < 4 + chunkLength) {
                            return null;
                        }
                        in.skipReadableBytes(4);
                        if (this.validateChecksums) {
                            checksum = Integer.reverseBytes(in.readInt());
                            try {
                                Snappy.validateChecksum(checksum, in, in.readerOffset(), chunkLength - 4);
                            }
                            catch (DecompressionException e) {
                                this.state = State.CORRUPTED;
                                throw e;
                            }
                        } else {
                            in.skipReadableBytes(4);
                        }
                        return in.readSplit(chunkLength - 4);
                    }
                    case 5: {
                        if (!this.started) {
                            this.streamCorrupted("Received COMPRESSED_DATA tag before STREAM_IDENTIFIER");
                        }
                        if (chunkLength > 0xFFFFFF) {
                            this.streamCorrupted("Received COMPRESSED_DATA that contains chunk that exceeds 16777215 bytes");
                        }
                        if (inSize < 4 + chunkLength) {
                            return null;
                        }
                        in.skipReadableBytes(4);
                        checksum = Integer.reverseBytes(in.readInt());
                        uncompressedSize = this.snappy.getPreamble(in);
                        if (uncompressedSize > 65536) {
                            this.streamCorrupted("Received COMPRESSED_DATA that contains uncompressed data that exceeds 65536 bytes");
                        }
                        uncompressed = allocator.allocate(uncompressedSize);
                        uncompressed.implicitCapacityLimit(65536);
                        try {
                            if (!this.validateChecksums) ** GOTO lbl106
                            oldWriterIndex = in.writerOffset();
                            try {
                                in.writerOffset(in.readerOffset() + chunkLength - 4);
                                this.snappy.decode(in, uncompressed);
                            }
                            finally {
                                in.writerOffset(oldWriterIndex);
                            }
                            try {
                                Snappy.validateChecksum(checksum, uncompressed, 0, uncompressed.writerOffset());
                            }
                            catch (DecompressionException e) {
                                this.state = State.CORRUPTED;
                                throw e;
                            }
lbl106:
                            // 1 sources

                            slice = in.readSplit(chunkLength - 4);
                            try {
                                this.snappy.decode(slice, uncompressed);
                            }
                            finally {
                                if (slice != null) {
                                    slice.close();
                                }
                            }
                            this.snappy.reset();
                            buffer = uncompressed;
                            uncompressed = null;
                            var14_22 = buffer;
                            return var14_22;
                        }
                        finally {
                            if (uncompressed != null) {
                                uncompressed.close();
                            }
                        }
                    }
                }
                this.streamCorrupted("Unexpected state");
                return null;
            }
        }
        throw new IllegalStateException();
    }

    private static void checkByte(byte actual, byte expect) {
        if (actual != expect) {
            throw new DecompressionException("Unexpected stream identifier contents. Mismatched snappy protocol version?");
        }
    }

    private static ChunkType mapChunkType(byte type) {
        if (type == 0) {
            return ChunkType.COMPRESSED_DATA;
        }
        if (type == 1) {
            return ChunkType.UNCOMPRESSED_DATA;
        }
        if (type == -1) {
            return ChunkType.STREAM_IDENTIFIER;
        }
        if ((type & 0x80) == 128) {
            return ChunkType.RESERVED_SKIPPABLE;
        }
        return ChunkType.RESERVED_UNSKIPPABLE;
    }

    private void streamCorrupted(String message) {
        this.state = State.CORRUPTED;
        throw new DecompressionException(message);
    }

    @Override
    public boolean isFinished() {
        switch (this.state) {
            case FINISHED: 
            case CORRUPTED: 
            case CLOSED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    @Override
    public void close() {
        this.state = State.FINISHED;
    }

    private static enum State {
        DECODING,
        FINISHED,
        CORRUPTED,
        CLOSED;

    }

    private static enum ChunkType {
        STREAM_IDENTIFIER,
        COMPRESSED_DATA,
        UNCOMPRESSED_DATA,
        RESERVED_UNSKIPPABLE,
        RESERVED_SKIPPABLE,
        CORRUPTED,
        FINISHED;

    }
}

