/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ComponentIterator;
import io.netty5.handler.codec.compression.BufferChecksum;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHashFactory;

public final class Lz4XXHash32
extends BufferChecksum {
    private static final XXHash32 XXHASH32 = XXHashFactory.fastestInstance().hash32();
    private final int seed;
    private boolean used;
    private int value;

    public Lz4XXHash32(int seed) {
        super(new Checksum(){

            @Override
            public void update(int b) {
                throw new Error();
            }

            @Override
            public void update(byte[] b, int off, int len) {
                throw new Error();
            }

            @Override
            public long getValue() {
                throw new Error();
            }

            @Override
            public void reset() {
                throw new Error();
            }
        });
        this.seed = seed;
    }

    @Override
    public void update(int b) {
        this.update(new byte[]{(byte)b}, 0, 1);
    }

    private void checkUsed() {
        if (this.used) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.checkUsed();
        this.value = XXHASH32.hash(b, off, len, this.seed);
        this.used = true;
    }

    @Override
    public void update(ByteBuffer buffer) {
        this.checkUsed();
        this.value = XXHASH32.hash(buffer, this.seed);
        this.used = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Buffer b, int off, int len) {
        this.checkUsed();
        if (b.countReadableComponents() > 1) {
            byte[] bytes = new byte[len];
            b.copyInto(off, bytes, 0, bytes.length);
            this.value = XXHASH32.hash(bytes, 0, bytes.length, this.seed);
        } else {
            int oldOffset = b.readerOffset();
            b.readerOffset(off);
            try (ComponentIterator readableIteration = b.forEachComponent();){
                BufferComponent readableComponent = (BufferComponent)readableIteration.firstReadable();
                while (readableComponent != null) {
                    if (readableComponent.hasReadableArray()) {
                        this.value = XXHASH32.hash(readableComponent.readableArray(), readableComponent.readableArrayOffset(), len, this.seed);
                    } else {
                        ByteBuffer nioBuffer = readableComponent.readableBuffer();
                        this.value = XXHASH32.hash(nioBuffer, nioBuffer.position(), len, this.seed);
                    }
                    readableComponent = (BufferComponent)((ComponentIterator.Next)((Object)readableComponent)).nextReadable();
                }
            }
            finally {
                b.readerOffset(oldOffset);
            }
        }
        this.used = true;
    }

    @Override
    public long getValue() {
        if (!this.used) {
            throw new IllegalStateException();
        }
        return (long)this.value & 0xFFFFFFFL;
    }

    @Override
    public void reset() {
        this.used = false;
    }
}

