/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ComponentIterator;
import io.netty5.handler.codec.EncoderException;
import io.netty5.handler.codec.compression.BufferChecksum;
import io.netty5.handler.codec.compression.CompressionException;
import io.netty5.handler.codec.compression.Compressor;
import io.netty5.handler.codec.compression.Lz4XXHash32;
import io.netty5.util.internal.ObjectUtil;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;

public final class Lz4Compressor
implements Compressor {
    static final int DEFAULT_MAX_ENCODE_SIZE = Integer.MAX_VALUE;
    private final int blockSize;
    private final LZ4Compressor compressor;
    private final BufferChecksum checksum;
    private final int compressionLevel;
    private final int maxEncodeSize;
    private State state = State.PROCESSING;

    public static Supplier<Lz4Compressor> newFactory() {
        return Lz4Compressor.newFactory(false);
    }

    public static Supplier<Lz4Compressor> newFactory(boolean highCompressor) {
        return Lz4Compressor.newFactory(LZ4Factory.fastestInstance(), highCompressor, 65536, new Lz4XXHash32(-1756908916));
    }

    public static Supplier<Lz4Compressor> newFactory(LZ4Factory factory, boolean highCompressor, int blockSize, Checksum checksum) {
        return Lz4Compressor.newFactory(factory, highCompressor, blockSize, checksum, Integer.MAX_VALUE);
    }

    public static Supplier<Lz4Compressor> newFactory(LZ4Factory factory, boolean highCompressor, int blockSize, Checksum checksum, int maxEncodeSize) {
        Objects.requireNonNull(factory, "factory");
        Objects.requireNonNull(checksum, "checksum");
        ObjectUtil.checkPositive(blockSize, "blockSize");
        ObjectUtil.checkPositive(maxEncodeSize, "maxEncodeSize");
        return () -> new Lz4Compressor(factory, highCompressor, blockSize, checksum, maxEncodeSize);
    }

    private Lz4Compressor(LZ4Factory factory, boolean highCompressor, int blockSize, Checksum checksum, int maxEncodeSize) {
        LZ4Compressor lZ4Compressor = this.compressor = highCompressor ? factory.highCompressor() : factory.fastCompressor();
        this.checksum = checksum == null ? null : (checksum instanceof Lz4XXHash32 ? (Lz4XXHash32)checksum : new BufferChecksum(checksum));
        this.compressionLevel = Lz4Compressor.compressionLevel(blockSize);
        this.blockSize = blockSize;
        this.maxEncodeSize = maxEncodeSize;
    }

    private static int compressionLevel(int blockSize) {
        if (blockSize < 64 || blockSize > 0x2000000) {
            throw new IllegalArgumentException(String.format("blockSize: %d (expected: %d-%d)", blockSize, 64, 0x2000000));
        }
        int compressionLevel = 32 - Integer.numberOfLeadingZeros(blockSize - 1);
        compressionLevel = Math.max(0, compressionLevel - 10);
        return compressionLevel;
    }

    private Buffer allocateBuffer(BufferAllocator allocator, Buffer msg) {
        int targetBufSize = 0;
        int remaining = msg.readableBytes();
        if (remaining < 0) {
            throw new EncoderException("too much data to allocate a buffer for compression");
        }
        while (remaining > 0) {
            int curSize = Math.min(this.blockSize, remaining);
            remaining -= curSize;
            targetBufSize += this.compressor.maxCompressedLength(curSize) + 21;
        }
        if (targetBufSize > this.maxEncodeSize || 0 > targetBufSize) {
            throw new EncoderException(String.format("requested encode buffer size (%d bytes) exceeds the maximum allowable size (%d bytes)", targetBufSize, this.maxEncodeSize));
        }
        return allocator.allocate(targetBufSize);
    }

    @Override
    public Buffer compress(Buffer input, BufferAllocator allocator) throws CompressionException {
        switch (this.state) {
            case CLOSED: {
                throw new CompressionException("Compressor closed");
            }
            case FINISHED: {
                return allocator.allocate(0);
            }
            case PROCESSING: {
                if (input.readableBytes() == 0) {
                    return allocator.allocate(0);
                }
                Buffer out = this.allocateBuffer(allocator, input);
                try {
                    while (input.readableBytes() > 0) {
                        this.compressData(input, out);
                    }
                }
                catch (Throwable cause) {
                    out.close();
                    throw cause;
                }
                return out;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Buffer finish(BufferAllocator allocator) {
        switch (this.state) {
            case CLOSED: {
                throw new CompressionException("Compressor closed");
            }
            case FINISHED: 
            case PROCESSING: {
                this.state = State.FINISHED;
                Buffer footer = allocator.allocate(21);
                footer.ensureWritable(21);
                int idx = footer.writerOffset();
                footer.setLong(idx, 5501767354678207339L);
                footer.setByte(idx + 8, (byte)(0x10 | this.compressionLevel));
                footer.setInt(idx + 9, 0);
                footer.setInt(idx + 13, 0);
                footer.setInt(idx + 17, 0);
                footer.skipWritableBytes(21);
                return footer;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isFinished() {
        return this.state != State.PROCESSING;
    }

    @Override
    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    @Override
    public void close() {
        this.state = State.CLOSED;
    }

    private void compressData(Buffer in, Buffer out) {
        int blockType;
        int inReaderIndex = in.readerOffset();
        int flushableBytes = Math.min(in.readableBytes(), this.blockSize);
        assert (flushableBytes > 0);
        this.checksum.reset();
        this.checksum.update(in, inReaderIndex, flushableBytes);
        int check = (int)this.checksum.getValue();
        int bufSize = this.compressor.maxCompressedLength(flushableBytes) + 21;
        out.ensureWritable(bufSize);
        int idx = out.writerOffset();
        int compressedLength = 0;
        try {
            out.skipWritableBytes(21);
            assert (out.countWritableComponents() == 1);
            int readable = flushableBytes;
            try (ComponentIterator writableIteration = out.forEachComponent();){
                BufferComponent writableComponent = (BufferComponent)writableIteration.firstWritable();
                try (ComponentIterator readableIteration = in.forEachComponent();){
                    BufferComponent readableComponent = (BufferComponent)readableIteration.firstReadable();
                    while (readableComponent != null) {
                        ByteBuffer outNioBuffer = writableComponent.writableBuffer();
                        int pos = outNioBuffer.position();
                        ByteBuffer inNioBuffer = readableComponent.readableBuffer();
                        if (inNioBuffer.remaining() > readable) {
                            inNioBuffer.limit(inNioBuffer.position() + readable);
                            this.compressor.compress(inNioBuffer, outNioBuffer);
                            compressedLength += outNioBuffer.position() - pos;
                            break;
                        }
                        readable -= inNioBuffer.remaining();
                        this.compressor.compress(inNioBuffer, outNioBuffer);
                        compressedLength += outNioBuffer.position() - pos;
                        readableComponent = (BufferComponent)((ComponentIterator.Next)((Object)readableComponent)).nextReadable();
                    }
                }
            }
        }
        catch (LZ4Exception e) {
            throw new CompressionException(e);
        }
        finally {
            out.writerOffset(idx);
        }
        if (compressedLength >= flushableBytes) {
            blockType = 16;
            compressedLength = flushableBytes;
            in.copyInto(inReaderIndex, out, idx + 21, flushableBytes);
        } else {
            blockType = 32;
        }
        out.setLong(idx, 5501767354678207339L);
        out.setByte(idx + 8, (byte)(blockType | this.compressionLevel));
        out.setInt(idx + 9, Integer.reverseBytes(compressedLength));
        out.setInt(idx + 13, Integer.reverseBytes(flushableBytes));
        out.setInt(idx + 17, Integer.reverseBytes(check));
        out.writerOffset(idx + 21 + compressedLength);
        in.readerOffset(inReaderIndex + flushableBytes);
    }

    private static enum State {
        PROCESSING,
        FINISHED,
        CLOSED;

    }
}

