/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.handler.codec.compression.BufferChecksum;
import io.netty5.handler.codec.compression.CompressionException;
import io.netty5.handler.codec.compression.Compressor;
import io.netty5.handler.codec.compression.FastLz;
import java.util.function.Supplier;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public final class FastLzCompressor
implements Compressor {
    private final int level;
    private final BufferChecksum checksum;
    private State state = State.PROCESSING;

    private FastLzCompressor(int level, Checksum checksum) {
        this.level = level;
        this.checksum = checksum == null ? null : new BufferChecksum(checksum);
    }

    public static Supplier<FastLzCompressor> newFactory() {
        return FastLzCompressor.newFactory(0, null);
    }

    public static Supplier<FastLzCompressor> newFactory(int level) {
        return FastLzCompressor.newFactory(level, null);
    }

    public static Supplier<FastLzCompressor> newFactory(boolean validateChecksums) {
        return FastLzCompressor.newFactory(0, validateChecksums ? new Adler32() : null);
    }

    public static Supplier<FastLzCompressor> newFactory(int level, Checksum checksum) {
        if (level != 0 && level != 1 && level != 2) {
            throw new IllegalArgumentException(String.format("level: %d (expected: %d or %d or %d)", level, 0, 1, 2));
        }
        return () -> new FastLzCompressor(level, checksum);
    }

    @Override
    public Buffer compress(Buffer in, BufferAllocator allocator) throws CompressionException {
        switch (this.state) {
            case CLOSED: {
                throw new CompressionException("Compressor closed");
            }
            case FINISHED: {
                return allocator.allocate(0);
            }
            case PROCESSING: {
                return this.compressData(in, allocator);
            }
        }
        throw new IllegalStateException();
    }

    private Buffer compressData(Buffer in, BufferAllocator allocator) {
        BufferChecksum checksum = this.checksum;
        Buffer out = allocator.allocate((int)((double)in.readableBytes() / 1.5));
        while (in.readableBytes() != 0) {
            int chunkLength;
            int blockType;
            int idx = in.readerOffset();
            int length = Math.min(in.readableBytes(), 65535);
            int outputIdx = out.writerOffset();
            out.ensureWritable(4);
            out.setMedium(outputIdx, 4607066);
            int outputOffset = outputIdx + 4 + (checksum != null ? 4 : 0);
            if (length < 32) {
                blockType = 0;
                out.ensureWritable(outputOffset + 2 + length);
                int outputPtr = outputOffset + 2;
                if (checksum != null) {
                    checksum.reset();
                    checksum.update(in, idx, length);
                    out.setInt(outputIdx + 4, (int)checksum.getValue());
                }
                in.copyInto(idx, out, outputPtr, length);
                chunkLength = length;
            } else {
                if (checksum != null) {
                    checksum.reset();
                    checksum.update(in, idx, length);
                    out.setInt(outputIdx + 4, (int)checksum.getValue());
                }
                int maxOutputLength = FastLz.calculateOutputBufferLength(length);
                out.ensureWritable(outputOffset + 4 + maxOutputLength);
                int outputPtr = outputOffset + 4;
                int compressedLength = FastLz.compress(in, in.readerOffset(), length, out, outputPtr, this.level);
                if (compressedLength < length) {
                    blockType = 1;
                    chunkLength = compressedLength;
                    out.setShort(outputOffset, (short)chunkLength);
                    outputOffset += 2;
                } else {
                    blockType = 0;
                    in.copyInto(idx, out, outputOffset + 2, length);
                    chunkLength = length;
                }
            }
            out.setShort(outputOffset, (short)length);
            out.setByte(outputIdx + 3, (byte)(blockType | (checksum != null ? 16 : 0)));
            out.writerOffset(outputOffset + 2 + chunkLength);
            in.skipReadableBytes(length);
        }
        return out;
    }

    @Override
    public Buffer finish(BufferAllocator allocator) {
        switch (this.state) {
            case CLOSED: {
                throw new CompressionException("Compressor closed");
            }
            case FINISHED: 
            case PROCESSING: {
                this.state = State.FINISHED;
                return allocator.allocate(0);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isFinished() {
        return this.state != State.PROCESSING;
    }

    @Override
    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    @Override
    public void close() {
        this.state = State.CLOSED;
    }

    private static enum State {
        PROCESSING,
        FINISHED,
        CLOSED;

    }
}

