/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.handler.codec.compression.Decompressor;
import java.util.Objects;
import java.util.function.Supplier;

public final class DecompressionHandler
extends ByteToMessageDecoder {
    private final Supplier<? extends Decompressor> decompressorSupplier;
    private final boolean discardBytesAfterFinished;
    private Decompressor decompressor;

    public DecompressionHandler(Supplier<? extends Decompressor> decompressorSupplier) {
        this(decompressorSupplier, true);
    }

    public DecompressionHandler(Supplier<? extends Decompressor> decompressorSupplier, boolean discardBytesAfterFinished) {
        this.decompressorSupplier = Objects.requireNonNull(decompressorSupplier, "decompressorSupplier");
        this.discardBytesAfterFinished = discardBytesAfterFinished;
    }

    @Override
    protected void handlerAdded0(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded0(ctx);
        this.decompressor = this.decompressorSupplier.get();
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, Buffer in) throws Exception {
        if (this.decompressor == null) {
            ctx.fireChannelRead(in.split());
            return;
        }
        while (!this.decompressor.isFinished()) {
            int idx = in.readerOffset();
            Buffer decompressed = this.decompressor.decompress(in, ctx.bufferAllocator());
            if (decompressed != null) {
                ctx.fireChannelRead(decompressed);
                continue;
            }
            if (idx != in.readerOffset()) continue;
            return;
        }
        assert (this.decompressor.isFinished());
        if (this.discardBytesAfterFinished) {
            in.skipReadableBytes(in.readableBytes());
        } else {
            ctx.fireChannelRead(in.split());
        }
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        try {
            super.handlerRemoved0(ctx);
        }
        finally {
            this.closeDecompressor();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            super.channelInactive(ctx);
        }
        finally {
            this.closeDecompressor();
        }
    }

    private void closeDecompressor() {
        if (this.decompressor != null) {
            this.decompressor.close();
            this.decompressor = null;
        }
    }
}

