/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ComponentIterator;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.zip.Checksum;

class BufferChecksum
implements Checksum {
    private final Checksum checksum;

    BufferChecksum(Checksum checksum) {
        this.checksum = Objects.requireNonNull(checksum);
    }

    @Override
    public void update(int b) {
        this.checksum.update(b);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.checksum.update(b, off, len);
    }

    @Override
    public long getValue() {
        return this.checksum.getValue();
    }

    @Override
    public void reset() {
        this.checksum.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Buffer b, int off, int len) {
        int readerOffset = b.readerOffset();
        b.readerOffset(off);
        try (ComponentIterator iteration = b.forEachComponent();){
            BufferComponent c = (BufferComponent)iteration.firstReadable();
            while (c != null) {
                ByteBuffer componentBuffer = c.readableBuffer();
                if (componentBuffer.remaining() > len) {
                    componentBuffer.limit(componentBuffer.position() + len);
                    this.update(componentBuffer);
                    break;
                }
                len -= componentBuffer.remaining();
                this.update(componentBuffer);
                c = (BufferComponent)((ComponentIterator.Next)((Object)c)).nextReadable();
            }
        }
        finally {
            b.readerOffset(readerOffset);
        }
    }
}

