/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.base64;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.MessageToMessageDecoder;
import io.netty5.handler.codec.base64.Base64;
import io.netty5.handler.codec.base64.Base64Dialect;
import java.util.Objects;

public class Base64Decoder
extends MessageToMessageDecoder<Buffer> {
    private final Base64Dialect dialect;

    public Base64Decoder() {
        this(Base64Dialect.STANDARD);
    }

    public Base64Decoder(Base64Dialect dialect) {
        Objects.requireNonNull(dialect, "dialect");
        this.dialect = dialect;
    }

    @Override
    public boolean isSharable() {
        return true;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, Buffer msg) throws Exception {
        ctx.fireChannelRead(Base64.decode(msg, msg.readerOffset(), msg.readableBytes(), this.dialect));
    }
}

