/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.base64;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.handler.codec.base64.Base64Dialect;
import io.netty5.util.ByteProcessor;
import java.util.Objects;

public final class Base64 {
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;

    private static byte[] alphabet(Base64Dialect dialect) {
        Objects.requireNonNull(dialect, "dialect");
        return dialect.alphabet;
    }

    private static byte[] decodabet(Base64Dialect dialect) {
        Objects.requireNonNull(dialect, "dialect");
        return dialect.decodabet;
    }

    private static boolean breakLines(Base64Dialect dialect) {
        Objects.requireNonNull(dialect, "dialect");
        return dialect.breakLinesByDefault;
    }

    public static Buffer encode(Buffer src) {
        return Base64.encode(src, Base64Dialect.STANDARD);
    }

    public static Buffer encode(Buffer src, Base64Dialect dialect) {
        return Base64.encode(src, Base64.breakLines(dialect), dialect);
    }

    public static Buffer encode(Buffer src, boolean breakLines) {
        return Base64.encode(src, breakLines, Base64Dialect.STANDARD);
    }

    public static Buffer encode(Buffer src, boolean breakLines, Base64Dialect dialect) {
        Objects.requireNonNull(src, "src");
        Buffer dest = Base64.encode(src, src.readerOffset(), src.readableBytes(), breakLines, dialect);
        src.readerOffset(src.writerOffset());
        return dest;
    }

    public static Buffer encode(Buffer src, int off, int len) {
        return Base64.encode(src, off, len, Base64Dialect.STANDARD);
    }

    public static Buffer encode(Buffer src, int off, int len, Base64Dialect dialect) {
        return Base64.encode(src, off, len, Base64.breakLines(dialect), dialect);
    }

    public static Buffer encode(Buffer src, int off, int len, boolean breakLines) {
        return Base64.encode(src, off, len, breakLines, Base64Dialect.STANDARD);
    }

    public static Buffer encode(Buffer src, int off, int len, boolean breakLines, Base64Dialect dialect) {
        return Base64.encode(src, off, len, breakLines, dialect, src.isDirect() ? DefaultBufferAllocators.offHeapAllocator() : DefaultBufferAllocators.onHeapAllocator());
    }

    public static Buffer encode(Buffer src, int off, int len, boolean breakLines, Base64Dialect dialect, BufferAllocator allocator) {
        Objects.requireNonNull(src, "src");
        Objects.requireNonNull(dialect, "dialect");
        Buffer dest = allocator.allocate(Base64.encodedBufferSize(len, breakLines));
        byte[] alphabet = Base64.alphabet(dialect);
        int d = 0;
        int e = 0;
        int len2 = len - 2;
        int lineLength = 0;
        while (d < len2) {
            Base64.encode3to4(src, d + off, 3, dest, e, alphabet);
            if (breakLines && (lineLength += 4) == 76) {
                dest.setByte(e + 4, (byte)10);
                ++e;
                lineLength = 0;
            }
            d += 3;
            e += 4;
        }
        if (d < len) {
            Base64.encode3to4(src, d + off, len - d, dest, e, alphabet);
            e += 4;
        }
        if (e > 1 && dest.getByte(e - 1) == 10) {
            --e;
        }
        return dest.writerOffset(e);
    }

    private static void encode3to4(Buffer src, int srcOffset, int numSigBytes, Buffer dest, int destOffset, byte[] alphabet) {
        int inBuff;
        switch (numSigBytes) {
            case 1: {
                inBuff = Base64.toInt(src.getByte(srcOffset));
                break;
            }
            case 2: {
                inBuff = Base64.toIntBE(src.getShort(srcOffset));
                break;
            }
            default: {
                inBuff = numSigBytes <= 0 ? 0 : Base64.toIntBE(src.getMedium(srcOffset));
            }
        }
        Base64.encode3to4BigEndian(inBuff, numSigBytes, dest, destOffset, alphabet);
    }

    static int encodedBufferSize(int len, boolean breakLines) {
        long len43 = ((long)len << 2) / 3L;
        long ret = len43 + 3L & 0xFFFFFFFFFFFFFFFCL;
        if (breakLines) {
            ret += len43 / 76L;
        }
        return ret < Integer.MAX_VALUE ? (int)ret : Integer.MAX_VALUE;
    }

    private static int toInt(byte value) {
        return (value & 0xFF) << 16;
    }

    private static int toIntBE(short value) {
        return (value & 0xFF00) << 8 | (value & 0xFF) << 8;
    }

    private static int toIntBE(int mediumValue) {
        return mediumValue & 0xFF0000 | mediumValue & 0xFF00 | mediumValue & 0xFF;
    }

    private static void encode3to4BigEndian(int inBuff, int numSigBytes, Buffer dest, int destOffset, byte[] alphabet) {
        switch (numSigBytes) {
            case 3: {
                dest.setInt(destOffset, alphabet[inBuff >>> 18] << 24 | alphabet[inBuff >>> 12 & 0x3F] << 16 | alphabet[inBuff >>> 6 & 0x3F] << 8 | alphabet[inBuff & 0x3F]);
                break;
            }
            case 2: {
                dest.setInt(destOffset, alphabet[inBuff >>> 18] << 24 | alphabet[inBuff >>> 12 & 0x3F] << 16 | alphabet[inBuff >>> 6 & 0x3F] << 8 | 0x3D);
                break;
            }
            case 1: {
                dest.setInt(destOffset, alphabet[inBuff >>> 18] << 24 | alphabet[inBuff >>> 12 & 0x3F] << 16 | 0x3D00 | 0x3D);
                break;
            }
        }
    }

    public static Buffer decode(Buffer src) {
        return Base64.decode(src, Base64Dialect.STANDARD);
    }

    public static Buffer decode(Buffer src, Base64Dialect dialect) {
        Objects.requireNonNull(src, "src");
        Buffer dest = Base64.decode(src, src.readerOffset(), src.readableBytes(), dialect);
        src.readerOffset(src.writerOffset());
        return dest;
    }

    public static Buffer decode(Buffer src, int off, int len) {
        return Base64.decode(src, off, len, Base64Dialect.STANDARD);
    }

    public static Buffer decode(Buffer src, int off, int len, Base64Dialect dialect) {
        return Base64.decode(src, off, len, dialect, src.isDirect() ? DefaultBufferAllocators.offHeapAllocator() : DefaultBufferAllocators.onHeapAllocator());
    }

    public static Buffer decode(Buffer src, int off, int len, Base64Dialect dialect, BufferAllocator allocator) {
        Objects.requireNonNull(src, "src");
        Objects.requireNonNull(dialect, "dialect");
        return new Decoder().decode(src, off, len, allocator, dialect);
    }

    static int decodedBufferSize(int len) {
        return len - (len >>> 2);
    }

    private Base64() {
    }

    private static final class Decoder
    implements ByteProcessor {
        private final byte[] b4 = new byte[4];
        private int b4Posn;
        private byte[] decodabet;
        private int outBuffPosn;
        private Buffer dest;

        private Decoder() {
        }

        Buffer decode(Buffer src, int off, int len, BufferAllocator allocator, Base64Dialect dialect) {
            this.dest = allocator.allocate(Base64.decodedBufferSize(len));
            try {
                this.decodabet = Base64.decodabet(dialect);
                src.openCursor(off, len).process(this);
                return this.dest.writerOffset(this.outBuffPosn);
            }
            catch (Throwable cause) {
                this.dest.close();
                throw cause;
            }
        }

        @Override
        public boolean process(byte value) {
            byte sbiDecode;
            if (value > 0 && (sbiDecode = this.decodabet[value]) >= -5) {
                if (sbiDecode >= -1) {
                    this.b4[this.b4Posn++] = value;
                    if (this.b4Posn > 3) {
                        this.outBuffPosn += Decoder.decode4to3(this.b4, this.dest, this.outBuffPosn, this.decodabet);
                        this.b4Posn = 0;
                        return value != 61;
                    }
                }
                return true;
            }
            throw new IllegalArgumentException("invalid Base64 input character: " + (short)(value & 0xFF) + " (decimal)");
        }

        private static int decode4to3(byte[] src, Buffer dest, int destOffset, byte[] decodabet) {
            int decodedValue;
            byte src0 = src[0];
            byte src1 = src[1];
            byte src2 = src[2];
            if (src2 == 61) {
                int decodedValue2;
                try {
                    decodedValue2 = (decodabet[src0] & 0xFF) << 2 | (decodabet[src1] & 0xFF) >>> 4;
                }
                catch (IndexOutOfBoundsException ignored) {
                    throw new IllegalArgumentException("not encoded in Base64");
                }
                dest.setUnsignedByte(destOffset, (byte)decodedValue2);
                return 1;
            }
            byte src3 = src[3];
            if (src3 == 61) {
                int decodedValue3;
                byte b1 = decodabet[src1];
                try {
                    decodedValue3 = ((decodabet[src0] & 0x3F) << 2 | (b1 & 0xF0) >> 4) << 8 | (b1 & 0xF) << 4 | (decodabet[src2] & 0xFC) >>> 2;
                }
                catch (IndexOutOfBoundsException ignored) {
                    throw new IllegalArgumentException("not encoded in Base64");
                }
                dest.setUnsignedShort(destOffset, decodedValue3);
                return 2;
            }
            try {
                decodedValue = (decodabet[src0] & 0x3F) << 18 | (decodabet[src1] & 0xFF) << 12 | (decodabet[src2] & 0xFF) << 6 | decodabet[src3] & 0xFF;
            }
            catch (IndexOutOfBoundsException ignored) {
                throw new IllegalArgumentException("not encoded in Base64");
            }
            dest.setMedium(destOffset, decodedValue);
            return 3;
        }
    }
}

