/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec;

import io.netty5.channel.ChannelHandlerAdapter;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.CodecException;
import io.netty5.handler.codec.CodecOutputList;
import io.netty5.handler.codec.EncoderException;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.concurrent.PromiseCombiner;
import io.netty5.util.internal.SilentDispose;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.TypeParameterMatcher;
import java.util.List;

public abstract class MessageToMessageEncoder<I>
extends ChannelHandlerAdapter {
    private final TypeParameterMatcher matcher;

    protected MessageToMessageEncoder() {
        this.matcher = TypeParameterMatcher.find(this, MessageToMessageEncoder.class, "I");
    }

    protected MessageToMessageEncoder(Class<? extends I> outboundMessageType) {
        this.matcher = TypeParameterMatcher.get(outboundMessageType);
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return this.matcher.match(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
        CodecOutputList out = null;
        try {
            if (this.acceptOutboundMessage(msg)) {
                out = CodecOutputList.newInstance();
                Object cast = msg;
                Promise<Void> promise = ctx.newPromise();
                try {
                    this.encodeAndClose(ctx, cast, out);
                    if (out.isEmpty()) {
                        throw new EncoderException(StringUtil.simpleClassName(this) + " must produce at least one message.");
                    }
                }
                finally {
                    if (out.size() == 1) {
                        ctx.write(out.getUnsafe(0)).cascadeTo(promise);
                    } else {
                        MessageToMessageEncoder.writePromiseCombiner(ctx, out, promise);
                    }
                }
                Future<Void> future = promise.asFuture();
                return future;
            }
            Future<Void> cast = ctx.write(msg);
            return cast;
        }
        catch (EncoderException e) {
            Future<Void> future = ctx.newFailedFuture(e);
            return future;
        }
        catch (Throwable t) {
            Future<Void> future = ctx.newFailedFuture(new EncoderException("Unhandled exception in encoder " + this.getClass().getName(), t));
            return future;
        }
        finally {
            if (out != null) {
                out.recycle();
            }
        }
    }

    private static void writePromiseCombiner(ChannelHandlerContext ctx, CodecOutputList out, Promise<Void> promise) {
        PromiseCombiner combiner = new PromiseCombiner(ctx.executor());
        for (int i = 0; i < out.size(); ++i) {
            combiner.add(ctx.write(out.getUnsafe(i)));
        }
        combiner.finish(promise);
    }

    protected void encode(ChannelHandlerContext ctx, I msg, List<Object> out) throws Exception {
        throw new CodecException(this.getClass().getName() + " must override either encode() or encodeAndClose().");
    }

    protected void encodeAndClose(ChannelHandlerContext ctx, I msg, List<Object> out) throws Exception {
        try (AutoCloseable ignore = SilentDispose.autoClosing(msg);){
            this.encode(ctx, msg, out);
        }
    }
}

