/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerAdapter;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.util.Resource;
import io.netty5.util.concurrent.Future;
import io.netty5.util.internal.SilentDispose;
import io.netty5.util.internal.TypeParameterMatcher;
import java.util.Objects;

public abstract class MessageToByteEncoder<I>
extends ChannelHandlerAdapter {
    private final TypeParameterMatcher matcher;

    protected MessageToByteEncoder() {
        this.matcher = TypeParameterMatcher.find(this, MessageToByteEncoder.class, "I");
    }

    protected MessageToByteEncoder(Class<? extends I> outboundMessageType) {
        this.matcher = TypeParameterMatcher.get(Objects.requireNonNull(outboundMessageType, "outboundMessageType"));
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return this.matcher.match(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
        Future<Void> future;
        try (Resource buf = null;){
            if (this.acceptOutboundMessage(msg)) {
                Object cast = msg;
                buf = this.allocateBuffer(ctx, cast);
                try (AutoCloseable ignore = SilentDispose.autoClosing(cast);){
                    this.encode(ctx, cast, (Buffer)buf);
                }
                if (buf.readableBytes() > 0) {
                    Future<Void> f = ctx.write(buf);
                    buf = null;
                    Future<Void> future2 = f;
                    return future2;
                }
                future = ctx.write(ctx.bufferAllocator().allocate(0));
                return future;
            }
            Future<Void> cast = ctx.write(msg);
            return cast;
        }
    }

    protected abstract Buffer allocateBuffer(ChannelHandlerContext var1, I var2) throws Exception;

    protected abstract void encode(ChannelHandlerContext var1, I var2, Buffer var3) throws Exception;
}

