/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.CompositeBuffer;
import io.netty5.channel.ChannelHandlerAdapter;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.internal.DelegatingChannelHandlerContext;
import io.netty5.handler.codec.DecoderException;
import io.netty5.util.Send;
import io.netty5.util.internal.MathUtil;
import io.netty5.util.internal.StringUtil;
import java.util.Arrays;
import java.util.Objects;

public abstract class ByteToMessageDecoder
extends ChannelHandlerAdapter {
    public static final Cumulator MERGE_CUMULATOR = new MergeCumulator();
    public static final Cumulator COMPOSITE_CUMULATOR = new CompositeBufferCumulator();
    private final int discardAfterReads = 16;
    private final Cumulator cumulator;
    private Buffer cumulation;
    private boolean singleDecode;
    private boolean first;
    private boolean firedChannelRead;
    private int numReads;
    private ByteToMessageDecoderContext context;

    protected ByteToMessageDecoder() {
        this(MERGE_CUMULATOR);
    }

    protected ByteToMessageDecoder(Cumulator cumulator) {
        this.cumulator = Objects.requireNonNull(cumulator, "cumulator");
    }

    @Override
    public final boolean isSharable() {
        return false;
    }

    public void setSingleDecode(boolean singleDecode) {
        this.singleDecode = singleDecode;
    }

    public boolean isSingleDecode() {
        return this.singleDecode;
    }

    protected int actualReadableBytes() {
        return this.internalBuffer().readableBytes();
    }

    protected Buffer internalBuffer() {
        return this.cumulation;
    }

    @Override
    public final void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.context = new ByteToMessageDecoderContext(ctx);
        this.handlerAdded0(this.context);
    }

    protected void handlerAdded0(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public final void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        Buffer buf = this.cumulation;
        if (buf != null) {
            this.cumulation = null;
            this.numReads = 0;
            int readable = buf.readableBytes();
            if (readable > 0) {
                ctx.fireChannelRead(buf);
                ctx.fireChannelReadComplete();
            } else {
                buf.close();
            }
        }
        this.handlerRemoved0(this.context);
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof Buffer)) {
            ctx.fireChannelRead(msg);
            return;
        }
        try {
            Buffer data = (Buffer)msg;
            this.first = this.cumulation == null;
            this.cumulation = this.first ? data : this.cumulator.cumulate(ctx.bufferAllocator(), this.cumulation, data);
            assert (this.context.delegatingCtx() == ctx || ctx == this.context);
            this.callDecode(this.context, this.cumulation);
        }
        catch (DecoderException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new DecoderException(e2);
                }
            }
            catch (Throwable throwable) {
                if (this.cumulation != null && this.cumulation.readableBytes() == 0) {
                    this.numReads = 0;
                    if (this.cumulation.isAccessible()) {
                        this.cumulation.close();
                    }
                    this.cumulation = null;
                } else if (++this.numReads >= 16) {
                    this.numReads = 0;
                    this.discardSomeReadBytes();
                }
                this.firedChannelRead |= this.context.fireChannelReadCallCount() > 0;
                this.context.reset();
                throw throwable;
            }
        }
        if (this.cumulation != null && this.cumulation.readableBytes() == 0) {
            this.numReads = 0;
            if (this.cumulation.isAccessible()) {
                this.cumulation.close();
            }
            this.cumulation = null;
        } else if (++this.numReads >= 16) {
            this.numReads = 0;
            this.discardSomeReadBytes();
        }
        this.firedChannelRead |= this.context.fireChannelReadCallCount() > 0;
        this.context.reset();
        return;
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.numReads = 0;
        this.discardSomeReadBytes();
        if (!this.firedChannelRead && !ctx.channel().getOption(ChannelOption.AUTO_READ).booleanValue()) {
            ctx.read();
        }
        this.firedChannelRead = false;
        ctx.fireChannelReadComplete();
    }

    protected final void discardSomeReadBytes() {
        if (this.cumulation != null && !this.first) {
            this.cumulator.discardSomeReadBytes(this.cumulation);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        assert (this.context.delegatingCtx() == ctx || ctx == this.context);
        this.channelInputClosed(this.context, true);
    }

    @Override
    public void channelShutdown(ChannelHandlerContext ctx, ChannelShutdownDirection direction) throws Exception {
        ctx.fireChannelShutdown(direction);
        if (direction == ChannelShutdownDirection.Inbound) {
            assert (this.context.delegatingCtx() == ctx || ctx == this.context);
            this.channelInputClosed(this.context, false);
        }
    }

    private void channelInputClosed(ByteToMessageDecoderContext ctx, boolean callChannelInactive) {
        try {
            this.channelInputClosed(ctx);
        }
        catch (DecoderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DecoderException(e);
        }
        finally {
            if (this.cumulation != null) {
                this.cumulation.close();
                this.cumulation = null;
            }
            if (ctx.fireChannelReadCallCount() > 0) {
                ctx.reset();
                ctx.fireChannelReadComplete();
            }
            if (callChannelInactive) {
                ctx.fireChannelInactive();
            }
        }
    }

    void channelInputClosed(ByteToMessageDecoderContext ctx) throws Exception {
        if (this.cumulation != null) {
            this.callDecode(ctx, this.cumulation);
            if (!ctx.isRemoved()) {
                if (this.cumulation == null) {
                    try (Buffer buffer = ctx.bufferAllocator().allocate(0);){
                        this.decodeLast(ctx, buffer);
                    }
                } else {
                    this.decodeLast(ctx, this.cumulation);
                }
            }
        } else {
            try (Buffer buffer = ctx.bufferAllocator().allocate(0);){
                this.decodeLast(ctx, buffer);
            }
        }
    }

    void callDecode(ByteToMessageDecoderContext ctx, Buffer in) {
        try {
            while (in.readableBytes() > 0 && !ctx.isRemoved()) {
                int oldInputLength = in.readableBytes();
                int numReadCalled = ctx.fireChannelReadCallCount();
                this.decodeRemovalReentryProtection(ctx, in);
                if (!ctx.isRemoved()) {
                    if (numReadCalled == ctx.fireChannelReadCallCount()) {
                        if (oldInputLength != in.readableBytes()) continue;
                    } else {
                        if (oldInputLength == in.readableBytes()) {
                            throw new DecoderException(StringUtil.simpleClassName(this.getClass()) + ".decode() did not read anything but decoded a message.");
                        }
                        if (!this.isSingleDecode()) continue;
                    }
                }
                break;
            }
        }
        catch (DecoderException e) {
            throw e;
        }
        catch (Exception cause) {
            throw new DecoderException(cause);
        }
    }

    protected abstract void decode(ChannelHandlerContext var1, Buffer var2) throws Exception;

    final void decodeRemovalReentryProtection(ChannelHandlerContext ctx, Buffer in) throws Exception {
        this.decode(ctx, in);
    }

    protected void decodeLast(ChannelHandlerContext ctx, Buffer in) throws Exception {
        if (in.readableBytes() > 0) {
            this.decodeRemovalReentryProtection(ctx, in);
        }
    }

    private static final class MergeCumulator
    implements Cumulator {
        private MergeCumulator() {
        }

        @Override
        public Buffer cumulate(BufferAllocator alloc, Buffer cumulation, Buffer in) {
            if (cumulation.readableBytes() == 0) {
                cumulation.close();
                return in;
            }
            try (Buffer buffer = in;){
                int required = in.readableBytes();
                if (required > cumulation.writableBytes() || cumulation.readOnly()) {
                    Buffer buffer2 = MergeCumulator.expandCumulationAndWrite(alloc, cumulation, in);
                    return buffer2;
                }
                cumulation.writeBytes(in);
                Buffer buffer3 = cumulation;
                return buffer3;
            }
        }

        @Override
        public Buffer discardSomeReadBytes(Buffer cumulation) {
            if (cumulation.readerOffset() > cumulation.writableBytes()) {
                cumulation.compact();
            }
            return cumulation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Buffer expandCumulationAndWrite(BufferAllocator alloc, Buffer oldCumulation, Buffer in) {
            int newSize = MathUtil.safeFindNextPositivePowerOfTwo(oldCumulation.readableBytes() + in.readableBytes());
            Buffer newCumulation = oldCumulation.readOnly() ? alloc.allocate(newSize) : oldCumulation.ensureWritable(newSize);
            try {
                if (newCumulation != oldCumulation) {
                    newCumulation.writeBytes(oldCumulation);
                }
                newCumulation.writeBytes(in);
                Buffer buffer = newCumulation;
                return buffer;
            }
            finally {
                if (newCumulation != oldCumulation) {
                    oldCumulation.close();
                }
            }
        }

        public String toString() {
            return "MergeCumulator";
        }
    }

    private static final class CompositeBufferCumulator
    implements Cumulator {
        private CompositeBufferCumulator() {
        }

        @Override
        public Buffer cumulate(BufferAllocator alloc, Buffer cumulation, Buffer in) {
            if (cumulation.readableBytes() == 0) {
                cumulation.close();
                return in;
            }
            try (Buffer buffer = in;){
                if (in.readableBytes() == 0) {
                    Buffer buffer2 = cumulation;
                    return buffer2;
                }
                if (cumulation.readOnly()) {
                    Buffer tmp = cumulation.copy();
                    cumulation.close();
                    cumulation = tmp;
                }
                if (CompositeBuffer.isComposite(cumulation)) {
                    CompositeBuffer composite = (CompositeBuffer)cumulation;
                    composite.extendWith(CompositeBufferCumulator.prepareInForCompose(in));
                    CompositeBuffer compositeBuffer = composite;
                    return compositeBuffer;
                }
                CompositeBuffer compositeBuffer = alloc.compose(Arrays.asList(cumulation.send(), CompositeBufferCumulator.prepareInForCompose(in)));
                return compositeBuffer;
            }
        }

        private static Send<Buffer> prepareInForCompose(Buffer in) {
            return in.readOnly() ? in.copy().send() : in.send();
        }

        @Override
        public Buffer discardSomeReadBytes(Buffer cumulation) {
            cumulation.readSplit(0).close();
            return cumulation;
        }

        public String toString() {
            return "CompositeBufferCumulator";
        }
    }

    static final class ByteToMessageDecoderContext
    extends DelegatingChannelHandlerContext {
        private int fireChannelReadCalled;

        private ByteToMessageDecoderContext(ChannelHandlerContext ctx) {
            super(ctx);
        }

        void reset() {
            this.fireChannelReadCalled = 0;
        }

        int fireChannelReadCallCount() {
            return this.fireChannelReadCalled;
        }

        @Override
        public ChannelHandlerContext fireChannelRead(Object msg) {
            ++this.fireChannelReadCalled;
            super.fireChannelRead(msg);
            return this;
        }
    }

    public static interface Cumulator {
        public Buffer cumulate(BufferAllocator var1, Buffer var2, Buffer var3);

        public Buffer discardSomeReadBytes(Buffer var1);
    }
}

