/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.address;

import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.util.concurrent.Future;
import java.net.SocketAddress;

public abstract class DynamicAddressConnectHandler
implements ChannelHandler {
    @Override
    public final Future<Void> connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress) {
        SocketAddress local;
        SocketAddress remote;
        try {
            remote = this.remoteAddress(remoteAddress, localAddress);
            local = this.localAddress(remoteAddress, localAddress);
        }
        catch (Exception e) {
            return ctx.newFailedFuture(e);
        }
        return ctx.connect(remote, local).addListener(future -> {
            if (future.isSuccess()) {
                ctx.pipeline().remove(this);
            }
        });
    }

    protected SocketAddress localAddress(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        return localAddress;
    }

    protected SocketAddress remoteAddress(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        return remoteAddress;
    }
}

