/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.unix;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.BufferUtil;
import io.netty5.buffer.ComponentIterator;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.channel.unix.FileDescriptor;
import io.netty5.util.Resource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;

public abstract class SocketWritableByteChannel
implements WritableByteChannel {
    private final FileDescriptor fd;

    protected SocketWritableByteChannel(FileDescriptor fd) {
        this.fd = Objects.requireNonNull(fd, "fd");
    }

    protected int write(ByteBuffer buf, int pos, int limit) throws IOException {
        return this.fd.write(buf, pos, limit);
    }

    @Override
    public final int write(ByteBuffer src) throws IOException {
        int written;
        int position = src.position();
        int limit = src.limit();
        if (src.isDirect()) {
            written = this.write(src, position, src.limit());
        } else {
            int readableBytes = limit - position;
            BufferAllocator alloc = this.alloc();
            Buffer buffer = null;
            boolean dispose = true;
            try {
                if (alloc.isPooling() && alloc.getAllocationType().isDirect()) {
                    buffer = alloc.allocate(readableBytes);
                } else {
                    buffer = BufferUtil.threadLocalDirectBuffer();
                    if (buffer == null) {
                        buffer = DefaultBufferAllocators.offHeapAllocator().allocate(readableBytes);
                    } else {
                        dispose = false;
                    }
                }
                buffer.writeBytes(src.duplicate());
                try (ComponentIterator iterator = buffer.forEachComponent();){
                    BufferComponent component = (BufferComponent)iterator.firstReadable();
                    ByteBuffer nioBuffer = component.readableBuffer();
                    written = this.write(nioBuffer, nioBuffer.position(), nioBuffer.limit());
                    assert (((ComponentIterator.Next)((Object)component)).next() == null);
                }
            }
            finally {
                if (dispose) {
                    Resource.dispose(buffer);
                }
            }
        }
        if (written > 0) {
            src.position(position + written);
        }
        return written;
    }

    @Override
    public final boolean isOpen() {
        return this.fd.isOpen();
    }

    @Override
    public final void close() throws IOException {
        this.fd.close();
    }

    protected abstract BufferAllocator alloc();
}

