/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.socket.nio;

import io.netty5.buffer.Buffer;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.ChannelException;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.EventLoop;
import io.netty5.channel.FileRegion;
import io.netty5.channel.nio.AbstractNioByteChannel;
import io.netty5.channel.socket.SocketChannel;
import io.netty5.channel.socket.SocketChannelWriteHandleFactory;
import io.netty5.channel.socket.nio.ByteBufferCollector;
import io.netty5.channel.socket.nio.NioChannelOption;
import io.netty5.channel.socket.nio.NioChannelUtil;
import io.netty5.channel.socket.nio.NioServerSocketChannel;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.GlobalEventExecutor;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.SocketUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.Executor;

public class NioSocketChannel
extends AbstractNioByteChannel<NioServerSocketChannel, SocketAddress, SocketAddress>
implements SocketChannel {
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private static final Method OPEN_SOCKET_CHANNEL_WITH_FAMILY = NioChannelUtil.findOpenMethod("openSocketChannel");
    private final ProtocolFamily family;
    private final ByteBufferCollector collector = new ByteBufferCollector();
    private volatile boolean inputShutdown;
    private volatile boolean outputShutdown;

    private static java.nio.channels.SocketChannel newChannel(SelectorProvider provider, ProtocolFamily family) {
        try {
            java.nio.channels.SocketChannel channel = (java.nio.channels.SocketChannel)NioChannelUtil.newChannel(OPEN_SOCKET_CHANNEL_WITH_FAMILY, provider, family);
            return channel == null ? provider.openSocketChannel() : channel;
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a socket.", e);
        }
    }

    public NioSocketChannel(EventLoop eventLoop) {
        this(eventLoop, DEFAULT_SELECTOR_PROVIDER);
    }

    public NioSocketChannel(EventLoop eventLoop, SelectorProvider provider) {
        this(eventLoop, provider, null);
    }

    public NioSocketChannel(EventLoop eventLoop, SelectorProvider provider, ProtocolFamily family) {
        this(null, eventLoop, NioSocketChannel.newChannel(provider, NioChannelUtil.toJdkFamily(family)), family);
    }

    public NioSocketChannel(EventLoop eventLoop, java.nio.channels.SocketChannel socket) {
        this(null, eventLoop, socket, null);
    }

    public NioSocketChannel(NioServerSocketChannel parent, EventLoop eventLoop, java.nio.channels.SocketChannel socket) {
        this(parent, eventLoop, socket, null);
    }

    public NioSocketChannel(NioServerSocketChannel parent, EventLoop eventLoop, java.nio.channels.SocketChannel socket, ProtocolFamily family) {
        super(parent, eventLoop, new SocketChannelWriteHandleFactory(Integer.MAX_VALUE), socket);
        this.family = NioChannelUtil.toJdkFamily(family);
        if (!NioChannelUtil.isDomainSocket(family) && PlatformDependent.canEnableTcpNoDelayByDefault()) {
            try {
                this.javaChannel().setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected java.nio.channels.SocketChannel javaChannel() {
        return (java.nio.channels.SocketChannel)super.javaChannel();
    }

    @Override
    public boolean isActive() {
        java.nio.channels.SocketChannel ch = this.javaChannel();
        return ch.isOpen() && ch.isConnected();
    }

    @Override
    public boolean isShutdown(ChannelShutdownDirection direction) {
        if (!this.isActive()) {
            return true;
        }
        switch (direction) {
            case Outbound: {
                return this.outputShutdown;
            }
            case Inbound: {
                return this.inputShutdown;
            }
        }
        throw new AssertionError();
    }

    @Override
    protected void doShutdown(ChannelShutdownDirection direction) throws Exception {
        switch (direction) {
            case Inbound: {
                this.javaChannel().shutdownInput();
                this.inputShutdown = true;
                break;
            }
            case Outbound: {
                this.javaChannel().shutdownOutput();
                this.outputShutdown = true;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    protected SocketAddress localAddress0() {
        try {
            SocketAddress address = this.javaChannel().getLocalAddress();
            if (NioChannelUtil.isDomainSocket(this.family)) {
                return NioChannelUtil.toDomainSocketAddress(address);
            }
            return address;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected SocketAddress remoteAddress0() {
        try {
            SocketAddress address = this.javaChannel().getRemoteAddress();
            if (NioChannelUtil.isDomainSocket(this.family)) {
                return NioChannelUtil.toDomainSocketAddress(address);
            }
            return address;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        this.doBind0(localAddress);
    }

    private void doBind0(SocketAddress localAddress) throws Exception {
        if (NioChannelUtil.isDomainSocket(this.family)) {
            localAddress = NioChannelUtil.toUnixDomainSocketAddress(localAddress);
        }
        SocketUtils.bind(this.javaChannel(), localAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress, Buffer data) throws Exception {
        if (localAddress != null) {
            this.doBind0(localAddress);
        }
        boolean success = false;
        try {
            boolean connected;
            if (NioChannelUtil.isDomainSocket(this.family)) {
                remoteAddress = NioChannelUtil.toUnixDomainSocketAddress(remoteAddress);
            }
            if (!(connected = SocketUtils.connect(this.javaChannel(), remoteAddress))) {
                this.selectionKey().interestOps(8);
            }
            success = true;
            boolean bl = connected;
            return bl;
        }
        finally {
            if (!success) {
                this.doClose();
            }
        }
    }

    @Override
    protected boolean doFinishConnect(SocketAddress requestedRemoteAddress) throws Exception {
        return this.javaChannel().finishConnect();
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    @Override
    protected int doReadBytes(Buffer buffer) throws Exception {
        return buffer.transferFrom(this.javaChannel(), buffer.writableBytes());
    }

    @Override
    protected int doWriteBytes(Buffer buf) throws Exception {
        int expectedWrittenBytes = buf.readableBytes();
        return buf.transferTo(this.javaChannel(), expectedWrittenBytes);
    }

    @Override
    protected long doWriteFileRegion(FileRegion region) throws Exception {
        long position = region.transferred();
        return region.transferTo(this.javaChannel(), position);
    }

    @Override
    protected void doWriteNow(AbstractChannel.WriteSink writeSink) throws Exception {
        long localWrittenBytes;
        long attemptedBytes;
        java.nio.channels.SocketChannel ch = this.javaChannel();
        this.collector.prepare(1024, writeSink.estimatedMaxBytesPerGatheringWrite());
        writeSink.forEachFlushedMessage(this.collector);
        ByteBuffer[] nioBuffers = this.collector.nioBuffers();
        int nioBufferCnt = this.collector.nioBufferCount();
        switch (nioBufferCnt) {
            case 0: {
                super.doWriteNow(writeSink);
                return;
            }
            case 1: {
                ByteBuffer buffer = nioBuffers[0];
                attemptedBytes = buffer.remaining();
                localWrittenBytes = ch.write(buffer);
                break;
            }
            default: {
                attemptedBytes = this.collector.nioBufferSize();
                localWrittenBytes = ch.write(nioBuffers, 0, nioBufferCnt);
            }
        }
        int messages = writeSink.updateBufferReaderOffsets(localWrittenBytes);
        writeSink.complete(attemptedBytes, localWrittenBytes, messages, localWrittenBytes > 0L);
    }

    @Override
    protected Future<Executor> prepareToClose() {
        if (!NioChannelUtil.isDomainSocket(this.family)) {
            try {
                if (this.javaChannel().isOpen() && this.getOption(ChannelOption.SO_LINGER) > 0) {
                    return this.executor().deregisterForIo(this).map(v -> GlobalEventExecutor.INSTANCE);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected <T> T getExtendedOption(ChannelOption<T> option) {
        SocketOption<T> socketOption = NioChannelOption.toSocketOption(option);
        if (socketOption != null) {
            return NioChannelOption.getOption(this.javaChannel(), socketOption);
        }
        return super.getExtendedOption(option);
    }

    @Override
    protected <T> void setExtendedOption(ChannelOption<T> option, T value) {
        SocketOption<T> socketOption = NioChannelOption.toSocketOption(option);
        if (socketOption != null) {
            NioChannelOption.setOption(this.javaChannel(), socketOption, value);
        } else {
            super.setExtendedOption(option, value);
        }
    }

    @Override
    protected boolean isExtendedOptionSupported(ChannelOption<?> option) {
        SocketOption<?> socketOption = NioChannelOption.toSocketOption(option);
        if (socketOption != null) {
            return NioChannelOption.isOptionSupported(this.javaChannel(), socketOption);
        }
        return super.isExtendedOptionSupported(option);
    }
}

