/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.socket.nio;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ComponentIterator;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.AddressedEnvelope;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelException;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.DefaultBufferAddressedEnvelope;
import io.netty5.channel.EventLoop;
import io.netty5.channel.FixedReadHandleFactory;
import io.netty5.channel.MaxMessagesWriteHandleFactory;
import io.netty5.channel.nio.AbstractNioMessageChannel;
import io.netty5.channel.socket.DatagramChannel;
import io.netty5.channel.socket.DatagramPacket;
import io.netty5.channel.socket.nio.NioChannelOption;
import io.netty5.channel.socket.nio.NioChannelUtil;
import io.netty5.util.Resource;
import io.netty5.util.concurrent.Future;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.SocketUtils;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.MembershipKey;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class NioDatagramChannel
extends AbstractNioMessageChannel<Channel, SocketAddress, SocketAddress>
implements DatagramChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioDatagramChannel.class);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + "<" + StringUtil.simpleClassName(Buffer.class) + ", " + StringUtil.simpleClassName(SocketAddress.class) + ">, " + StringUtil.simpleClassName(Buffer.class) + ")";
    private final ProtocolFamily family;
    private volatile boolean inputShutdown;
    private volatile boolean outputShutdown;
    private Map<InetAddress, List<MembershipKey>> memberships;
    private volatile boolean activeOnOpen;
    private volatile boolean bound;

    private static java.nio.channels.DatagramChannel newSocket(SelectorProvider provider) {
        try {
            return provider.openDatagramChannel();
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a socket.", e);
        }
    }

    private static java.nio.channels.DatagramChannel newSocket(SelectorProvider provider, ProtocolFamily family) {
        if (family == null) {
            return NioDatagramChannel.newSocket(provider);
        }
        try {
            return provider.openDatagramChannel(family);
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a socket.", e);
        }
    }

    public NioDatagramChannel(EventLoop eventLoop) {
        this(eventLoop, NioDatagramChannel.newSocket(DEFAULT_SELECTOR_PROVIDER), null);
    }

    public NioDatagramChannel(EventLoop eventLoop, SelectorProvider provider) {
        this(eventLoop, NioDatagramChannel.newSocket(provider), null);
    }

    public NioDatagramChannel(EventLoop eventLoop, ProtocolFamily family) {
        this(eventLoop, DEFAULT_SELECTOR_PROVIDER, family);
    }

    public NioDatagramChannel(EventLoop eventLoop, SelectorProvider provider, ProtocolFamily family) {
        this(eventLoop, NioDatagramChannel.newSocket(provider, NioChannelUtil.toJdkFamily(family)), family);
    }

    public NioDatagramChannel(EventLoop eventLoop, java.nio.channels.DatagramChannel socket, ProtocolFamily family) {
        super(null, eventLoop, true, new FixedReadHandleFactory(2048), new MaxMessagesWriteHandleFactory(Integer.MAX_VALUE), socket, 1);
        this.family = NioChannelUtil.toJdkFamily(family);
    }

    @Override
    protected <T> T getExtendedOption(ChannelOption<T> option) {
        if (option == ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) {
            return (T)Boolean.valueOf(this.isActiveOnOpen());
        }
        SocketOption<T> socketOption = NioChannelOption.toSocketOption(option);
        if (socketOption != null) {
            return NioChannelOption.getOption(this.javaChannel(), socketOption);
        }
        return super.getExtendedOption(option);
    }

    @Override
    protected <T> void setExtendedOption(ChannelOption<T> option, T value) {
        if (option == ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) {
            this.setActiveOnOpen((Boolean)value);
        } else {
            SocketOption<T> socketOption = NioChannelOption.toSocketOption(option);
            if (socketOption != null) {
                try {
                    if (!(socketOption != StandardSocketOptions.SO_BROADCAST || this.isAnyLocalAddress() || PlatformDependent.isWindows() || PlatformDependent.maybeSuperUser())) {
                        logger.warn("A non-root user can't receive a broadcast packet if the socket is not bound to a wildcard address; setting the SO_BROADCAST flag anyway as requested on the socket which is bound to " + this.javaChannel().getLocalAddress() + ".");
                    }
                    NioChannelOption.setOption(this.javaChannel(), socketOption, value);
                }
                catch (IOException e) {
                    throw new ChannelException(e);
                }
            } else {
                super.setExtendedOption(option, value);
            }
        }
    }

    @Override
    protected boolean isExtendedOptionSupported(ChannelOption<?> option) {
        if (option == ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) {
            return true;
        }
        SocketOption<?> socketOption = NioChannelOption.toSocketOption(option);
        if (socketOption != null) {
            return NioChannelOption.isOptionSupported(this.javaChannel(), socketOption);
        }
        return super.isExtendedOptionSupported(option);
    }

    private boolean isActiveOnOpen() {
        return this.activeOnOpen;
    }

    private void setActiveOnOpen(boolean activeOnOpen) {
        if (this.isRegistered()) {
            throw new IllegalStateException("Can only changed before channel was registered");
        }
        this.activeOnOpen = activeOnOpen;
    }

    private boolean isAnyLocalAddress() throws IOException {
        SocketAddress address = this.javaChannel().getLocalAddress();
        return address instanceof InetSocketAddress && ((InetSocketAddress)address).getAddress().isAnyLocalAddress();
    }

    private NetworkInterface getNetworkInterface() {
        try {
            return this.javaChannel().getOption(StandardSocketOptions.IP_MULTICAST_IF);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    protected void doShutdown(ChannelShutdownDirection direction) {
        switch (direction) {
            case Inbound: {
                this.inputShutdown = true;
                break;
            }
            case Outbound: {
                this.outputShutdown = true;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public boolean isShutdown(ChannelShutdownDirection direction) {
        if (!this.isActive()) {
            return true;
        }
        switch (direction) {
            case Inbound: {
                return this.inputShutdown;
            }
            case Outbound: {
                return this.outputShutdown;
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean isActive() {
        java.nio.channels.DatagramChannel ch = this.javaChannel();
        return ch.isOpen() && (this.getOption(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) != false && this.isRegistered() || this.bound);
    }

    @Override
    public boolean isConnected() {
        return this.javaChannel().isConnected();
    }

    @Override
    protected java.nio.channels.DatagramChannel javaChannel() {
        return (java.nio.channels.DatagramChannel)super.javaChannel();
    }

    @Override
    protected SocketAddress localAddress0() {
        try {
            SocketAddress address = this.javaChannel().getLocalAddress();
            if (NioChannelUtil.isDomainSocket(this.family)) {
                return NioChannelUtil.toDomainSocketAddress(address);
            }
            return address;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected SocketAddress remoteAddress0() {
        try {
            SocketAddress address = this.javaChannel().getRemoteAddress();
            if (NioChannelUtil.isDomainSocket(this.family)) {
                return NioChannelUtil.toDomainSocketAddress(address);
            }
            return address;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        this.doBind0(localAddress);
    }

    private void doBind0(SocketAddress localAddress) throws Exception {
        if (NioChannelUtil.isDomainSocket(this.family)) {
            localAddress = NioChannelUtil.toUnixDomainSocketAddress(localAddress);
        }
        SocketUtils.bind(this.javaChannel(), localAddress);
        this.bound = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress, Buffer initialData) throws Exception {
        if (localAddress != null) {
            this.doBind0(localAddress);
        }
        boolean success = false;
        try {
            this.javaChannel().connect(remoteAddress);
            this.bound = true;
            success = true;
            boolean bl = true;
            return bl;
        }
        finally {
            if (!success) {
                this.doClose();
            }
        }
    }

    @Override
    protected boolean doFinishConnect(SocketAddress requestedRemoteAddress) {
        return true;
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.javaChannel().disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doReadMessages(AbstractChannel.ReadSink readSink) throws Exception {
        Buffer data = readSink.allocateBuffer();
        if (data == null) {
            readSink.processRead(0, 0, null);
            return 0;
        }
        int attemptedBytesRead = data.writableBytes();
        boolean free = true;
        try {
            SocketAddress remoteAddress = null;
            int actualBytesRead = 0;
            try (ComponentIterator iterator = data.forEachComponent();){
                BufferComponent component = (BufferComponent)iterator.firstWritable();
                if (component != null) {
                    ByteBuffer dst = component.writableBuffer();
                    int position = dst.position();
                    remoteAddress = this.javaChannel().receive(dst);
                    actualBytesRead = dst.position() - position;
                }
            }
            if (remoteAddress == null) {
                readSink.processRead(attemptedBytesRead, 0, null);
                int n = -1;
                return n;
            }
            data.skipWritableBytes(actualBytesRead);
            readSink.processRead(attemptedBytesRead, actualBytesRead, new DatagramPacket(data, (SocketAddress)this.localAddress(), remoteAddress));
            free = false;
            int n = 1;
            return n;
        }
        finally {
            if (free) {
                data.close();
            }
        }
    }

    @Override
    protected void doWriteNow(AbstractChannel.WriteSink writeSink) throws Exception {
        Buffer buf;
        SocketAddress remoteAddress;
        Object msg = writeSink.currentFlushedMessage();
        if (msg instanceof AddressedEnvelope) {
            AddressedEnvelope envelope = (AddressedEnvelope)msg;
            remoteAddress = (SocketAddress)envelope.recipient();
            buf = (Buffer)envelope.content();
        } else {
            buf = (Buffer)msg;
            remoteAddress = null;
        }
        int length = buf.readableBytes();
        if (length == 0) {
            writeSink.complete(0L, 0L, 1, true);
            return;
        }
        int readable = buf.readableBytes();
        try {
            int writtenBytes;
            if (buf.countReadableComponents() > 1) {
                try (Buffer copy = this.bufferAllocator().allocate(buf.readableBytes());){
                    buf.copyInto(buf.readerOffset(), copy, copy.writerOffset(), buf.readableBytes());
                    copy.writerOffset(buf.readableBytes());
                    writtenBytes = this.write(copy, remoteAddress);
                }
            } else {
                writtenBytes = this.write(buf, remoteAddress);
            }
            writeSink.complete(readable, writtenBytes, writtenBytes > 0 ? 1 : 0, writtenBytes > 0);
        }
        catch (Throwable e) {
            writeSink.complete(readable, e, true);
        }
    }

    private int write(Buffer buf, SocketAddress remoteAddress) throws IOException {
        assert (buf.countReadableComponents() <= 1);
        try (ComponentIterator iterator = buf.forEachComponent();){
            BufferComponent c = (BufferComponent)iterator.firstReadable();
            int writtenBytes = remoteAddress != null ? this.javaChannel().send(c.readableBuffer(), remoteAddress) : this.javaChannel().write(c.readableBuffer());
            int n = writtenBytes;
            return n;
        }
    }

    @Override
    protected Object filterOutboundMessage(Object msg) {
        AddressedEnvelope e;
        Object content;
        if (msg instanceof DatagramPacket) {
            DatagramPacket p = (DatagramPacket)msg;
            Buffer content2 = (Buffer)p.content();
            if (NioDatagramChannel.isSingleDirectBuffer(content2)) {
                return p;
            }
            return new DatagramPacket(this.newDirectBuffer(p, content2), (SocketAddress)p.recipient());
        }
        if (msg instanceof Buffer) {
            Buffer buf = (Buffer)msg;
            if (NioDatagramChannel.isSingleDirectBuffer(buf)) {
                return buf;
            }
            return this.newDirectBuffer(buf);
        }
        if (msg instanceof AddressedEnvelope && (content = (e = (AddressedEnvelope)msg).content()) instanceof Buffer) {
            Buffer buf = (Buffer)content;
            if (NioDatagramChannel.isSingleDirectBuffer(buf)) {
                return e;
            }
            return new DefaultBufferAddressedEnvelope(this.newDirectBuffer((Resource)((Object)e), buf), e.recipient());
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(msg) + EXPECTED_TYPES);
    }

    private static boolean isSingleDirectBuffer(Buffer buf) {
        return buf.isDirect() && buf.countComponents() == 1;
    }

    private NetworkInterface networkInterface() throws SocketException {
        NetworkInterface iface = this.getNetworkInterface();
        if (iface == null) {
            Object localAddress = this.localAddress();
            if (localAddress instanceof InetSocketAddress) {
                return NetworkInterface.getByInetAddress(((InetSocketAddress)this.localAddress()).getAddress());
            }
            throw new UnsupportedOperationException();
        }
        return iface;
    }

    @Override
    public Future<Void> joinGroup(InetAddress multicastAddress) {
        try {
            return this.joinGroup(multicastAddress, this.networkInterface(), null);
        }
        catch (UnsupportedOperationException | SocketException e) {
            return this.newFailedFuture(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        Objects.requireNonNull(multicastAddress, "multicastAddress");
        Objects.requireNonNull(networkInterface, "networkInterface");
        try {
            MembershipKey key = source == null ? this.javaChannel().join(multicastAddress, networkInterface) : this.javaChannel().join(multicastAddress, networkInterface, source);
            NioDatagramChannel nioDatagramChannel = this;
            synchronized (nioDatagramChannel) {
                List<MembershipKey> keys = null;
                if (this.memberships == null) {
                    this.memberships = new HashMap<InetAddress, List<MembershipKey>>();
                } else {
                    keys = this.memberships.get(multicastAddress);
                }
                if (keys == null) {
                    keys = new ArrayList<MembershipKey>();
                    this.memberships.put(multicastAddress, keys);
                }
                keys.add(key);
            }
            return this.newSucceededFuture();
        }
        catch (Throwable e) {
            return this.newFailedFuture(e);
        }
    }

    @Override
    public Future<Void> leaveGroup(InetAddress multicastAddress) {
        try {
            return this.leaveGroup(multicastAddress, this.networkInterface(), null);
        }
        catch (UnsupportedOperationException | SocketException e) {
            return this.newFailedFuture(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        Objects.requireNonNull(multicastAddress, "multicastAddress");
        Objects.requireNonNull(networkInterface, "networkInterface");
        NioDatagramChannel nioDatagramChannel = this;
        synchronized (nioDatagramChannel) {
            List<MembershipKey> keys;
            if (this.memberships != null && (keys = this.memberships.get(multicastAddress)) != null) {
                Iterator<MembershipKey> keyIt = keys.iterator();
                while (keyIt.hasNext()) {
                    MembershipKey key = keyIt.next();
                    if (!networkInterface.equals(key.networkInterface()) || (source != null || key.sourceAddress() != null) && (source == null || !source.equals(key.sourceAddress()))) continue;
                    key.drop();
                    keyIt.remove();
                }
                if (keys.isEmpty()) {
                    this.memberships.remove(multicastAddress);
                }
            }
        }
        return this.newSucceededFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock) {
        Objects.requireNonNull(multicastAddress, "multicastAddress");
        Objects.requireNonNull(sourceToBlock, "sourceToBlock");
        Objects.requireNonNull(networkInterface, "networkInterface");
        NioDatagramChannel nioDatagramChannel = this;
        synchronized (nioDatagramChannel) {
            if (this.memberships != null) {
                List<MembershipKey> keys = this.memberships.get(multicastAddress);
                for (MembershipKey key : keys) {
                    if (!networkInterface.equals(key.networkInterface())) continue;
                    try {
                        key.block(sourceToBlock);
                    }
                    catch (IOException e) {
                        return this.newFailedFuture(e);
                    }
                }
            }
        }
        return this.newSucceededFuture();
    }

    @Override
    public Future<Void> block(InetAddress multicastAddress, InetAddress sourceToBlock) {
        try {
            return this.block(multicastAddress, this.networkInterface(), sourceToBlock);
        }
        catch (UnsupportedOperationException | SocketException e) {
            return this.newFailedFuture(e);
        }
    }
}

