/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.socket.nio;

import io.netty5.channel.ChannelException;
import io.netty5.channel.ChannelOption;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ServerSocketChannel;

public final class NioChannelOption<T>
extends ChannelOption<T> {
    private final SocketOption<T> option;

    private NioChannelOption(SocketOption<T> option) {
        super(option.name());
        this.option = option;
    }

    public static <T> ChannelOption<T> of(SocketOption<T> option) {
        return new NioChannelOption<T>(option);
    }

    static <T> void setOption(NetworkChannel channel, SocketOption<T> option, T value) {
        if (channel instanceof ServerSocketChannel && option == StandardSocketOptions.IP_TOS) {
            return;
        }
        try {
            channel.setOption(option, value);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    static <T> T getOption(NetworkChannel channel, SocketOption<T> option) {
        if (channel instanceof ServerSocketChannel && option == StandardSocketOptions.IP_TOS) {
            return null;
        }
        try {
            return channel.getOption(option);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    static boolean isOptionSupported(NetworkChannel channel, SocketOption<?> option) {
        return channel.supportedOptions().contains(option);
    }

    static <T> SocketOption<T> toSocketOption(ChannelOption<T> option) {
        if (option instanceof NioChannelOption) {
            return ((NioChannelOption)option).option;
        }
        if (option == SO_RCVBUF) {
            return StandardSocketOptions.SO_RCVBUF;
        }
        if (option == SO_SNDBUF) {
            return StandardSocketOptions.SO_SNDBUF;
        }
        if (option == TCP_NODELAY) {
            return StandardSocketOptions.TCP_NODELAY;
        }
        if (option == SO_KEEPALIVE) {
            return StandardSocketOptions.SO_KEEPALIVE;
        }
        if (option == SO_REUSEADDR) {
            return StandardSocketOptions.SO_REUSEADDR;
        }
        if (option == SO_LINGER) {
            return StandardSocketOptions.SO_LINGER;
        }
        if (option == SO_BROADCAST) {
            return StandardSocketOptions.SO_BROADCAST;
        }
        if (option == IP_MULTICAST_LOOP_DISABLED) {
            return StandardSocketOptions.IP_MULTICAST_LOOP;
        }
        if (option == IP_MULTICAST_IF) {
            return StandardSocketOptions.IP_MULTICAST_IF;
        }
        if (option == IP_MULTICAST_TTL) {
            return StandardSocketOptions.IP_MULTICAST_TTL;
        }
        if (option == IP_TOS) {
            return StandardSocketOptions.IP_TOS;
        }
        return null;
    }
}

