/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.socket;

import io.netty5.channel.Channel;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.MaxMessagesWriteHandleFactory;
import io.netty5.util.internal.ObjectUtil;

public final class SocketChannelWriteHandleFactory
extends MaxMessagesWriteHandleFactory {
    private static final int MAX_BYTES_PER_GATHERING_WRITE_ATTEMPTED_LOW_THRESHOLD = 4096;
    private final long maxBytesPerGatheringWrite;

    public SocketChannelWriteHandleFactory(int maxMessagesPerWrite) {
        this(maxMessagesPerWrite, Long.MAX_VALUE);
    }

    public SocketChannelWriteHandleFactory(int maxMessagesPerWrite, long maxBytesPerGatheringWrite) {
        super(maxMessagesPerWrite);
        this.maxBytesPerGatheringWrite = ObjectUtil.checkPositive(maxBytesPerGatheringWrite, "maxBytesPerGatheringWrite");
    }

    @Override
    protected MaxMessagesWriteHandleFactory.MaxMessagesWriteHandle newHandle(Channel channel, int maxMessagesPerWrite) {
        return new SndBufferWriteHandle(channel, maxMessagesPerWrite, this.maxBytesPerGatheringWrite);
    }

    private static final class SndBufferWriteHandle
    extends MaxMessagesWriteHandleFactory.MaxMessagesWriteHandle {
        private final long maxBytesPerGatheringWrite;
        private long calculatedMaxBytesPerGatheringWrite;

        SndBufferWriteHandle(Channel channel, int maxMessagesPerWrite, long maxBytesPerGatheringWrite) {
            super(maxMessagesPerWrite);
            this.maxBytesPerGatheringWrite = maxBytesPerGatheringWrite;
            this.calculatedMaxBytesPerGatheringWrite = SndBufferWriteHandle.calculateMaxBytesPerGatheringWrite(channel, maxBytesPerGatheringWrite);
        }

        @Override
        public boolean lastWrite(long attemptedBytesWrite, long actualBytesWrite, int numMessagesWrite) {
            boolean continueWriting = super.lastWrite(attemptedBytesWrite, actualBytesWrite, numMessagesWrite);
            this.adjustMaxBytesPerGatheringWrite(attemptedBytesWrite, actualBytesWrite, this.maxBytesPerGatheringWrite);
            return continueWriting;
        }

        @Override
        public long estimatedMaxBytesPerGatheringWrite() {
            return this.calculatedMaxBytesPerGatheringWrite;
        }

        private static long calculateMaxBytesPerGatheringWrite(Channel channel, long maxBytesPerGatheringWrite) {
            int newSendBufferSize = channel.getOption(ChannelOption.SO_SNDBUF) << 1;
            if (newSendBufferSize > 0) {
                return Math.min((long)newSendBufferSize, maxBytesPerGatheringWrite);
            }
            return maxBytesPerGatheringWrite;
        }

        private void adjustMaxBytesPerGatheringWrite(long attempted, long written, long oldMaxBytesPerGatheringWrite) {
            if (attempted == written) {
                if (attempted << 1 > oldMaxBytesPerGatheringWrite) {
                    this.calculatedMaxBytesPerGatheringWrite = Math.min(this.maxBytesPerGatheringWrite, attempted << 1);
                }
            } else if (attempted > 4096L && written < attempted >>> 1) {
                this.calculatedMaxBytesPerGatheringWrite = Math.min(this.maxBytesPerGatheringWrite, attempted >>> 1);
            }
        }
    }
}

