/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.nio;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelException;
import io.netty5.channel.EventLoop;
import io.netty5.channel.ReadHandleFactory;
import io.netty5.channel.WriteHandleFactory;
import io.netty5.channel.nio.NioProcessor;
import io.netty5.util.Resource;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;

public abstract class AbstractNioChannel<P extends Channel, L extends SocketAddress, R extends SocketAddress>
extends AbstractChannel<P, L, R> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractNioChannel.class);
    private final SelectableChannel ch;
    private final int readInterestOp;
    private volatile SelectionKey selectionKey;
    private final NioProcessor nioProcessor = new NioProcessor(){

        @Override
        public void register(Selector selector) throws ClosedChannelException {
            int interestOps;
            SelectionKey key = AbstractNioChannel.this.selectionKey;
            if (key != null) {
                interestOps = key.interestOps();
                key.cancel();
            } else {
                interestOps = 0;
            }
            AbstractNioChannel.this.selectionKey = AbstractNioChannel.this.javaChannel().register(selector, interestOps, this);
        }

        @Override
        public void deregister() {
            SelectionKey key = AbstractNioChannel.this.selectionKey;
            if (key != null) {
                key.cancel();
                AbstractNioChannel.this.selectionKey = null;
            }
        }

        @Override
        public void handle(SelectionKey k) {
            if (!k.isValid()) {
                AbstractNioChannel.this.closeTransportNow();
                return;
            }
            try {
                int readyOps = k.readyOps();
                if ((readyOps & 8) != 0) {
                    int ops = k.interestOps();
                    k.interestOps(ops &= 0xFFFFFFF7);
                    AbstractNioChannel.this.finishConnectNow();
                }
                if ((readyOps & 4) != 0) {
                    AbstractNioChannel.this.writeFlushedNow();
                }
                if ((readyOps & 0x11) != 0 || readyOps == 0) {
                    AbstractNioChannel.this.readNow();
                }
            }
            catch (CancelledKeyException ignored) {
                AbstractNioChannel.this.closeTransportNow();
            }
        }

        @Override
        public void close() {
            AbstractNioChannel.this.closeTransportNow();
        }
    };

    protected AbstractNioChannel(P parent, EventLoop eventLoop, boolean supportingDisconnect, ReadHandleFactory defaultReadHandleFactory, WriteHandleFactory defaultWriteHandleFactory, SelectableChannel ch, int readInterestOp) {
        super(parent, eventLoop, supportingDisconnect, defaultReadHandleFactory, defaultWriteHandleFactory);
        this.ch = ch;
        this.readInterestOp = readInterestOp;
        try {
            ch.configureBlocking(false);
        }
        catch (IOException e) {
            try {
                ch.close();
            }
            catch (IOException e2) {
                logger.warn("Failed to close a partially initialized socket.", e2);
            }
            throw new ChannelException("Failed to enter non-blocking mode.", e);
        }
    }

    @Override
    public final boolean isOpen() {
        return this.ch.isOpen();
    }

    protected SelectableChannel javaChannel() {
        return this.ch;
    }

    protected final SelectionKey selectionKey() {
        return this.selectionKey;
    }

    @Override
    protected final void doClearScheduledRead() {
        SelectionKey key = this.selectionKey();
        if (key == null || !key.isValid()) {
            return;
        }
        int interestOps = key.interestOps();
        if ((interestOps & this.readInterestOp) != 0) {
            key.interestOps(interestOps & ~this.readInterestOp);
        }
    }

    @Override
    protected final boolean isWriteFlushedScheduled() {
        SelectionKey selectionKey = this.selectionKey();
        return selectionKey != null && selectionKey.isValid() && (selectionKey.interestOps() & 4) != 0;
    }

    @Override
    protected final void doRead(boolean wasReadPendingAlready) {
        if (wasReadPendingAlready) {
            return;
        }
        SelectionKey selectionKey = this.selectionKey;
        if (!selectionKey.isValid()) {
            return;
        }
        int interestOps = selectionKey.interestOps();
        if ((interestOps & this.readInterestOp) == 0) {
            selectionKey.interestOps(interestOps | this.readInterestOp);
        }
    }

    @Override
    protected final void doClose() throws Exception {
        this.javaChannel().close();
    }

    protected final Buffer newDirectBuffer(Buffer buf) {
        if (buf.readableBytes() == 0) {
            return buf;
        }
        BufferAllocator bufferAllocator = AbstractNioChannel.ioBufferAllocator(this.bufferAllocator());
        if (bufferAllocator.isPooling()) {
            try (Buffer buffer = buf;){
                Buffer buffer2 = bufferAllocator.allocate(buf.readableBytes()).writeBytes(buf);
                return buffer2;
            }
        }
        return buf;
    }

    protected final Buffer newDirectBuffer(Resource<?> holder, Buffer buf) {
        try (Resource<?> resource = holder;){
            BufferAllocator bufferAllocator = AbstractNioChannel.ioBufferAllocator(this.bufferAllocator());
            if (bufferAllocator.isPooling()) {
                Buffer buffer = bufferAllocator.allocate(buf.readableBytes()).writeBytes(buf);
                return buffer;
            }
            Buffer buffer = buf.split();
            return buffer;
        }
    }

    private static BufferAllocator ioBufferAllocator(BufferAllocator bufferAllocator) {
        if (!bufferAllocator.getAllocationType().isDirect()) {
            return DefaultBufferAllocators.offHeapAllocator();
        }
        return bufferAllocator;
    }

    @Override
    protected final void writeLoopComplete(boolean allWritten) {
        SelectionKey key = this.selectionKey();
        if (key != null && key.isValid()) {
            int interestOps = key.interestOps();
            if (!allWritten) {
                if ((interestOps & 4) == 0) {
                    key.interestOps(interestOps | 4);
                }
            } else if ((interestOps & 4) != 0) {
                key.interestOps(interestOps & 0xFFFFFFFB);
            }
        }
        super.writeLoopComplete(allWritten);
    }

    private void closeTransportNow() {
        this.closeTransport(this.newPromise());
    }

    private void finishConnectNow() {
        this.finishConnect();
    }

    final NioProcessor nioProcessor() {
        return this.nioProcessor;
    }
}

