/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.nio;

import io.netty5.buffer.Buffer;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.AdaptiveReadHandleFactory;
import io.netty5.channel.Channel;
import io.netty5.channel.EventLoop;
import io.netty5.channel.FileRegion;
import io.netty5.channel.WriteHandleFactory;
import io.netty5.channel.nio.AbstractNioChannel;
import io.netty5.util.Resource;
import io.netty5.util.internal.StringUtil;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;

public abstract class AbstractNioByteChannel<P extends Channel, L extends SocketAddress, R extends SocketAddress>
extends AbstractNioChannel<P, L, R> {
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(Buffer.class) + ", " + StringUtil.simpleClassName(FileRegion.class) + ")";

    protected AbstractNioByteChannel(P parent, EventLoop eventLoop, WriteHandleFactory defaultWriteHandleFactory, SelectableChannel ch) {
        super(parent, eventLoop, false, new AdaptiveReadHandleFactory(), defaultWriteHandleFactory, ch, 1);
    }

    @Override
    protected final boolean doReadNow(AbstractChannel.ReadSink readSink) throws Exception {
        Buffer buffer = null;
        try {
            buffer = readSink.allocateBuffer();
            if (buffer == null) {
                readSink.processRead(0, 0, null);
                return false;
            }
            int attemptedBytesRead = buffer.writableBytes();
            int actualBytesRead = this.doReadBytes(buffer);
            if (actualBytesRead <= 0) {
                Resource.dispose(buffer);
                buffer = null;
                readSink.processRead(attemptedBytesRead, actualBytesRead, null);
                return actualBytesRead < 0;
            }
            readSink.processRead(attemptedBytesRead, actualBytesRead, buffer);
            buffer = null;
            return false;
        }
        catch (Throwable t) {
            if (buffer != null) {
                buffer.close();
            }
            throw t;
        }
    }

    @Override
    protected void doWriteNow(AbstractChannel.WriteSink writeSink) throws Exception {
        boolean continueWriting;
        int messages;
        long actualBytesWrite;
        long attemptedBytesWrite;
        Object msg = writeSink.currentFlushedMessage();
        if (msg instanceof Buffer) {
            Buffer buf = (Buffer)msg;
            if (buf.readableBytes() == 0) {
                attemptedBytesWrite = 0L;
                actualBytesWrite = 0L;
                messages = 1;
                continueWriting = true;
            } else {
                attemptedBytesWrite = buf.readableBytes();
                actualBytesWrite = this.doWriteBytes(buf);
                messages = actualBytesWrite == attemptedBytesWrite ? 1 : 0;
                continueWriting = actualBytesWrite > 0L;
            }
        } else if (msg instanceof FileRegion) {
            FileRegion region = (FileRegion)msg;
            if (region.transferred() >= region.count()) {
                attemptedBytesWrite = 0L;
                actualBytesWrite = 0L;
                messages = 1;
                continueWriting = true;
            } else {
                attemptedBytesWrite = region.count();
                actualBytesWrite = this.doWriteFileRegion(region);
                messages = actualBytesWrite == attemptedBytesWrite ? 1 : 0;
                continueWriting = actualBytesWrite > 0L;
            }
        } else {
            throw new Error();
        }
        writeSink.complete(attemptedBytesWrite, actualBytesWrite, messages, continueWriting);
    }

    @Override
    protected final Object filterOutboundMessage(Object msg) {
        if (msg instanceof Buffer) {
            Buffer buf = (Buffer)msg;
            if (buf.isDirect()) {
                return msg;
            }
            return this.newDirectBuffer(buf);
        }
        if (msg instanceof FileRegion) {
            return msg;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(msg) + EXPECTED_TYPES);
    }

    protected abstract long doWriteFileRegion(FileRegion var1) throws Exception;

    protected abstract int doReadBytes(Buffer var1) throws Exception;

    protected abstract int doWriteBytes(Buffer var1) throws Exception;
}

