/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.local;

import io.netty5.channel.IoExecutionContext;
import io.netty5.channel.IoHandle;
import io.netty5.channel.IoHandler;
import io.netty5.channel.IoHandlerFactory;
import io.netty5.channel.local.LocalChannelUnsafe;
import io.netty5.util.internal.StringUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.LockSupport;

public final class LocalHandler
implements IoHandler {
    private final Set<LocalChannelUnsafe> registeredChannels = new HashSet<LocalChannelUnsafe>(64);
    private volatile Thread executionThread;

    private LocalHandler() {
    }

    public static IoHandlerFactory newFactory() {
        return LocalHandler::new;
    }

    private static LocalChannelUnsafe cast(IoHandle handle) {
        if (handle instanceof LocalChannelUnsafe) {
            return (LocalChannelUnsafe)((Object)handle);
        }
        throw new IllegalArgumentException("IoHandle of type " + StringUtil.simpleClassName(handle) + " not supported");
    }

    @Override
    public int run(IoExecutionContext runner) {
        if (this.executionThread == null) {
            this.executionThread = Thread.currentThread();
        }
        if (runner.canBlock()) {
            LockSupport.parkNanos(this, runner.delayNanos(System.nanoTime()));
        }
        return 0;
    }

    @Override
    public void wakeup(boolean inEventLoop) {
        Thread thread;
        if (!inEventLoop && (thread = this.executionThread) != null) {
            LockSupport.unpark(thread);
        }
    }

    @Override
    public void prepareToDestroy() {
        for (LocalChannelUnsafe unsafe : this.registeredChannels) {
            unsafe.closeTransportNow();
        }
        this.registeredChannels.clear();
    }

    @Override
    public void destroy() {
    }

    @Override
    public void register(IoHandle handle) {
        LocalChannelUnsafe unsafe = LocalHandler.cast(handle);
        if (this.registeredChannels.add(unsafe)) {
            unsafe.registerTransportNow();
        }
    }

    @Override
    public void deregister(IoHandle handle) {
        LocalChannelUnsafe unsafe = LocalHandler.cast(handle);
        if (this.registeredChannels.remove(unsafe)) {
            unsafe.deregisterTransportNow();
        }
    }

    @Override
    public boolean isCompatible(Class<? extends IoHandle> handleType) {
        return LocalChannelUnsafe.class.isAssignableFrom(handleType);
    }
}

