/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.kqueue;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ComponentIterator;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.AdaptiveReadHandleFactory;
import io.netty5.channel.ChannelException;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.DefaultFileRegion;
import io.netty5.channel.EventLoop;
import io.netty5.channel.FileRegion;
import io.netty5.channel.ReadHandleFactory;
import io.netty5.channel.WriteHandleFactory;
import io.netty5.channel.kqueue.AbstractKQueueChannel;
import io.netty5.channel.kqueue.BsdSocket;
import io.netty5.channel.kqueue.KQueueChannelOption;
import io.netty5.channel.kqueue.KQueueServerSocketChannel;
import io.netty5.channel.socket.SocketChannel;
import io.netty5.channel.socket.SocketChannelWriteHandleFactory;
import io.netty5.channel.socket.SocketProtocolFamily;
import io.netty5.channel.unix.DomainSocketReadMode;
import io.netty5.channel.unix.FileDescriptor;
import io.netty5.channel.unix.IovArray;
import io.netty5.channel.unix.Limits;
import io.netty5.channel.unix.PeerCredentials;
import io.netty5.channel.unix.SocketWritableByteChannel;
import io.netty5.channel.unix.UnixChannelOption;
import io.netty5.channel.unix.UnixChannelUtil;
import io.netty5.util.Resource;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.GlobalEventExecutor;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.UnstableApi;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;

@UnstableApi
public final class KQueueSocketChannel
extends AbstractKQueueChannel<KQueueServerSocketChannel>
implements SocketChannel {
    private static final Set<ChannelOption<?>> SUPPORTED_OPTIONS = KQueueSocketChannel.supportedOptions();
    private static final Set<ChannelOption<?>> SUPPORTED_OPTIONS_DOMAIN_SOCKET = KQueueSocketChannel.supportedOptionsDomainSocket();
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(Buffer.class) + ", " + StringUtil.simpleClassName(DefaultFileRegion.class) + ")";
    private WritableByteChannel byteChannel;
    private volatile DomainSocketReadMode mode = DomainSocketReadMode.BYTES;
    private volatile boolean tcpFastopen;

    public KQueueSocketChannel(EventLoop eventLoop) {
        this(eventLoop, (ProtocolFamily)null);
    }

    public KQueueSocketChannel(EventLoop eventLoop, ProtocolFamily protocolFamily) {
        super(null, eventLoop, false, (ReadHandleFactory)new AdaptiveReadHandleFactory(), (WriteHandleFactory)new SocketChannelWriteHandleFactory(Integer.MAX_VALUE, Limits.SSIZE_MAX), BsdSocket.newSocket(protocolFamily), false);
        this.enableTcpNoDelayIfSupported();
    }

    public KQueueSocketChannel(EventLoop eventLoop, int fd, ProtocolFamily protocolFamily) {
        this(eventLoop, new BsdSocket(fd, SocketProtocolFamily.of(protocolFamily)));
    }

    private KQueueSocketChannel(EventLoop eventLoop, BsdSocket fd) {
        super(null, eventLoop, false, (ReadHandleFactory)new AdaptiveReadHandleFactory(), (WriteHandleFactory)new SocketChannelWriteHandleFactory(Integer.MAX_VALUE), fd, KQueueSocketChannel.isSoErrorZero(fd));
        this.enableTcpNoDelayIfSupported();
    }

    KQueueSocketChannel(KQueueServerSocketChannel parent, EventLoop eventLoop, BsdSocket fd, SocketAddress remoteAddress) {
        super(parent, eventLoop, false, (ReadHandleFactory)new AdaptiveReadHandleFactory(), (WriteHandleFactory)new SocketChannelWriteHandleFactory(Integer.MAX_VALUE), fd, remoteAddress);
        this.enableTcpNoDelayIfSupported();
    }

    private void enableTcpNoDelayIfSupported() {
        if (this.socket.protocolFamily() != SocketProtocolFamily.UNIX && PlatformDependent.canEnableTcpNoDelayByDefault()) {
            this.setTcpNoDelay(true);
        }
    }

    @Override
    protected <T> T getExtendedOption(ChannelOption<T> option) {
        if (this.isSupported(this.socket.protocolFamily(), option)) {
            if (option == ChannelOption.SO_RCVBUF) {
                return (T)Integer.valueOf(this.getReceiveBufferSize());
            }
            if (option == ChannelOption.SO_SNDBUF) {
                return (T)Integer.valueOf(this.getSendBufferSize());
            }
            if (option == ChannelOption.TCP_NODELAY) {
                return (T)Boolean.valueOf(this.isTcpNoDelay());
            }
            if (option == ChannelOption.SO_KEEPALIVE) {
                return (T)Boolean.valueOf(this.isKeepAlive());
            }
            if (option == ChannelOption.SO_REUSEADDR) {
                return (T)Boolean.valueOf(this.isReuseAddress());
            }
            if (option == ChannelOption.SO_LINGER) {
                return (T)Integer.valueOf(this.getSoLinger());
            }
            if (option == ChannelOption.IP_TOS) {
                return (T)Integer.valueOf(this.getTrafficClass());
            }
            if (option == KQueueChannelOption.SO_SNDLOWAT) {
                return (T)Integer.valueOf(this.getSndLowAt());
            }
            if (option == KQueueChannelOption.TCP_NOPUSH) {
                return (T)Boolean.valueOf(this.isTcpNoPush());
            }
            if (option == ChannelOption.TCP_FASTOPEN_CONNECT) {
                return (T)Boolean.valueOf(this.isTcpFastOpenConnect());
            }
            if (option == UnixChannelOption.DOMAIN_SOCKET_READ_MODE) {
                return (T)((Object)this.getReadMode());
            }
            if (option == UnixChannelOption.SO_PEERCRED) {
                return (T)this.getPeerCredentials();
            }
        }
        return super.getExtendedOption(option);
    }

    @Override
    protected <T> void setExtendedOption(ChannelOption<T> option, T value) {
        if (this.isSupported(this.socket.protocolFamily(), option)) {
            if (option == ChannelOption.SO_RCVBUF) {
                this.setReceiveBufferSize((Integer)value);
            } else if (option == ChannelOption.SO_SNDBUF) {
                this.setSendBufferSize((Integer)value);
            } else if (option == ChannelOption.TCP_NODELAY) {
                this.setTcpNoDelay((Boolean)value);
            } else if (option == ChannelOption.SO_KEEPALIVE) {
                this.setKeepAlive((Boolean)value);
            } else if (option == ChannelOption.SO_REUSEADDR) {
                this.setReuseAddress((Boolean)value);
            } else if (option == ChannelOption.SO_LINGER) {
                this.setSoLinger((Integer)value);
            } else if (option == ChannelOption.IP_TOS) {
                this.setTrafficClass((Integer)value);
            } else if (option == KQueueChannelOption.SO_SNDLOWAT) {
                this.setSndLowAt((Integer)value);
            } else if (option == KQueueChannelOption.TCP_NOPUSH) {
                this.setTcpNoPush((Boolean)value);
            } else if (option == ChannelOption.TCP_FASTOPEN_CONNECT) {
                this.setTcpFastOpenConnect((Boolean)value);
            } else if (option == UnixChannelOption.DOMAIN_SOCKET_READ_MODE) {
                this.setReadMode((DomainSocketReadMode)((Object)value));
            } else if (option == UnixChannelOption.SO_PEERCRED) {
                throw new UnsupportedOperationException("read-only option: " + option);
            }
        } else {
            super.setExtendedOption(option, value);
        }
    }

    private boolean isSupported(SocketProtocolFamily protocolFamily, ChannelOption<?> option) {
        if (protocolFamily == SocketProtocolFamily.UNIX) {
            return SUPPORTED_OPTIONS_DOMAIN_SOCKET.contains(option);
        }
        return SUPPORTED_OPTIONS.contains(option);
    }

    @Override
    protected boolean isExtendedOptionSupported(ChannelOption<?> option) {
        return this.isSupported(this.socket.protocolFamily(), option) || super.isExtendedOptionSupported(option);
    }

    private static Set<ChannelOption<?>> supportedOptions() {
        return KQueueSocketChannel.newSupportedIdentityOptionsSet(ChannelOption.SO_RCVBUF, ChannelOption.SO_SNDBUF, ChannelOption.TCP_NODELAY, ChannelOption.SO_KEEPALIVE, ChannelOption.SO_REUSEADDR, ChannelOption.SO_LINGER, ChannelOption.IP_TOS, KQueueChannelOption.SO_SNDLOWAT, KQueueChannelOption.TCP_NOPUSH, ChannelOption.TCP_FASTOPEN_CONNECT);
    }

    private static Set<ChannelOption<?>> supportedOptionsDomainSocket() {
        return KQueueSocketChannel.newSupportedIdentityOptionsSet(ChannelOption.SO_RCVBUF, ChannelOption.SO_SNDBUF, UnixChannelOption.DOMAIN_SOCKET_READ_MODE, UnixChannelOption.SO_PEERCRED);
    }

    private void setReadMode(DomainSocketReadMode mode) {
        Objects.requireNonNull(mode, "mode");
        this.mode = mode;
    }

    private DomainSocketReadMode getReadMode() {
        return this.mode;
    }

    private int getReceiveBufferSize() {
        try {
            return this.socket.getReceiveBufferSize();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private int getSendBufferSize() {
        try {
            return this.socket.getSendBufferSize();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private int getSoLinger() {
        try {
            return this.socket.getSoLinger();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private int getTrafficClass() {
        try {
            return this.socket.getTrafficClass();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private boolean isKeepAlive() {
        try {
            return this.socket.isKeepAlive();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private boolean isReuseAddress() {
        try {
            return this.socket.isReuseAddress();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private boolean isTcpNoDelay() {
        try {
            return this.socket.isTcpNoDelay();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private int getSndLowAt() {
        try {
            return this.socket.getSndLowAt();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setSndLowAt(int sndLowAt) {
        try {
            this.socket.setSndLowAt(sndLowAt);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private boolean isTcpNoPush() {
        try {
            return this.socket.isTcpNoPush();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setTcpNoPush(boolean tcpNoPush) {
        try {
            this.socket.setTcpNoPush(tcpNoPush);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setKeepAlive(boolean keepAlive) {
        try {
            this.socket.setKeepAlive(keepAlive);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setReceiveBufferSize(int receiveBufferSize) {
        try {
            this.socket.setReceiveBufferSize(receiveBufferSize);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setReuseAddress(boolean reuseAddress) {
        try {
            this.socket.setReuseAddress(reuseAddress);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setSendBufferSize(int sendBufferSize) {
        try {
            this.socket.setSendBufferSize(sendBufferSize);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setSoLinger(int soLinger) {
        try {
            this.socket.setSoLinger(soLinger);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setTcpNoDelay(boolean tcpNoDelay) {
        try {
            this.socket.setTcpNoDelay(tcpNoDelay);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setTrafficClass(int trafficClass) {
        try {
            this.socket.setTrafficClass(trafficClass);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setTcpFastOpenConnect(boolean fastOpenConnect) {
        this.tcpFastopen = fastOpenConnect;
    }

    private boolean isTcpFastOpenConnect() {
        return this.tcpFastopen;
    }

    @Override
    protected Object filterOutboundMessage(Object msg) {
        if (this.socket.protocolFamily() == SocketProtocolFamily.UNIX && msg instanceof FileDescriptor) {
            return msg;
        }
        if (msg instanceof Buffer) {
            Buffer buf = (Buffer)msg;
            return UnixChannelUtil.isBufferCopyNeededForWrite(buf) ? this.newDirectBuffer(buf) : buf;
        }
        if (msg instanceof FileRegion) {
            return msg;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(msg) + EXPECTED_TYPES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doConnect0(SocketAddress remoteAddress, SocketAddress localAddress, Buffer initialData) throws Exception {
        if (this.isTcpFastOpenConnect() && initialData != null && initialData.readableBytes() > 0) {
            IovArray iov = new IovArray();
            try {
                iov.addReadable(initialData);
                int bytesSent = this.socket.connectx((InetSocketAddress)localAddress, (InetSocketAddress)remoteAddress, iov, true);
                this.writeFilter(true);
                initialData.skipReadableBytes(Math.abs(bytesSent));
                boolean bl = bytesSent > 0;
                return bl;
            }
            finally {
                iov.release();
            }
        }
        return super.doConnect0(remoteAddress, localAddress, initialData);
    }

    @Override
    protected Future<Executor> prepareToClose() {
        if (this.socket.protocolFamily() != SocketProtocolFamily.UNIX) {
            try {
                if (this.isOpen() && this.getSoLinger() > 0) {
                    return this.executor().deregisterForIo(this).map(v -> GlobalEventExecutor.INSTANCE);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    int readReady(AbstractChannel.ReadSink readSink) throws Exception {
        if (this.socket.protocolFamily() == SocketProtocolFamily.UNIX && this.getReadMode() == DomainSocketReadMode.FILE_DESCRIPTORS) {
            return this.readReadyFd(readSink);
        }
        return this.readReadyBytes(readSink);
    }

    private int readReadyFd(AbstractChannel.ReadSink readSink) throws Exception {
        int recvFd = this.socket.recvFd();
        switch (recvFd) {
            case 0: {
                readSink.processRead(0, 0, null);
                return 0;
            }
            case -1: {
                readSink.processRead(0, 0, null);
                this.closeTransportNow();
                return -1;
            }
        }
        readSink.processRead(0, 0, new FileDescriptor(recvFd));
        return 1;
    }

    private PeerCredentials getPeerCredentials() {
        try {
            return this.socket.getPeerCredentials();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void writeBytes(AbstractChannel.WriteSink writeSink) throws Exception {
        int written;
        long attempted;
        Buffer buf = (Buffer)writeSink.currentFlushedMessage();
        int readableBytes = buf.readableBytes();
        if (readableBytes == 0) {
            writeSink.complete(0L, 0L, 1, true);
            return;
        }
        int readableComponents = buf.countReadableComponents();
        if (readableComponents == 1) {
            attempted = readableBytes;
            written = this.doWriteBytes(buf);
        } else {
            attempted = Math.min(writeSink.estimatedMaxBytesPerGatheringWrite(), (long)buf.readableBytes());
            ByteBuffer[] nioBuffers = new ByteBuffer[readableComponents];
            try (ComponentIterator iteration = buf.forEachComponent();){
                int index = 0;
                for (Object c = iteration.first(); c != null; c = c.next()) {
                    nioBuffers[index++] = ((BufferComponent)c).readableBuffer();
                }
                written = (int)this.writeBytesMultiple(nioBuffers, nioBuffers.length, readableBytes, attempted);
            }
        }
        if (written > 0) {
            buf.skipReadableBytes(written);
        }
        writeSink.complete(attempted, written, readableBytes == written ? 1 : 0, written > 0);
    }

    private long writeBytesMultiple(IovArray array) throws IOException {
        long expectedWrittenBytes = array.size();
        assert (expectedWrittenBytes != 0L);
        int cnt = array.count();
        assert (cnt != 0);
        return this.socket.writevAddresses(array.memoryAddress(0), cnt);
    }

    private long writeBytesMultiple(ByteBuffer[] nioBuffers, int nioBufferCnt, long expectedWrittenBytes, long maxBytesPerGatheringWrite) throws IOException {
        assert (expectedWrittenBytes != 0L);
        if (expectedWrittenBytes > maxBytesPerGatheringWrite) {
            expectedWrittenBytes = maxBytesPerGatheringWrite;
        }
        return this.socket.writev(nioBuffers, 0, nioBufferCnt, expectedWrittenBytes);
    }

    private void writeDefaultFileRegion(AbstractChannel.WriteSink writeSink) throws Exception {
        DefaultFileRegion region = (DefaultFileRegion)writeSink.currentFlushedMessage();
        long regionCount = region.count();
        long transferred = region.transferred();
        if (transferred >= regionCount) {
            writeSink.complete(0L, 0L, 1, true);
        } else {
            long flushedAmount = this.socket.sendFile(region, region.position(), transferred, regionCount - transferred);
            if (flushedAmount == 0L) {
                KQueueSocketChannel.validateFileRegion(region, transferred);
            }
            writeSink.complete(regionCount, flushedAmount, region.transferred() >= regionCount ? 1 : 0, flushedAmount > 0L);
        }
    }

    private void writeFileRegion(AbstractChannel.WriteSink writeSink) throws Exception {
        FileRegion region = (FileRegion)writeSink.currentFlushedMessage();
        long regionCount = region.count();
        long transferred = region.transferred();
        if (transferred >= regionCount) {
            writeSink.complete(0L, 0L, 1, true);
        } else {
            if (this.byteChannel == null) {
                this.byteChannel = new KQueueSocketWritableByteChannel();
            }
            long flushedAmount = region.transferTo(this.byteChannel, region.transferred());
            writeSink.complete(regionCount, flushedAmount, region.transferred() >= regionCount ? 1 : 0, flushedAmount > 0L);
        }
    }

    @Override
    protected void doWriteNow(AbstractChannel.WriteSink writeSink) throws Exception {
        int msgCount = writeSink.numFlushedMessages();
        if (msgCount > 1 && writeSink.currentFlushedMessage() instanceof Buffer) {
            this.doWriteMultiple(writeSink);
        } else {
            this.doWriteSingle(writeSink);
        }
    }

    private void doWriteSingle(AbstractChannel.WriteSink writeSink) throws Exception {
        Object msg = writeSink.currentFlushedMessage();
        if (this.socket.protocolFamily() == SocketProtocolFamily.UNIX && msg instanceof FileDescriptor) {
            if (this.socket.sendFd(((FileDescriptor)msg).intValue()) > 0) {
                writeSink.complete(0L, 0L, 1, true);
            } else {
                writeSink.complete(0L, 0L, 0, false);
            }
            return;
        }
        if (msg instanceof Buffer) {
            this.writeBytes(writeSink);
        } else if (msg instanceof DefaultFileRegion) {
            this.writeDefaultFileRegion(writeSink);
        } else if (msg instanceof FileRegion) {
            this.writeFileRegion(writeSink);
        } else {
            throw new Error();
        }
    }

    private void doWriteMultiple(AbstractChannel.WriteSink writeSink) throws Exception {
        IovArray array = this.registration().cleanArray();
        array.maxBytes(writeSink.estimatedMaxBytesPerGatheringWrite());
        writeSink.forEachFlushedMessage(array);
        if (array.count() >= 1) {
            long result = this.writeBytesMultiple(array);
            int messages = writeSink.updateBufferReaderOffsets(result);
            writeSink.complete(array.size(), result, messages, result > 0L);
        } else {
            writeSink.complete(0L, 0L, writeSink.numFlushedMessages(), true);
        }
    }

    @Override
    protected void doShutdown(ChannelShutdownDirection direction) throws Exception {
        switch (direction) {
            case Outbound: {
                this.socket.shutdown(false, true);
                break;
            }
            case Inbound: {
                try {
                    this.socket.shutdown(true, false);
                }
                catch (NotYetConnectedException notYetConnectedException) {}
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public boolean isShutdown(ChannelShutdownDirection direction) {
        if (!this.isActive()) {
            return true;
        }
        switch (direction) {
            case Outbound: {
                return this.socket.isOutputShutdown();
            }
            case Inbound: {
                return this.socket.isInputShutdown();
            }
        }
        throw new AssertionError();
    }

    private int readReadyBytes(AbstractChannel.ReadSink readSink) throws Exception {
        Buffer buffer = null;
        try {
            buffer = readSink.allocateBuffer();
            if (buffer == null) {
                readSink.processRead(0, 0, null);
                return 0;
            }
            assert (buffer.isDirect());
            int attemptedBytesRead = buffer.writableBytes();
            int actualBytesRead = this.doReadBytes(buffer);
            if (actualBytesRead <= 0) {
                Resource.dispose(buffer);
                buffer = null;
                readSink.processRead(attemptedBytesRead, actualBytesRead, null);
                if (actualBytesRead < 0) {
                    return -1;
                }
                return 0;
            }
            buffer.skipWritableBytes(actualBytesRead);
            readSink.processRead(attemptedBytesRead, actualBytesRead, buffer);
            buffer = null;
            return actualBytesRead;
        }
        catch (Throwable t) {
            if (buffer != null) {
                buffer.close();
            }
            if (this.isConnectPending()) {
                this.finishConnect();
            }
            throw t;
        }
    }

    private final class KQueueSocketWritableByteChannel
    extends SocketWritableByteChannel {
        KQueueSocketWritableByteChannel() {
            super(KQueueSocketChannel.this.socket);
        }

        @Override
        protected BufferAllocator alloc() {
            return KQueueSocketChannel.this.bufferAllocator();
        }
    }
}

