/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.kqueue;

import io.netty5.channel.DefaultSelectStrategyFactory;
import io.netty5.channel.IoExecutionContext;
import io.netty5.channel.IoHandle;
import io.netty5.channel.IoHandler;
import io.netty5.channel.IoHandlerFactory;
import io.netty5.channel.SelectStrategy;
import io.netty5.channel.SelectStrategyFactory;
import io.netty5.channel.kqueue.AbstractKQueueChannel;
import io.netty5.channel.kqueue.KQueue;
import io.netty5.channel.kqueue.KQueueEventArray;
import io.netty5.channel.kqueue.KQueueRegistration;
import io.netty5.channel.kqueue.Native;
import io.netty5.channel.unix.FileDescriptor;
import io.netty5.channel.unix.IovArray;
import io.netty5.util.collection.IntObjectHashMap;
import io.netty5.util.collection.IntObjectMap;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.UnstableApi;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.IntSupplier;

@UnstableApi
public final class KQueueHandler
implements IoHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(KQueueHandler.class);
    private static final AtomicIntegerFieldUpdater<KQueueHandler> WAKEN_UP_UPDATER = AtomicIntegerFieldUpdater.newUpdater(KQueueHandler.class, "wakenUp");
    private static final int KQUEUE_WAKE_UP_IDENT = 0;
    private final boolean allowGrowing;
    private final FileDescriptor kqueueFd;
    private final KQueueEventArray changeList;
    private final KQueueEventArray eventList;
    private final SelectStrategy selectStrategy;
    private final IovArray iovArray = new IovArray();
    private final IntSupplier selectNowSupplier = () -> {
        try {
            return this.kqueueWaitNow();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    };
    private final IntObjectMap<AbstractKQueueChannel<?>> channels = new IntObjectHashMap(4096);
    private volatile int wakenUp;

    private static AbstractKQueueChannel<?> cast(IoHandle handle) {
        if (handle instanceof AbstractKQueueChannel) {
            return (AbstractKQueueChannel)handle;
        }
        throw new IllegalArgumentException("IoHandle of type " + StringUtil.simpleClassName(handle) + " not supported");
    }

    private KQueueHandler() {
        this(0, DefaultSelectStrategyFactory.INSTANCE.newSelectStrategy());
    }

    private KQueueHandler(int maxEvents, SelectStrategy strategy) {
        this.selectStrategy = Objects.requireNonNull(strategy, "strategy");
        this.kqueueFd = Native.newKQueue();
        if (maxEvents == 0) {
            this.allowGrowing = true;
            maxEvents = 4096;
        } else {
            this.allowGrowing = false;
        }
        this.changeList = new KQueueEventArray(maxEvents);
        this.eventList = new KQueueEventArray(maxEvents);
        int result = Native.keventAddUserEvent(this.kqueueFd.intValue(), 0);
        if (result < 0) {
            this.destroy();
            throw new IllegalStateException("kevent failed to add user event with errno: " + -result);
        }
    }

    public static IoHandlerFactory newFactory() {
        return KQueueHandler::new;
    }

    public static IoHandlerFactory newFactory(int maxEvents, SelectStrategyFactory selectStrategyFactory) {
        ObjectUtil.checkPositiveOrZero(maxEvents, "maxEvents");
        Objects.requireNonNull(selectStrategyFactory, "selectStrategyFactory");
        return () -> new KQueueHandler(maxEvents, selectStrategyFactory.newSelectStrategy());
    }

    @Override
    public void register(IoHandle handle) {
        final AbstractKQueueChannel<?> kQueueChannel = KQueueHandler.cast(handle);
        int id = kQueueChannel.fd().intValue();
        AbstractKQueueChannel<?> old = this.channels.put(id, kQueueChannel);
        assert (old == null || !old.isOpen());
        kQueueChannel.register0(new KQueueRegistration(){

            @Override
            public void evSet(short filter, short flags, int fflags) {
                KQueueHandler.this.evSet(kQueueChannel, filter, flags, fflags);
            }

            @Override
            public IovArray cleanArray() {
                return KQueueHandler.this.cleanArray();
            }
        });
    }

    @Override
    public void deregister(IoHandle handle) throws Exception {
        AbstractKQueueChannel<?> kQueueChannel = KQueueHandler.cast(handle);
        int fd = kQueueChannel.fd().intValue();
        AbstractKQueueChannel<?> old = this.channels.remove(fd);
        if (old != null && old != kQueueChannel) {
            this.channels.put(fd, old);
            assert (!kQueueChannel.isOpen());
        } else if (kQueueChannel.isOpen()) {
            kQueueChannel.unregisterFilters();
        }
        kQueueChannel.deregister0();
    }

    private void evSet(AbstractKQueueChannel<?> ch, short filter, short flags, int fflags) {
        this.changeList.evSet(ch, filter, flags, fflags);
    }

    private IovArray cleanArray() {
        this.iovArray.clear();
        return this.iovArray;
    }

    @Override
    public void wakeup(boolean inEventLoop) {
        if (!inEventLoop && WAKEN_UP_UPDATER.compareAndSet(this, 0, 1)) {
            this.wakeup();
        }
    }

    private void wakeup() {
        Native.keventTriggerUserEvent(this.kqueueFd.intValue(), 0);
    }

    private int kqueueWait(IoExecutionContext context, boolean oldWakeup) throws IOException {
        if (oldWakeup && !context.canBlock()) {
            return this.kqueueWaitNow();
        }
        long totalDelay = context.delayNanos(System.nanoTime());
        int delaySeconds = (int)Math.min(totalDelay / 1000000000L, Integer.MAX_VALUE);
        return this.kqueueWait(delaySeconds, (int)Math.min(totalDelay - (long)delaySeconds * 1000000000L, Integer.MAX_VALUE));
    }

    private int kqueueWaitNow() throws IOException {
        return this.kqueueWait(0, 0);
    }

    private int kqueueWait(int timeoutSec, int timeoutNs) throws IOException {
        int numEvents = Native.keventWait(this.kqueueFd.intValue(), this.changeList, this.eventList, timeoutSec, timeoutNs);
        this.changeList.clear();
        return numEvents;
    }

    private void processReady(int ready) {
        for (int i = 0; i < ready; ++i) {
            short filter = this.eventList.filter(i);
            short flags = this.eventList.flags(i);
            int fd = this.eventList.fd(i);
            if (filter == Native.EVFILT_USER || (flags & Native.EV_ERROR) != 0) {
                assert (filter != Native.EVFILT_USER || filter == Native.EVFILT_USER && fd == 0);
                continue;
            }
            AbstractKQueueChannel<?> channel = this.channels.get(fd);
            if (channel == null) {
                logger.warn("events[{}]=[{}, {}] had no channel!", i, fd, filter);
                continue;
            }
            if (filter == Native.EVFILT_WRITE) {
                channel.writeReady();
            } else if (filter == Native.EVFILT_READ) {
                channel.readReady(this.eventList.data(i));
            } else if (filter == Native.EVFILT_SOCK && (this.eventList.fflags(i) & Native.NOTE_RDHUP) != 0) {
                channel.readEOF();
            }
            if ((flags & Native.EV_EOF) == 0) continue;
            channel.readEOF();
        }
    }

    @Override
    public int run(IoExecutionContext context) {
        int handled = 0;
        try {
            int strategy = this.selectStrategy.calculateStrategy(this.selectNowSupplier, !context.canBlock());
            switch (strategy) {
                case -2: {
                    return 0;
                }
                case -3: 
                case -1: {
                    strategy = this.kqueueWait(context, WAKEN_UP_UPDATER.getAndSet(this, 0) == 1);
                    if (this.wakenUp != 1) break;
                    this.wakeup();
                }
            }
            if (strategy > 0) {
                handled = strategy;
                this.processReady(strategy);
            }
            if (this.allowGrowing && strategy == this.eventList.capacity()) {
                this.eventList.realloc(false);
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            KQueueHandler.handleLoopException(t);
        }
        return handled;
    }

    @Override
    public void destroy() {
        try {
            try {
                this.kqueueFd.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close the kqueue fd.", e);
            }
        }
        finally {
            this.changeList.free();
            this.eventList.free();
        }
    }

    @Override
    public void prepareToDestroy() {
        AbstractKQueueChannel[] localChannels;
        try {
            this.kqueueWaitNow();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (AbstractKQueueChannel ch : localChannels = this.channels.values().toArray(new AbstractKQueueChannel[0])) {
            ch.closeTransportNow();
        }
    }

    @Override
    public boolean isCompatible(Class<? extends IoHandle> handleType) {
        return AbstractKQueueChannel.class.isAssignableFrom(handleType);
    }

    private static void handleLoopException(Throwable t) {
        logger.warn("Unexpected exception in the selector loop.", t);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        KQueue.ensureAvailability();
    }
}

