/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.kqueue;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ComponentIterator;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.AddressedEnvelope;
import io.netty5.channel.ChannelException;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.DefaultBufferAddressedEnvelope;
import io.netty5.channel.EventLoop;
import io.netty5.channel.FixedReadHandleFactory;
import io.netty5.channel.MaxMessagesWriteHandleFactory;
import io.netty5.channel.ReadHandleFactory;
import io.netty5.channel.WriteHandleFactory;
import io.netty5.channel.kqueue.AbstractKQueueChannel;
import io.netty5.channel.kqueue.BsdSocket;
import io.netty5.channel.socket.DatagramChannel;
import io.netty5.channel.socket.DatagramPacket;
import io.netty5.channel.socket.DomainSocketAddress;
import io.netty5.channel.socket.SocketProtocolFamily;
import io.netty5.channel.unix.DatagramSocketAddress;
import io.netty5.channel.unix.DomainDatagramSocketAddress;
import io.netty5.channel.unix.Errors;
import io.netty5.channel.unix.IovArray;
import io.netty5.channel.unix.UnixChannel;
import io.netty5.channel.unix.UnixChannelOption;
import io.netty5.channel.unix.UnixChannelUtil;
import io.netty5.util.concurrent.Future;
import io.netty5.util.internal.SilentDispose;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.UnstableApi;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Set;

@UnstableApi
public final class KQueueDatagramChannel
extends AbstractKQueueChannel<UnixChannel>
implements DatagramChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(KQueueDatagramChannel.class);
    private static final Set<ChannelOption<?>> SUPPORTED_OPTIONS = KQueueDatagramChannel.supportedOptions();
    private static final Set<ChannelOption<?>> SUPPORTED_OPTIONS_DOMAIN_SOCKET = KQueueDatagramChannel.supportedOptionsDomainSocket();
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + "<" + StringUtil.simpleClassName(Buffer.class) + ", " + StringUtil.simpleClassName(InetSocketAddress.class) + ">, " + StringUtil.simpleClassName(Buffer.class) + ")";
    private static final String EXPECTED_TYPES_DOMAIN = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + "<" + StringUtil.simpleClassName(Buffer.class) + ", " + StringUtil.simpleClassName(DomainSocketAddress.class) + ">, " + StringUtil.simpleClassName(Buffer.class) + ")";
    private volatile boolean connected;
    private volatile boolean inputShutdown;
    private volatile boolean outputShutdown;
    private boolean activeOnOpen;

    public KQueueDatagramChannel(EventLoop eventLoop) {
        this(eventLoop, null);
    }

    public KQueueDatagramChannel(EventLoop eventLoop, ProtocolFamily protocolFamily) {
        super(null, eventLoop, true, (ReadHandleFactory)new FixedReadHandleFactory(2048), (WriteHandleFactory)new MaxMessagesWriteHandleFactory(Integer.MAX_VALUE), BsdSocket.newDatagramSocket(protocolFamily), false);
    }

    public KQueueDatagramChannel(EventLoop eventLoop, int fd, ProtocolFamily protocolFamily) {
        this(eventLoop, new BsdSocket(fd, SocketProtocolFamily.of(protocolFamily)), true);
    }

    KQueueDatagramChannel(EventLoop eventLoop, BsdSocket socket, boolean active) {
        super(null, eventLoop, true, (ReadHandleFactory)new FixedReadHandleFactory(2048), (WriteHandleFactory)new MaxMessagesWriteHandleFactory(Integer.MAX_VALUE), socket, active);
    }

    @Override
    protected <T> T getExtendedOption(ChannelOption<T> option) {
        if (this.isSupported(this.socket.protocolFamily(), option)) {
            if (option == ChannelOption.SO_BROADCAST) {
                return (T)Boolean.valueOf(this.isBroadcast());
            }
            if (option == ChannelOption.SO_RCVBUF) {
                return (T)Integer.valueOf(this.getReceiveBufferSize());
            }
            if (option == ChannelOption.SO_SNDBUF) {
                return (T)Integer.valueOf(this.getSendBufferSize());
            }
            if (option == ChannelOption.SO_REUSEADDR) {
                return (T)Boolean.valueOf(this.isReuseAddress());
            }
            if (option == ChannelOption.IP_TOS) {
                return (T)Integer.valueOf(this.getTrafficClass());
            }
            if (option == ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) {
                return (T)Boolean.valueOf(this.activeOnOpen);
            }
            if (option == UnixChannelOption.SO_REUSEPORT) {
                return (T)Boolean.valueOf(this.isReusePort());
            }
        }
        return super.getExtendedOption(option);
    }

    @Override
    protected <T> void setExtendedOption(ChannelOption<T> option, T value) {
        if (this.isSupported(this.socket.protocolFamily(), option)) {
            if (option == ChannelOption.SO_BROADCAST) {
                this.setBroadcast((Boolean)value);
            } else if (option == ChannelOption.SO_RCVBUF) {
                this.setReceiveBufferSize((Integer)value);
            } else if (option == ChannelOption.SO_SNDBUF) {
                this.setSendBufferSize((Integer)value);
            } else if (option == ChannelOption.SO_REUSEADDR) {
                this.setReuseAddress((Boolean)value);
            } else if (option == ChannelOption.IP_TOS) {
                this.setTrafficClass((Integer)value);
            } else if (option == ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) {
                this.setActiveOnOpen((Boolean)value);
            } else if (option == UnixChannelOption.SO_REUSEPORT) {
                this.setReusePort((Boolean)value);
            }
        } else {
            super.setExtendedOption(option, value);
        }
    }

    private boolean isSupported(SocketProtocolFamily protocolFamily, ChannelOption<?> option) {
        if (protocolFamily == SocketProtocolFamily.UNIX) {
            return SUPPORTED_OPTIONS_DOMAIN_SOCKET.contains(option);
        }
        return SUPPORTED_OPTIONS.contains(option);
    }

    @Override
    protected boolean isExtendedOptionSupported(ChannelOption<?> option) {
        return this.isSupported(this.socket.protocolFamily(), option) || super.isExtendedOptionSupported(option);
    }

    private static Set<ChannelOption<?>> supportedOptions() {
        return KQueueDatagramChannel.newSupportedIdentityOptionsSet(ChannelOption.SO_BROADCAST, ChannelOption.SO_RCVBUF, ChannelOption.SO_SNDBUF, ChannelOption.SO_REUSEADDR, ChannelOption.IP_TOS, ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, UnixChannelOption.SO_REUSEPORT);
    }

    private static Set<ChannelOption<?>> supportedOptionsDomainSocket() {
        return KQueueDatagramChannel.newSupportedIdentityOptionsSet(ChannelOption.SO_SNDBUF, ChannelOption.SO_RCVBUF, ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION);
    }

    private void setActiveOnOpen(boolean activeOnOpen) {
        if (this.isRegistered()) {
            throw new IllegalStateException("Can only changed before channel was registered");
        }
        this.activeOnOpen = activeOnOpen;
    }

    private boolean getActiveOnOpen() {
        return this.activeOnOpen;
    }

    private boolean isReusePort() {
        try {
            return this.socket.isReusePort();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setReusePort(boolean reusePort) {
        try {
            this.socket.setReusePort(reusePort);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private int getSendBufferSize() {
        try {
            return this.socket.getSendBufferSize();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public void setSendBufferSize(int sendBufferSize) {
        try {
            this.socket.setSendBufferSize(sendBufferSize);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private int getReceiveBufferSize() {
        try {
            return this.socket.getReceiveBufferSize();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setReceiveBufferSize(int receiveBufferSize) {
        try {
            this.socket.setReceiveBufferSize(receiveBufferSize);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private int getTrafficClass() {
        try {
            return this.socket.getTrafficClass();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setTrafficClass(int trafficClass) {
        try {
            this.socket.setTrafficClass(trafficClass);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private boolean isReuseAddress() {
        try {
            return this.socket.isReuseAddress();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setReuseAddress(boolean reuseAddress) {
        try {
            this.socket.setReuseAddress(reuseAddress);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private boolean isBroadcast() {
        try {
            return this.socket.isBroadcast();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setBroadcast(boolean broadcast) {
        try {
            this.socket.setBroadcast(broadcast);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public boolean isActive() {
        return this.socket.isOpen() && (this.getActiveOnOpen() && this.isRegistered() || this.active);
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        super.doBind(localAddress);
        this.active = true;
    }

    @Override
    protected void doWriteNow(AbstractChannel.WriteSink writeSink) {
        Object remoteAddress;
        Buffer data;
        Object msg = writeSink.currentFlushedMessage();
        if (msg instanceof AddressedEnvelope) {
            AddressedEnvelope envelope = (AddressedEnvelope)msg;
            data = (Buffer)envelope.content();
            remoteAddress = envelope.recipient();
        } else {
            data = (Buffer)msg;
            remoteAddress = null;
        }
        int initialReadableBytes = data.readableBytes();
        if (initialReadableBytes == 0) {
            writeSink.complete(0L, 0L, 1, true);
            return;
        }
        try {
            int written;
            if (data.countReadableComponents() > 1) {
                IovArray array = this.registration().cleanArray();
                array.addReadable(data);
                int count = array.count();
                assert (count != 0);
                if (remoteAddress == null) {
                    remoteAddress = this.remoteAddress();
                }
                if (this.socket.protocolFamily() == SocketProtocolFamily.UNIX) {
                    written = this.socket.sendToAddressesDomainSocket(array.memoryAddress(0), count, ((DomainSocketAddress)remoteAddress).path().getBytes(StandardCharsets.UTF_8));
                } else {
                    InetSocketAddress inetSocketAddress = remoteAddress;
                    written = this.socket.sendToAddresses(array.memoryAddress(0), count, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                }
            } else {
                if (remoteAddress == null) {
                    try (ComponentIterator iteration = data.forEachComponent();){
                        Object component = iteration.firstReadable();
                        written = this.socket.writeAddress(((BufferComponent)component).readableNativeAddress(), 0, ((BufferComponent)component).readableBytes());
                    }
                }
                if (this.socket.protocolFamily() == SocketProtocolFamily.UNIX) {
                    byte[] path = ((DomainSocketAddress)remoteAddress).path().getBytes(StandardCharsets.UTF_8);
                    try (ComponentIterator iteration = data.forEachComponent();){
                        Object component = iteration.firstReadable();
                        written = this.socket.sendToAddressDomainSocket(((BufferComponent)component).readableNativeAddress(), 0, ((BufferComponent)component).readableBytes(), path);
                    }
                }
                InetSocketAddress inetSocketAddress = remoteAddress;
                try (ComponentIterator iteration = data.forEachComponent();){
                    Object component = iteration.firstReadable();
                    written = this.socket.sendToAddress(((BufferComponent)component).readableNativeAddress(), 0, ((BufferComponent)component).readableBytes(), inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                }
            }
            writeSink.complete(initialReadableBytes, written, written > 0 ? 1 : 0, written > 0);
        }
        catch (IOException e) {
            writeSink.complete(initialReadableBytes, e, true);
        }
    }

    @Override
    protected Object filterOutboundMessage(Object msg) {
        if (this.socket.protocolFamily() == SocketProtocolFamily.UNIX) {
            return this.filterOutboundMessage0(msg, DomainSocketAddress.class, EXPECTED_TYPES_DOMAIN);
        }
        return this.filterOutboundMessage0(msg, InetSocketAddress.class, EXPECTED_TYPES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object filterOutboundMessage0(Object msg, Class<? extends SocketAddress> recipientClass, String expectedTypes) {
        if (msg instanceof DatagramPacket) {
            DatagramPacket packet = (DatagramPacket)msg;
            if (recipientClass.isInstance(packet.recipient())) {
                Buffer content = (Buffer)packet.content();
                return UnixChannelUtil.isBufferCopyNeededForWrite(content) ? new DatagramPacket(this.newDirectBuffer(packet, content), (SocketAddress)packet.recipient()) : msg;
            }
        } else {
            AddressedEnvelope e;
            Object recipient;
            if (msg instanceof Buffer) {
                Buffer buf = (Buffer)msg;
                return UnixChannelUtil.isBufferCopyNeededForWrite(buf) ? this.newDirectBuffer(buf) : buf;
            }
            if (msg instanceof AddressedEnvelope && ((recipient = (e = (AddressedEnvelope)msg).recipient()) == null || recipientClass.isInstance(recipient)) && e.content() instanceof Buffer) {
                Buffer buf = (Buffer)e.content();
                if (UnixChannelUtil.isBufferCopyNeededForWrite(buf)) {
                    try {
                        DefaultBufferAddressedEnvelope defaultBufferAddressedEnvelope = new DefaultBufferAddressedEnvelope(this.newDirectBuffer(null, buf), recipient);
                        return defaultBufferAddressedEnvelope;
                    }
                    finally {
                        SilentDispose.dispose(e, logger);
                    }
                }
                return e;
            }
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(msg) + expectedTypes);
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.socket.disconnect();
        this.active = false;
        this.connected = false;
        this.resetCachedAddresses();
    }

    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress, Buffer initialData) throws Exception {
        if (super.doConnect(remoteAddress, localAddress, initialData)) {
            this.connected = true;
            return true;
        }
        return false;
    }

    @Override
    protected void doClose() throws Exception {
        super.doClose();
        this.connected = false;
    }

    @Override
    int readReady(AbstractChannel.ReadSink readSink) throws Exception {
        Buffer buffer = null;
        try {
            DatagramPacket packet;
            boolean connected = this.isConnected();
            buffer = readSink.allocateBuffer();
            if (buffer == null) {
                readSink.processRead(0, 0, null);
                return 0;
            }
            assert (buffer.isDirect());
            int attemptedBytesRead = buffer.writableBytes();
            int actualBytesRead = 0;
            if (connected) {
                try {
                    actualBytesRead = this.doReadBytes(buffer);
                }
                catch (Errors.NativeIoException e) {
                    if (e.expectedErr() == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
                        PortUnreachableException error = new PortUnreachableException(e.getMessage());
                        error.initCause(e);
                        throw error;
                    }
                    throw e;
                }
                if (actualBytesRead <= 0) {
                    buffer.close();
                    buffer = null;
                    readSink.processRead(attemptedBytesRead, actualBytesRead, null);
                    return actualBytesRead;
                }
                buffer.skipWritableBytes(actualBytesRead);
                packet = new DatagramPacket(buffer, (SocketAddress)this.localAddress(), (SocketAddress)this.remoteAddress());
            } else {
                SocketAddress localAddress = null;
                SocketAddress remoteAddress = null;
                if (this.socket.protocolFamily() == SocketProtocolFamily.UNIX) {
                    DomainDatagramSocketAddress recvAddress = null;
                    try (ComponentIterator iteration = buffer.forEachComponent();){
                        Object c = iteration.firstWritable();
                        if (c != null) {
                            recvAddress = this.socket.recvFromAddressDomainSocket(((BufferComponent)c).writableNativeAddress(), 0, ((BufferComponent)c).writableBytes());
                        }
                    }
                    if (recvAddress != null) {
                        remoteAddress = recvAddress;
                        actualBytesRead = recvAddress.receivedAmount();
                        localAddress = recvAddress.localAddress();
                    }
                } else {
                    try (ComponentIterator iterator = buffer.forEachComponent();){
                        DatagramSocketAddress datagramSocketAddress;
                        Object component = iterator.firstWritable();
                        long addr = ((BufferComponent)component).writableNativeAddress();
                        if (addr != 0L) {
                            datagramSocketAddress = this.socket.recvFromAddress(addr, 0, ((BufferComponent)component).writableBytes());
                        } else {
                            ByteBuffer nioData = ((BufferComponent)component).writableBuffer();
                            datagramSocketAddress = this.socket.recvFrom(nioData, nioData.position(), nioData.limit());
                        }
                        if (datagramSocketAddress != null) {
                            remoteAddress = datagramSocketAddress;
                            localAddress = datagramSocketAddress.localAddress();
                            actualBytesRead = datagramSocketAddress.receivedAmount();
                        }
                    }
                }
                if (remoteAddress == null) {
                    readSink.processRead(attemptedBytesRead, 0, null);
                    buffer.close();
                    buffer = null;
                    return 0;
                }
                if (localAddress == null) {
                    localAddress = this.localAddress();
                }
                buffer.skipWritableBytes(actualBytesRead);
                packet = new DatagramPacket(buffer, localAddress, remoteAddress);
            }
            readSink.processRead(attemptedBytesRead, actualBytesRead, packet);
            buffer = null;
            return actualBytesRead;
        }
        catch (Throwable t) {
            if (buffer != null) {
                buffer.close();
            }
            throw t;
        }
    }

    private <V> Future<V> newMulticastNotSupportedFuture() {
        return this.newFailedFuture(new UnsupportedOperationException("Multicast not supported"));
    }

    @Override
    public Future<Void> joinGroup(InetAddress multicastAddress) {
        Objects.requireNonNull(multicastAddress, "multicast");
        return this.newMulticastNotSupportedFuture();
    }

    @Override
    public Future<Void> joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        Objects.requireNonNull(multicastAddress, "multicastAddress");
        Objects.requireNonNull(networkInterface, "networkInterface");
        return this.newMulticastNotSupportedFuture();
    }

    @Override
    public Future<Void> leaveGroup(InetAddress multicastAddress) {
        Objects.requireNonNull(multicastAddress, "multicast");
        return this.newMulticastNotSupportedFuture();
    }

    @Override
    public Future<Void> leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        Objects.requireNonNull(multicastAddress, "multicastAddress");
        Objects.requireNonNull(networkInterface, "networkInterface");
        return this.newMulticastNotSupportedFuture();
    }

    @Override
    public Future<Void> block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock) {
        Objects.requireNonNull(multicastAddress, "multicastAddress");
        Objects.requireNonNull(sourceToBlock, "sourceToBlock");
        Objects.requireNonNull(networkInterface, "networkInterface");
        return this.newMulticastNotSupportedFuture();
    }

    @Override
    public Future<Void> block(InetAddress multicastAddress, InetAddress sourceToBlock) {
        Objects.requireNonNull(multicastAddress, "multicastAddress");
        Objects.requireNonNull(sourceToBlock, "sourceToBlock");
        return this.newMulticastNotSupportedFuture();
    }

    @Override
    protected void doShutdown(ChannelShutdownDirection direction) {
        switch (direction) {
            case Inbound: {
                this.inputShutdown = true;
                break;
            }
            case Outbound: {
                this.outputShutdown = true;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public boolean isShutdown(ChannelShutdownDirection direction) {
        if (!this.isActive()) {
            return true;
        }
        switch (direction) {
            case Inbound: {
                return this.inputShutdown;
            }
            case Outbound: {
                return this.outputShutdown;
            }
        }
        throw new AssertionError();
    }
}

