/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.internal;

import io.netty5.buffer.BufferAllocator;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.ReadBufferAllocator;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import java.net.SocketAddress;
import java.util.Objects;

public abstract class DelegatingChannelHandlerContext
implements ChannelHandlerContext {
    private final ChannelHandlerContext ctx;

    protected DelegatingChannelHandlerContext(ChannelHandlerContext ctx) {
        this.ctx = Objects.requireNonNull(ctx, "ctx");
    }

    public final ChannelHandlerContext delegatingCtx() {
        return this.ctx;
    }

    @Override
    public Channel channel() {
        return this.ctx.channel();
    }

    @Override
    public EventExecutor executor() {
        return this.ctx.executor();
    }

    @Override
    public String name() {
        return this.ctx.name();
    }

    @Override
    public ChannelHandler handler() {
        return this.ctx.handler();
    }

    @Override
    public boolean isRemoved() {
        return this.ctx.isRemoved();
    }

    @Override
    public ChannelHandlerContext fireChannelRegistered() {
        this.ctx.fireChannelRegistered();
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelUnregistered() {
        this.ctx.fireChannelUnregistered();
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelActive() {
        this.ctx.fireChannelActive();
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelInactive() {
        this.ctx.fireChannelInactive();
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelShutdown(ChannelShutdownDirection direction) {
        this.ctx.fireChannelShutdown(direction);
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelExceptionCaught(Throwable cause) {
        this.ctx.fireChannelExceptionCaught(cause);
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelInboundEvent(Object evt) {
        this.ctx.fireChannelInboundEvent(evt);
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelRead(Object msg) {
        this.ctx.fireChannelRead(msg);
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelReadComplete() {
        this.ctx.fireChannelReadComplete();
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelWritabilityChanged() {
        this.ctx.fireChannelWritabilityChanged();
        return this;
    }

    @Override
    public ChannelHandlerContext read(ReadBufferAllocator readBufferAllocator) {
        this.ctx.read(readBufferAllocator);
        return this;
    }

    @Override
    public ChannelHandlerContext read() {
        this.ctx.read();
        return this;
    }

    @Override
    public ChannelHandlerContext flush() {
        this.ctx.flush();
        return this;
    }

    @Override
    public Future<Void> sendOutboundEvent(Object event) {
        return this.ctx.sendOutboundEvent(event);
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.ctx.pipeline();
    }

    @Override
    public BufferAllocator bufferAllocator() {
        return this.ctx.bufferAllocator();
    }

    @Override
    public Future<Void> bind(SocketAddress localAddress) {
        return this.ctx.bind(localAddress);
    }

    @Override
    public Future<Void> connect(SocketAddress remoteAddress) {
        return this.ctx.connect(remoteAddress);
    }

    @Override
    public Future<Void> connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.ctx.connect(remoteAddress, localAddress);
    }

    @Override
    public Future<Void> disconnect() {
        return this.ctx.disconnect();
    }

    @Override
    public Future<Void> close() {
        return this.ctx.close();
    }

    @Override
    public Future<Void> shutdown(ChannelShutdownDirection direction) {
        return this.ctx.shutdown(direction);
    }

    @Override
    public Future<Void> deregister() {
        return this.ctx.deregister();
    }

    @Override
    public Future<Void> register() {
        return this.ctx.register();
    }

    @Override
    public Future<Void> write(Object msg) {
        return this.ctx.write(msg);
    }

    @Override
    public Future<Void> writeAndFlush(Object msg) {
        return this.ctx.writeAndFlush(msg);
    }

    @Override
    public <V> Promise<V> newPromise() {
        return this.ctx.newPromise();
    }

    @Override
    public Future<Void> newSucceededFuture() {
        return this.ctx.newSucceededFuture();
    }

    @Override
    public <V> Future<V> newFailedFuture(Throwable cause) {
        return this.ctx.newFailedFuture(cause);
    }

    @Override
    public <V> Future<V> newSucceededFuture(V value) {
        return this.ctx.newSucceededFuture(value);
    }
}

