/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.epoll;

import io.netty5.buffer.Buffer;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelException;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.ReadHandleFactory;
import io.netty5.channel.ServerChannelReadHandleFactory;
import io.netty5.channel.ServerChannelWriteHandleFactory;
import io.netty5.channel.WriteHandleFactory;
import io.netty5.channel.epoll.AbstractEpollChannel;
import io.netty5.channel.epoll.EpollChannelOption;
import io.netty5.channel.epoll.EpollSocketChannel;
import io.netty5.channel.epoll.LinuxSocket;
import io.netty5.channel.epoll.Native;
import io.netty5.channel.epoll.TcpMd5Util;
import io.netty5.channel.socket.DomainSocketAddress;
import io.netty5.channel.socket.ServerSocketChannel;
import io.netty5.channel.socket.SocketProtocolFamily;
import io.netty5.channel.unix.NativeInetAddress;
import io.netty5.channel.unix.UnixChannel;
import io.netty5.channel.unix.UnixChannelOption;
import io.netty5.util.NetUtil;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public final class EpollServerSocketChannel
extends AbstractEpollChannel<UnixChannel>
implements ServerSocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollServerSocketChannel.class);
    private static final Set<ChannelOption<?>> SUPPORTED_OPTIONS = EpollServerSocketChannel.supportedOptions();
    private static final Set<ChannelOption<?>> SUPPORTED_OPTIONS_DOMAIN_SOCKET = EpollServerSocketChannel.supportedOptionsDomainSocket();
    private final EventLoopGroup childEventLoopGroup;
    private final byte[] acceptedAddress = new byte[26];
    private volatile int backlog = NetUtil.SOMAXCONN;
    private volatile int pendingFastOpenRequestsThreshold;
    private volatile Collection<InetAddress> tcpMd5SigAddresses = Collections.emptyList();

    public EpollServerSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup) {
        super(eventLoop, false, 0, (ReadHandleFactory)new ServerChannelReadHandleFactory(), (WriteHandleFactory)new ServerChannelWriteHandleFactory(), LinuxSocket.newSocketStream());
        this.childEventLoopGroup = EpollServerSocketChannel.validateEventLoopGroup(childEventLoopGroup, "childEventLoopGroup", EpollSocketChannel.class);
    }

    public EpollServerSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup, ProtocolFamily protocolFamily) {
        super(null, eventLoop, false, 0, (ReadHandleFactory)new ServerChannelReadHandleFactory(), (WriteHandleFactory)new ServerChannelWriteHandleFactory(), LinuxSocket.newSocket(protocolFamily), false);
        this.childEventLoopGroup = EpollServerSocketChannel.validateEventLoopGroup(childEventLoopGroup, "childEventLoopGroup", EpollSocketChannel.class);
    }

    public EpollServerSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup, int fd, ProtocolFamily protocolFamily) {
        this(eventLoop, childEventLoopGroup, new LinuxSocket(fd, SocketProtocolFamily.of(protocolFamily)));
    }

    private EpollServerSocketChannel(EventLoop eventLoop, EventLoopGroup childEventLoopGroup, LinuxSocket socket) {
        super(null, eventLoop, false, 0, (ReadHandleFactory)new ServerChannelReadHandleFactory(), (WriteHandleFactory)new ServerChannelWriteHandleFactory(), socket, EpollServerSocketChannel.isSoErrorZero(socket));
        this.childEventLoopGroup = EpollServerSocketChannel.validateEventLoopGroup(childEventLoopGroup, "childEventLoopGroup", EpollSocketChannel.class);
    }

    @Override
    public EventLoopGroup childEventLoopGroup() {
        return this.childEventLoopGroup;
    }

    @Override
    protected <T> T getExtendedOption(ChannelOption<T> option) {
        if (EpollServerSocketChannel.isOptionSupported(this.socket.protocolFamily(), option)) {
            if (option == ChannelOption.SO_RCVBUF) {
                return (T)Integer.valueOf(this.getReceiveBufferSize());
            }
            if (option == ChannelOption.SO_REUSEADDR) {
                return (T)Boolean.valueOf(this.isReuseAddress());
            }
            if (option == ChannelOption.SO_BACKLOG) {
                return (T)Integer.valueOf(this.getBacklog());
            }
            if (option == ChannelOption.TCP_FASTOPEN) {
                return (T)Integer.valueOf(this.getTcpFastopen());
            }
            if (option == EpollChannelOption.IP_FREEBIND) {
                return (T)Boolean.valueOf(this.isIpFreebind());
            }
            if (option == EpollChannelOption.TCP_DEFER_ACCEPT) {
                return (T)Integer.valueOf(this.getTcpDeferAccept());
            }
            if (option == UnixChannelOption.SO_REUSEPORT) {
                return (T)Boolean.valueOf(this.isReusePort());
            }
            if (option == EpollChannelOption.TCP_MD5SIG) {
                return null;
            }
        }
        return super.getExtendedOption(option);
    }

    @Override
    protected <T> void setExtendedOption(ChannelOption<T> option, T value) {
        if (EpollServerSocketChannel.isOptionSupported(this.socket.protocolFamily(), option)) {
            if (option == ChannelOption.SO_RCVBUF) {
                this.setReceiveBufferSize((Integer)value);
            } else if (option == ChannelOption.SO_REUSEADDR) {
                this.setReuseAddress((Boolean)value);
            } else if (option == ChannelOption.SO_BACKLOG) {
                this.setBacklog((Integer)value);
            } else if (option == ChannelOption.TCP_FASTOPEN) {
                this.setTcpFastopen((Integer)value);
            } else if (option == EpollChannelOption.IP_FREEBIND) {
                this.setIpFreebind((Boolean)value);
            } else if (option == EpollChannelOption.TCP_DEFER_ACCEPT) {
                this.setTcpDeferAccept((Integer)value);
            } else if (option == UnixChannelOption.SO_REUSEPORT) {
                this.setReusePort((Boolean)value);
            } else if (option == EpollChannelOption.TCP_MD5SIG) {
                this.setTcpMd5Sig((Map)value);
            }
        } else {
            super.setExtendedOption(option, value);
        }
    }

    private static boolean isOptionSupported(SocketProtocolFamily family, ChannelOption<?> option) {
        if (family == SocketProtocolFamily.UNIX) {
            return SUPPORTED_OPTIONS_DOMAIN_SOCKET.contains(option);
        }
        return SUPPORTED_OPTIONS.contains(option);
    }

    @Override
    protected boolean isExtendedOptionSupported(ChannelOption<?> option) {
        return EpollServerSocketChannel.isOptionSupported(this.socket.protocolFamily(), option) || super.isExtendedOptionSupported(option);
    }

    private static Set<ChannelOption<?>> supportedOptions() {
        return EpollServerSocketChannel.newSupportedIdentityOptionsSet(ChannelOption.SO_RCVBUF, ChannelOption.SO_REUSEADDR, ChannelOption.SO_BACKLOG, ChannelOption.TCP_FASTOPEN, EpollChannelOption.TCP_MD5SIG, EpollChannelOption.SO_REUSEPORT, EpollChannelOption.IP_FREEBIND, EpollChannelOption.TCP_DEFER_ACCEPT);
    }

    private static Set<ChannelOption<?>> supportedOptionsDomainSocket() {
        return EpollServerSocketChannel.newSupportedIdentityOptionsSet(ChannelOption.SO_RCVBUF, ChannelOption.SO_REUSEADDR, ChannelOption.SO_BACKLOG);
    }

    private boolean isReuseAddress() {
        try {
            return this.socket.isReuseAddress();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setReuseAddress(boolean reuseAddress) {
        try {
            this.socket.setReuseAddress(reuseAddress);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setReusePort(boolean reusePort) {
        try {
            this.socket.setReusePort(reusePort);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private boolean isReusePort() {
        try {
            return this.socket.isReusePort();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setIpFreebind(boolean reusePort) {
        try {
            this.socket.setIpFreeBind(reusePort);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private boolean isIpFreebind() {
        try {
            return this.socket.isIpFreeBind();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private int getReceiveBufferSize() {
        try {
            return this.socket.getReceiveBufferSize();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setReceiveBufferSize(int receiveBufferSize) {
        try {
            this.socket.setReceiveBufferSize(receiveBufferSize);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private int getBacklog() {
        return this.backlog;
    }

    private void setBacklog(int backlog) {
        ObjectUtil.checkPositiveOrZero(backlog, "backlog");
        this.backlog = backlog;
    }

    private int getTcpDeferAccept() {
        try {
            return this.socket.getTcpDeferAccept();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setTcpDeferAccept(int deferAccept) {
        try {
            this.socket.setTcpDeferAccept(deferAccept);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private int getTcpFastopen() {
        return this.pendingFastOpenRequestsThreshold;
    }

    private void setTcpFastopen(int pendingFastOpenRequestsThreshold) {
        ObjectUtil.checkPositiveOrZero(pendingFastOpenRequestsThreshold, "pendingFastOpenRequestsThreshold");
        this.pendingFastOpenRequestsThreshold = pendingFastOpenRequestsThreshold;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        int tcpFastopen;
        super.doBind(localAddress);
        if (this.socket.protocolFamily() != SocketProtocolFamily.UNIX && Native.IS_SUPPORTING_TCP_FASTOPEN_SERVER && (tcpFastopen = this.getTcpFastopen()) > 0) {
            this.socket.setTcpFastOpen(tcpFastopen);
        }
        this.socket.listen(this.getBacklog());
        this.active = true;
    }

    @Override
    protected void doWriteNow(AbstractChannel.WriteSink writeHandle) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object filterOutboundMessage(Object msg) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected AbstractEpollChannel.ReadState epollInReady(AbstractChannel.ReadSink readSink) throws Exception {
        int acceptedFd = this.socket.accept(this.acceptedAddress);
        if (acceptedFd == -1) {
            readSink.processRead(0, 0, null);
            return AbstractEpollChannel.ReadState.All;
        }
        readSink.processRead(0, 0, this.newChildChannel(acceptedFd, this.acceptedAddress, 1, this.acceptedAddress[0]));
        return AbstractEpollChannel.ReadState.Partial;
    }

    @Override
    protected void doShutdown(ChannelShutdownDirection direction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown(ChannelShutdownDirection direction) {
        return !this.isActive();
    }

    @Override
    protected boolean doFinishConnect(SocketAddress requestedRemoteAddress) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress, Buffer initialData) {
        throw new UnsupportedOperationException();
    }

    private Channel newChildChannel(int fd, byte[] address, int offset, int len) {
        InetSocketAddress remote = this.socket.protocolFamily() == SocketProtocolFamily.UNIX ? null : NativeInetAddress.address(address, offset, len);
        return new EpollSocketChannel(this, this.childEventLoopGroup().next(), new LinuxSocket(fd, this.socket.protocolFamily()), remote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws Exception {
        try {
            super.doClose();
        }
        finally {
            File socketFile;
            boolean success;
            DomainSocketAddress local;
            if (this.socket.protocolFamily() == SocketProtocolFamily.UNIX && (local = (DomainSocketAddress)this.localAddress()) != null && !(success = (socketFile = new File(local.path())).delete()) && logger.isDebugEnabled()) {
                logger.debug("Failed to delete a domain socket file: {}", (Object)local.path());
            }
        }
    }

    Collection<InetAddress> tcpMd5SigAddresses() {
        return this.tcpMd5SigAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTcpMd5Sig(Map<InetAddress, byte[]> keys) {
        EpollServerSocketChannel epollServerSocketChannel = this;
        synchronized (epollServerSocketChannel) {
            try {
                this.tcpMd5SigAddresses = TcpMd5Util.newTcpMd5Sigs(this, this.tcpMd5SigAddresses, keys);
            }
            catch (IOException e) {
                throw new ChannelException(e);
            }
        }
    }
}

