/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.epoll;

import io.netty5.channel.DefaultSelectStrategyFactory;
import io.netty5.channel.IoExecutionContext;
import io.netty5.channel.IoHandle;
import io.netty5.channel.IoHandler;
import io.netty5.channel.IoHandlerFactory;
import io.netty5.channel.SelectStrategy;
import io.netty5.channel.SelectStrategyFactory;
import io.netty5.channel.SingleThreadEventLoop;
import io.netty5.channel.epoll.AbstractEpollChannel;
import io.netty5.channel.epoll.Epoll;
import io.netty5.channel.epoll.EpollEventArray;
import io.netty5.channel.epoll.EpollRegistration;
import io.netty5.channel.epoll.Native;
import io.netty5.channel.epoll.NativeDatagramPacketArray;
import io.netty5.channel.unix.FileDescriptor;
import io.netty5.channel.unix.IovArray;
import io.netty5.util.collection.IntObjectHashMap;
import io.netty5.util.collection.IntObjectMap;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.SystemPropertyUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntSupplier;

public class EpollHandler
implements IoHandler {
    private static final long EPOLL_WAIT_MILLIS_THRESHOLD = SystemPropertyUtil.getLong("io.netty5.channel.epoll.epollWaitThreshold", 10L);
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollHandler.class);
    private long prevDeadlineNanos = SingleThreadEventLoop.nanoTime() - 1L;
    private final FileDescriptor epollFd;
    private final FileDescriptor eventFd;
    private final FileDescriptor timerFd;
    private final IntObjectMap<AbstractEpollChannel<?>> channels = new IntObjectHashMap(4096);
    private final boolean allowGrowing;
    private final EpollEventArray events;
    private IovArray iovArray;
    private NativeDatagramPacketArray datagramPacketArray;
    private final SelectStrategy selectStrategy;
    private final IntSupplier selectNowSupplier = () -> {
        try {
            return this.epollWaitNow();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    };
    private static final long AWAKE = -1L;
    private static final long NONE = Long.MAX_VALUE;
    private final AtomicLong nextWakeupNanos = new AtomicLong(-1L);
    private boolean pendingWakeup;
    private static final long MAX_SCHEDULED_TIMERFD_NS = 999999999L;

    private static AbstractEpollChannel<?> cast(IoHandle handle) {
        if (handle instanceof AbstractEpollChannel) {
            return (AbstractEpollChannel)handle;
        }
        throw new IllegalArgumentException("Channel of type " + StringUtil.simpleClassName(handle) + " not supported");
    }

    private EpollHandler() {
        this(0, DefaultSelectStrategyFactory.INSTANCE.newSelectStrategy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EpollHandler(int maxEvents, SelectStrategy strategy) {
        this.selectStrategy = strategy;
        if (maxEvents == 0) {
            this.allowGrowing = true;
            this.events = new EpollEventArray(4096);
        } else {
            this.allowGrowing = false;
            this.events = new EpollEventArray(maxEvents);
        }
        boolean success = false;
        FileDescriptor epollFd = null;
        FileDescriptor eventFd = null;
        FileDescriptor timerFd = null;
        try {
            this.epollFd = epollFd = Native.newEpollCreate();
            this.eventFd = eventFd = Native.newEventFd();
            try {
                Native.epollCtlAdd(epollFd.intValue(), eventFd.intValue(), Native.EPOLLIN | Native.EPOLLET);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to add eventFd filedescriptor to epoll", e);
            }
            this.timerFd = timerFd = Native.newTimerFd();
            try {
                Native.epollCtlAdd(epollFd.intValue(), timerFd.intValue(), Native.EPOLLIN | Native.EPOLLET);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to add timerFd filedescriptor to epoll", e);
            }
            success = true;
        }
        finally {
            if (!success) {
                if (epollFd != null) {
                    try {
                        epollFd.close();
                    }
                    catch (Exception exception) {}
                }
                if (eventFd != null) {
                    try {
                        eventFd.close();
                    }
                    catch (Exception exception) {}
                }
                if (timerFd != null) {
                    try {
                        timerFd.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static IoHandlerFactory newFactory() {
        return EpollHandler::new;
    }

    public static IoHandlerFactory newFactory(int maxEvents, SelectStrategyFactory selectStrategyFactory) {
        ObjectUtil.checkPositiveOrZero(maxEvents, "maxEvents");
        Objects.requireNonNull(selectStrategyFactory, "selectStrategyFactory");
        return () -> new EpollHandler(maxEvents, selectStrategyFactory.newSelectStrategy());
    }

    private IovArray cleanIovArray() {
        if (this.iovArray == null) {
            this.iovArray = new IovArray();
        } else {
            this.iovArray.clear();
        }
        return this.iovArray;
    }

    private NativeDatagramPacketArray cleanDatagramPacketArray() {
        if (this.datagramPacketArray == null) {
            this.datagramPacketArray = new NativeDatagramPacketArray();
        } else {
            this.datagramPacketArray.clear();
        }
        return this.datagramPacketArray;
    }

    @Override
    public final void register(IoHandle handle) throws Exception {
        final AbstractEpollChannel<?> epollChannel = EpollHandler.cast(handle);
        epollChannel.register0(new EpollRegistration(){

            @Override
            public void update() throws IOException {
                EpollHandler.this.modify(epollChannel);
            }

            @Override
            public void remove() throws IOException {
                EpollHandler.this.remove(epollChannel);
            }

            @Override
            public IovArray cleanIovArray() {
                return EpollHandler.this.cleanIovArray();
            }

            @Override
            public NativeDatagramPacketArray cleanDatagramPacketArray() {
                return EpollHandler.this.cleanDatagramPacketArray();
            }
        });
        this.add(epollChannel);
    }

    @Override
    public final void deregister(IoHandle handle) throws Exception {
        EpollHandler.cast(handle).deregister0();
    }

    @Override
    public final void wakeup(boolean inEventLoop) {
        if (!inEventLoop && this.nextWakeupNanos.getAndSet(-1L) != -1L) {
            Native.eventFdWrite(this.eventFd.intValue(), 1L);
        }
    }

    private void add(AbstractEpollChannel<?> ch) throws IOException {
        int fd = ch.socket.intValue();
        Native.epollCtlAdd(this.epollFd.intValue(), fd, ch.flags());
        AbstractEpollChannel<?> old = this.channels.put(fd, ch);
        assert (old == null || !old.isOpen());
    }

    private void modify(AbstractEpollChannel<?> ch) throws IOException {
        Native.epollCtlMod(this.epollFd.intValue(), ch.socket.intValue(), ch.flags());
    }

    private void remove(AbstractEpollChannel<?> ch) throws IOException {
        int fd = ch.socket.intValue();
        AbstractEpollChannel<?> old = this.channels.remove(fd);
        if (old != null && old != ch) {
            this.channels.put(fd, old);
            assert (!ch.isOpen());
        } else if (ch.isOpen()) {
            Native.epollCtlDel(this.epollFd.intValue(), fd);
        }
    }

    private long epollWait(IoExecutionContext context, long deadlineNanos) throws IOException {
        if (deadlineNanos == Long.MAX_VALUE) {
            return Native.epollWait(this.epollFd, this.events, this.timerFd, Integer.MAX_VALUE, 0, EPOLL_WAIT_MILLIS_THRESHOLD);
        }
        long totalDelay = context.delayNanos(System.nanoTime());
        int delaySeconds = (int)Math.min(totalDelay / 1000000000L, Integer.MAX_VALUE);
        int delayNanos = (int)Math.min(totalDelay - (long)delaySeconds * 1000000000L, 999999999L);
        return Native.epollWait(this.epollFd, this.events, this.timerFd, delaySeconds, delayNanos, EPOLL_WAIT_MILLIS_THRESHOLD);
    }

    private int epollWaitNoTimerChange() throws IOException {
        return Native.epollWait(this.epollFd, this.events, false);
    }

    private int epollWaitNow() throws IOException {
        return Native.epollWait(this.epollFd, this.events, true);
    }

    private int epollBusyWait() throws IOException {
        return Native.epollBusyWait(this.epollFd, this.events);
    }

    private int epollWaitTimeboxed() throws IOException {
        return Native.epollWait(this.epollFd, this.events, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int run(IoExecutionContext context) {
        int handled = 0;
        try {
            int strategy = this.selectStrategy.calculateStrategy(this.selectNowSupplier, !context.canBlock());
            switch (strategy) {
                case -2: {
                    return 0;
                }
                case -3: {
                    strategy = this.epollBusyWait();
                    break;
                }
                case -1: {
                    long curDeadlineNanos;
                    if (this.pendingWakeup) {
                        strategy = this.epollWaitTimeboxed();
                        if (strategy != 0) break;
                        logger.warn("Missed eventfd write (not seen after > 1 second)");
                        this.pendingWakeup = false;
                        if (!context.canBlock()) break;
                    }
                    if ((curDeadlineNanos = context.deadlineNanos()) == -1L) {
                        curDeadlineNanos = Long.MAX_VALUE;
                    }
                    this.nextWakeupNanos.set(curDeadlineNanos);
                    try {
                        if (context.canBlock()) {
                            if (curDeadlineNanos == this.prevDeadlineNanos) {
                                strategy = this.epollWaitNoTimerChange();
                            } else {
                                long result = this.epollWait(context, curDeadlineNanos);
                                strategy = Native.epollReady(result);
                                long l = this.prevDeadlineNanos = Native.epollTimerWasUsed(result) ? curDeadlineNanos : Long.MAX_VALUE;
                            }
                        }
                        if (this.nextWakeupNanos.get() != -1L && this.nextWakeupNanos.getAndSet(-1L) != -1L) break;
                        this.pendingWakeup = true;
                        break;
                    }
                    catch (Throwable throwable) {
                        if (this.nextWakeupNanos.get() == -1L || this.nextWakeupNanos.getAndSet(-1L) == -1L) {
                            this.pendingWakeup = true;
                        }
                        throw throwable;
                    }
                }
            }
            if (strategy > 0) {
                handled = strategy;
                if (this.processReady(this.events, strategy)) {
                    this.prevDeadlineNanos = Long.MAX_VALUE;
                }
            }
            if (this.allowGrowing && strategy == this.events.length()) {
                this.events.increase();
            }
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable t) {
            this.handleLoopException(t);
        }
        return handled;
    }

    void handleLoopException(Throwable t) {
        logger.warn("Unexpected exception in the selector loop.", t);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void prepareToDestroy() {
        AbstractEpollChannel[] localChannels;
        for (AbstractEpollChannel ch : localChannels = this.channels.values().toArray(new AbstractEpollChannel[0])) {
            ch.closeTransportNow();
        }
    }

    private boolean processReady(EpollEventArray events, int ready) {
        boolean timerFired = false;
        for (int i = 0; i < ready; ++i) {
            int fd = events.fd(i);
            if (fd == this.eventFd.intValue()) {
                this.pendingWakeup = false;
                continue;
            }
            if (fd == this.timerFd.intValue()) {
                timerFired = true;
                continue;
            }
            long ev = events.events(i);
            AbstractEpollChannel<?> ch = this.channels.get(fd);
            if (ch != null) {
                if ((ev & (long)(Native.EPOLLERR | Native.EPOLLOUT)) != 0L) {
                    ch.epollOutReady();
                }
                if ((ev & (long)(Native.EPOLLERR | Native.EPOLLIN)) != 0L) {
                    ch.epollInReady();
                }
                if ((ev & (long)Native.EPOLLRDHUP) == 0L) continue;
                ch.epollRdHupReady();
                continue;
            }
            try {
                Native.epollCtlDel(this.epollFd.intValue(), fd);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return timerFired;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void destroy() {
        try {
            block11: while (this.pendingWakeup) {
                try {
                    int count = this.epollWaitTimeboxed();
                    if (count == 0) break;
                    for (int i = 0; i < count; ++i) {
                        if (this.events.fd(i) != this.eventFd.intValue()) continue;
                        this.pendingWakeup = false;
                        continue block11;
                    }
                }
                catch (IOException count) {
                }
            }
            try {
                this.eventFd.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close the event fd.", e);
            }
            try {
                this.timerFd.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close the timer fd.", e);
            }
            try {
                this.epollFd.close();
                return;
            }
            catch (IOException e) {
                logger.warn("Failed to close the epoll fd.", e);
                return;
            }
        }
        finally {
            if (this.iovArray != null) {
                this.iovArray.release();
                this.iovArray = null;
            }
            if (this.datagramPacketArray != null) {
                this.datagramPacketArray.release();
                this.datagramPacketArray = null;
            }
            this.events.free();
        }
    }

    @Override
    public boolean isCompatible(Class<? extends IoHandle> handleType) {
        return AbstractEpollChannel.class.isAssignableFrom(handleType);
    }

    static {
        Epoll.ensureAvailability();
    }
}

