/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.epoll;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ComponentIterator;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.AddressedEnvelope;
import io.netty5.channel.ChannelException;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.DefaultBufferAddressedEnvelope;
import io.netty5.channel.EventLoop;
import io.netty5.channel.FixedReadHandleFactory;
import io.netty5.channel.MaxMessagesWriteHandleFactory;
import io.netty5.channel.ReadHandleFactory;
import io.netty5.channel.WriteHandleFactory;
import io.netty5.channel.epoll.AbstractEpollChannel;
import io.netty5.channel.epoll.Epoll;
import io.netty5.channel.epoll.EpollChannelOption;
import io.netty5.channel.epoll.LinuxSocket;
import io.netty5.channel.epoll.Native;
import io.netty5.channel.epoll.NativeDatagramPacketArray;
import io.netty5.channel.socket.DatagramChannel;
import io.netty5.channel.socket.DatagramPacket;
import io.netty5.channel.socket.DomainSocketAddress;
import io.netty5.channel.socket.SocketProtocolFamily;
import io.netty5.channel.unix.DomainDatagramSocketAddress;
import io.netty5.channel.unix.Errors;
import io.netty5.channel.unix.SegmentedDatagramPacket;
import io.netty5.channel.unix.UnixChannel;
import io.netty5.channel.unix.UnixChannelOption;
import io.netty5.channel.unix.UnixChannelUtil;
import io.netty5.util.Resource;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.RecyclableArrayList;
import io.netty5.util.internal.SilentDispose;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Objects;
import java.util.Set;

public final class EpollDatagramChannel
extends AbstractEpollChannel<UnixChannel>
implements DatagramChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollDatagramChannel.class);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + "<" + StringUtil.simpleClassName(Buffer.class) + ", " + StringUtil.simpleClassName(InetSocketAddress.class) + ">, " + StringUtil.simpleClassName(Buffer.class) + ")";
    private static final String EXPECTED_TYPES_DOMAIN_SOCKET = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + "<" + StringUtil.simpleClassName(Buffer.class) + ", " + StringUtil.simpleClassName(DomainSocketAddress.class) + ">, " + StringUtil.simpleClassName(Buffer.class) + ")";
    private static final Set<ChannelOption<?>> SUPPORTED_OPTIONS = EpollDatagramChannel.supportedOptions();
    private static final Set<ChannelOption<?>> SUPPORTED_OPTIONS_DOMAIN_SOCKET = EpollDatagramChannel.supportedOptionsDomainSocket();
    private static final Object NULL = new Object();
    private volatile boolean activeOnOpen;
    private volatile int maxDatagramSize;
    private volatile boolean gro;
    private volatile boolean connected;
    private volatile boolean inputShutdown;
    private volatile boolean outputShutdown;

    public static boolean isSegmentedDatagramPacketSupported() {
        return Epoll.isAvailable() && Native.IS_SUPPORTING_SENDMMSG && Native.IS_SUPPORTING_UDP_SEGMENT;
    }

    public EpollDatagramChannel(EventLoop eventLoop) {
        this(eventLoop, null);
    }

    public EpollDatagramChannel(EventLoop eventLoop, ProtocolFamily family) {
        this(eventLoop, LinuxSocket.newDatagramSocket(family), false);
    }

    public EpollDatagramChannel(EventLoop eventLoop, int fd, ProtocolFamily family) {
        this(eventLoop, new LinuxSocket(fd, SocketProtocolFamily.of(family)), true);
    }

    private EpollDatagramChannel(EventLoop eventLoop, LinuxSocket fd, boolean active) {
        super(null, eventLoop, true, 0, (ReadHandleFactory)new FixedReadHandleFactory(2048), (WriteHandleFactory)new MaxMessagesWriteHandleFactory(Integer.MAX_VALUE), fd, active);
    }

    @Override
    public boolean isActive() {
        return this.socket.isOpen() && (this.getActiveOnOpen() && this.isRegistered() || this.active);
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    private NetworkInterface networkInterface() throws SocketException {
        Object localAddress;
        NetworkInterface iface = this.getNetworkInterface();
        if (iface == null && (localAddress = this.localAddress()) instanceof InetSocketAddress) {
            return NetworkInterface.getByInetAddress(((InetSocketAddress)this.localAddress()).getAddress());
        }
        return null;
    }

    @Override
    public Future<Void> joinGroup(InetAddress multicastAddress) {
        try {
            return this.joinGroup(multicastAddress, this.networkInterface(), null);
        }
        catch (IOException | UnsupportedOperationException e) {
            return this.newFailedFuture(e);
        }
    }

    @Override
    public Future<Void> joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        Objects.requireNonNull(multicastAddress, "multicastAddress");
        Objects.requireNonNull(networkInterface, "networkInterface");
        if (this.socket.protocolFamily() == SocketProtocolFamily.UNIX) {
            return this.newFailedFuture(new UnsupportedOperationException("Multicast not supported"));
        }
        Promise<Void> promise = this.newPromise();
        if (this.executor().inEventLoop()) {
            this.joinGroup0(multicastAddress, networkInterface, source, promise);
        } else {
            this.executor().execute(() -> this.joinGroup0(multicastAddress, networkInterface, source, promise));
        }
        return promise.asFuture();
    }

    private void joinGroup0(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, Promise<Void> promise) {
        assert (this.executor().inEventLoop());
        try {
            this.socket.joinGroup(multicastAddress, networkInterface, source);
        }
        catch (IOException e) {
            promise.setFailure(e);
            return;
        }
        promise.setSuccess(null);
    }

    @Override
    public Future<Void> leaveGroup(InetAddress multicastAddress) {
        try {
            return this.leaveGroup(multicastAddress, this.networkInterface(), null);
        }
        catch (IOException | UnsupportedOperationException e) {
            return this.newFailedFuture(e);
        }
    }

    @Override
    public Future<Void> leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        Objects.requireNonNull(multicastAddress, "multicastAddress");
        Objects.requireNonNull(networkInterface, "networkInterface");
        if (this.socket.protocolFamily() == SocketProtocolFamily.UNIX) {
            return this.newFailedFuture(new UnsupportedOperationException("Multicast not supported"));
        }
        Promise<Void> promise = this.newPromise();
        if (this.executor().inEventLoop()) {
            this.leaveGroup0(multicastAddress, networkInterface, source, promise);
        } else {
            this.executor().execute(() -> this.leaveGroup0(multicastAddress, networkInterface, source, promise));
        }
        return promise.asFuture();
    }

    private void leaveGroup0(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, Promise<Void> promise) {
        assert (this.executor().inEventLoop());
        try {
            this.socket.leaveGroup(multicastAddress, networkInterface, source);
        }
        catch (IOException e) {
            promise.setFailure(e);
            return;
        }
        promise.setSuccess(null);
    }

    @Override
    public Future<Void> block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock) {
        Objects.requireNonNull(multicastAddress, "multicastAddress");
        Objects.requireNonNull(sourceToBlock, "sourceToBlock");
        Objects.requireNonNull(networkInterface, "networkInterface");
        return this.newFailedFuture(new UnsupportedOperationException("Multicast block not supported"));
    }

    @Override
    public Future<Void> block(InetAddress multicastAddress, InetAddress sourceToBlock) {
        try {
            return this.block(multicastAddress, this.networkInterface(), sourceToBlock);
        }
        catch (IOException | UnsupportedOperationException e) {
            return this.newFailedFuture(e);
        }
    }

    @Override
    protected void doShutdown(ChannelShutdownDirection direction) {
        switch (direction) {
            case Inbound: {
                this.inputShutdown = true;
                break;
            }
            case Outbound: {
                this.outputShutdown = true;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public boolean isShutdown(ChannelShutdownDirection direction) {
        if (!this.isActive()) {
            return true;
        }
        switch (direction) {
            case Inbound: {
                return this.inputShutdown;
            }
            case Outbound: {
                return this.outputShutdown;
            }
        }
        throw new AssertionError();
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        InetSocketAddress socketAddress;
        if (localAddress instanceof InetSocketAddress && (socketAddress = (InetSocketAddress)localAddress).getAddress().isAnyLocalAddress() && socketAddress.getAddress() instanceof Inet4Address && this.socket.protocolFamily() == SocketProtocolFamily.INET6) {
            localAddress = new InetSocketAddress(LinuxSocket.INET6_ANY, socketAddress.getPort());
        }
        super.doBind(localAddress);
        this.active = true;
    }

    @Override
    protected void doWriteNow(AbstractChannel.WriteSink writeSink) throws Exception {
        if (Native.IS_SUPPORTING_SENDMMSG && this.socket.protocolFamily() != SocketProtocolFamily.UNIX && writeSink.numFlushedMessages() > 1 || writeSink.currentFlushedMessage() instanceof SegmentedDatagramPacket) {
            NativeDatagramPacketArray array = this.cleanDatagramPacketArray();
            writeSink.forEachFlushedMessage(array.addFunction(this.isConnected(), Integer.MAX_VALUE));
            int cnt = array.count();
            if (cnt >= 1) {
                int offset = 0;
                NativeDatagramPacketArray.NativeDatagramPacket[] packets = array.packets();
                long sentBytes = 0L;
                long notSentBytes = 0L;
                try {
                    int send = this.socket.sendmmsg(packets, offset, cnt);
                    for (int i = 0; i < cnt; ++i) {
                        int count = packets[i].count();
                        if (i < send) {
                            sentBytes += (long)count;
                            continue;
                        }
                        notSentBytes += (long)count;
                    }
                    writeSink.complete(sentBytes + notSentBytes, sentBytes, send, send > 0);
                }
                catch (IOException e) {
                    for (int i = 0; i < cnt; ++i) {
                        int count = packets[i].count();
                        notSentBytes += (long)count;
                    }
                    writeSink.complete(sentBytes + notSentBytes, e, true);
                }
                return;
            }
        }
        this.doWriteMessage(writeSink);
    }

    private void doWriteMessage(AbstractChannel.WriteSink writeSink) throws Exception {
        Object remoteAddress;
        Buffer data;
        Object msg = writeSink.currentFlushedMessage();
        if (msg instanceof AddressedEnvelope) {
            AddressedEnvelope envelope = (AddressedEnvelope)msg;
            data = (Buffer)envelope.content();
            remoteAddress = envelope.recipient();
        } else {
            data = (Buffer)msg;
            remoteAddress = this.remoteAddress();
        }
        if (data.readableBytes() == 0) {
            writeSink.complete(0L, 0L, 1, true);
            return;
        }
        long result = this.doWriteOrSendBytes(data, (SocketAddress)remoteAddress, false);
        writeSink.complete(data.readableBytes(), result, result > 0L ? 1 : 0, result > 0L);
    }

    @Override
    protected Object filterOutboundMessage(Object msg) {
        if (this.socket.protocolFamily() == SocketProtocolFamily.UNIX) {
            return this.filterOutboundMessage0(msg, DomainSocketAddress.class, EXPECTED_TYPES_DOMAIN_SOCKET);
        }
        return this.filterOutboundMessage0(msg, InetSocketAddress.class, EXPECTED_TYPES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object filterOutboundMessage0(Object msg, Class<? extends SocketAddress> recipientClass, String expectedTypes) {
        if (msg instanceof SegmentedDatagramPacket) {
            if (!Native.IS_SUPPORTING_UDP_SEGMENT) {
                throw new UnsupportedOperationException("Unsupported message type: " + StringUtil.simpleClassName(msg) + expectedTypes);
            }
            SegmentedDatagramPacket packet = (SegmentedDatagramPacket)msg;
            if (recipientClass.isInstance(packet.recipient())) {
                Buffer content = (Buffer)packet.content();
                return UnixChannelUtil.isBufferCopyNeededForWrite(content) ? packet.replace(this.newDirectBuffer(packet, content)) : msg;
            }
        } else if (msg instanceof DatagramPacket) {
            DatagramPacket packet = (DatagramPacket)msg;
            if (recipientClass.isInstance(packet.recipient())) {
                Buffer content = (Buffer)packet.content();
                return UnixChannelUtil.isBufferCopyNeededForWrite(content) ? new DatagramPacket(this.newDirectBuffer(packet, content), (SocketAddress)packet.recipient()) : msg;
            }
        } else {
            AddressedEnvelope e;
            if (msg instanceof Buffer) {
                Buffer buf = (Buffer)msg;
                return UnixChannelUtil.isBufferCopyNeededForWrite(buf) ? this.newDirectBuffer(buf) : buf;
            }
            if (msg instanceof AddressedEnvelope && recipientClass.isInstance((e = (AddressedEnvelope)msg).recipient())) {
                InetSocketAddress recipient = (InetSocketAddress)e.recipient();
                Object content = e.content();
                if (content instanceof Buffer) {
                    Buffer buf = (Buffer)content;
                    if (UnixChannelUtil.isBufferCopyNeededForWrite(buf)) {
                        try {
                            DefaultBufferAddressedEnvelope<InetSocketAddress> defaultBufferAddressedEnvelope = new DefaultBufferAddressedEnvelope<InetSocketAddress>(this.newDirectBuffer(buf), recipient);
                            return defaultBufferAddressedEnvelope;
                        }
                        finally {
                            SilentDispose.dispose(e, logger);
                        }
                    }
                    return e;
                }
            }
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(msg) + expectedTypes);
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.socket.disconnect();
        this.active = false;
        this.connected = false;
        this.resetCachedAddresses();
    }

    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress, Buffer initialData) throws Exception {
        if (super.doConnect(remoteAddress, localAddress, initialData)) {
            this.connected = true;
            return true;
        }
        return false;
    }

    @Override
    protected void doClose() throws Exception {
        super.doClose();
        this.connected = false;
    }

    @Override
    protected AbstractEpollChannel.ReadState epollInReady(AbstractChannel.ReadSink readSink) throws Exception {
        return this.socket.protocolFamily() == SocketProtocolFamily.UNIX ? this.doReadBufferDomainSocket(readSink) : this.doReadBuffer(readSink);
    }

    private AbstractEpollChannel.ReadState doReadBufferDomainSocket(AbstractChannel.ReadSink readSink) throws Exception {
        Buffer buf = null;
        try {
            DatagramPacket packet;
            int actualBytesRead;
            boolean connected = this.isConnected();
            buf = readSink.allocateBuffer();
            if (buf == null) {
                readSink.processRead(0, 0, null);
                return AbstractEpollChannel.ReadState.Partial;
            }
            int attemptedBytesRead = buf.writableBytes();
            assert (buf.isDirect());
            if (connected) {
                actualBytesRead = this.doReadBytes(buf);
                if (actualBytesRead <= 0) {
                    buf.close();
                    readSink.processRead(attemptedBytesRead, actualBytesRead, null);
                    return actualBytesRead == 0 ? AbstractEpollChannel.ReadState.All : AbstractEpollChannel.ReadState.Closed;
                }
                buf.skipWritableBytes(actualBytesRead);
                packet = new DatagramPacket(buf, (SocketAddress)this.localAddress(), (SocketAddress)this.remoteAddress());
            } else {
                DomainDatagramSocketAddress remoteAddress;
                try (ComponentIterator iteration = buf.forEachComponent();){
                    BufferComponent c = (BufferComponent)iteration.firstWritable();
                    remoteAddress = c != null ? this.socket.recvFromAddressDomainSocket(c.writableNativeAddress(), 0, c.writableBytes()) : null;
                }
                if (remoteAddress == null) {
                    readSink.processRead(attemptedBytesRead, 0, null);
                    buf.close();
                    return AbstractEpollChannel.ReadState.All;
                }
                DomainSocketAddress localAddress = remoteAddress.localAddress();
                if (localAddress == null) {
                    localAddress = (DomainSocketAddress)this.localAddress();
                }
                actualBytesRead = remoteAddress.receivedAmount();
                buf.skipWritableBytes(actualBytesRead);
                packet = new DatagramPacket(buf, localAddress, remoteAddress);
            }
            readSink.processRead(attemptedBytesRead, actualBytesRead, packet);
            buf = null;
            return AbstractEpollChannel.ReadState.Partial;
        }
        catch (Throwable t) {
            if (buf != null) {
                buf.close();
            }
            throw t;
        }
    }

    private AbstractEpollChannel.ReadState doReadBuffer(AbstractChannel.ReadSink readSink) throws Exception {
        boolean connected = this.isConnected();
        int datagramSize = this.getMaxDatagramPayloadSize();
        Buffer buf = readSink.allocateBuffer();
        if (buf == null) {
            readSink.processRead(0, 0, null);
            return AbstractEpollChannel.ReadState.Partial;
        }
        int numDatagram = Native.IS_SUPPORTING_RECVMMSG ? (datagramSize == 0 ? 1 : buf.writableBytes() / datagramSize) : 0;
        try {
            if (numDatagram <= 1) {
                if (!connected || this.isUdpGro()) {
                    return this.recvmsg(readSink, this.cleanDatagramPacketArray(), buf);
                }
                return this.connectedRead(readSink, buf, datagramSize);
            }
            return this.scatteringRead(readSink, this.cleanDatagramPacketArray(), buf, datagramSize, numDatagram);
        }
        catch (Errors.NativeIoException e) {
            if (connected) {
                throw this.translateForConnected(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractEpollChannel.ReadState connectedRead(AbstractChannel.ReadSink readSink, Buffer buf, int maxDatagramPacketSize) throws Exception {
        try {
            AbstractEpollChannel.ReadState readState;
            int totalBytesRead;
            int attemptedBytesRead = maxDatagramPacketSize != 0 ? Math.min(buf.writableBytes(), maxDatagramPacketSize) : buf.writableBytes();
            int initialWritableBytes = buf.writableBytes();
            try (ComponentIterator iteration = buf.forEachComponent();){
                BufferComponent c = (BufferComponent)iteration.firstWritable();
                while (c != null) {
                    long address = c.writableNativeAddress();
                    assert (address != 0L);
                    int bytesRead = this.socket.recvAddress(address, 0, c.writableBytes());
                    if (bytesRead <= 0) {
                        break;
                    }
                    c.skipWritableBytes(bytesRead);
                    c = (BufferComponent)((ComponentIterator.Next)((Object)c)).nextWritable();
                }
            }
            if ((totalBytesRead = initialWritableBytes - buf.writableBytes()) == 0) {
                readSink.processRead(attemptedBytesRead, totalBytesRead, null);
                readState = AbstractEpollChannel.ReadState.All;
                return readState;
            }
            readSink.processRead(attemptedBytesRead, totalBytesRead, new DatagramPacket(buf, (SocketAddress)this.localAddress(), (SocketAddress)this.remoteAddress()));
            buf = null;
            readState = AbstractEpollChannel.ReadState.Partial;
            return readState;
        }
        finally {
            if (buf != null) {
                buf.close();
            }
        }
    }

    private IOException translateForConnected(Errors.NativeIoException e) {
        if (e.expectedErr() == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
            PortUnreachableException error = new PortUnreachableException(e.getMessage());
            error.initCause(e);
            return error;
        }
        return e;
    }

    private static void addDatagramPacketToOut(AddressedEnvelope<?, ?> packet, RecyclableArrayList out) {
        if (packet instanceof SegmentedDatagramPacket) {
            try (SegmentedDatagramPacket segmentedDatagramPacket = (SegmentedDatagramPacket)packet;){
                Buffer content = (Buffer)segmentedDatagramPacket.content();
                Object recipient = segmentedDatagramPacket.recipient();
                Object sender = segmentedDatagramPacket.sender();
                int segmentSize = segmentedDatagramPacket.segmentSize();
                do {
                    out.add(new DatagramPacket(content.readSplit(segmentSize), (SocketAddress)recipient, (SocketAddress)sender));
                } while (content.readableBytes() > 0);
            }
        } else {
            out.add(packet);
        }
    }

    private static void releaseAndRecycle(Object buffer, RecyclableArrayList packetList) {
        Resource.dispose(buffer);
        if (packetList != null) {
            for (int i = 0; i < packetList.size(); ++i) {
                Resource.dispose(packetList.get(i));
            }
            packetList.recycle();
        }
    }

    private static void processPacketList(AbstractChannel.ReadSink readSink, int attemptedBytesRead, RecyclableArrayList packetList) {
        int messagesRead = packetList.size();
        for (int i = 0; i < messagesRead; ++i) {
            int attempted;
            DatagramPacket packet = (DatagramPacket)packetList.set(i, NULL);
            int readable = ((Buffer)packet.content()).readableBytes();
            if (attemptedBytesRead >= readable) {
                attemptedBytesRead -= readable;
                attempted = readable;
            } else {
                attempted = attemptedBytesRead;
            }
            readSink.processRead(attempted, readable, packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractEpollChannel.ReadState recvmsg(AbstractChannel.ReadSink readSink, NativeDatagramPacketArray array, Buffer buf) throws IOException {
        int bytesReceived;
        NativeDatagramPacketArray.NativeDatagramPacket msg;
        int attemptedBytesRead;
        int initialWriterOffset;
        RecyclableArrayList datagramPackets;
        block6: {
            AbstractEpollChannel.ReadState readState;
            datagramPackets = null;
            try {
                initialWriterOffset = buf.writerOffset();
                boolean added = array.addWritable(buf, 0, null);
                assert (added);
                attemptedBytesRead = buf.writerOffset() - initialWriterOffset;
                msg = array.packets()[0];
                bytesReceived = this.socket.recvmsg(msg);
                if (msg.hasSender()) break block6;
                readSink.processRead(attemptedBytesRead, 0, null);
                readState = AbstractEpollChannel.ReadState.All;
            }
            catch (Throwable throwable) {
                EpollDatagramChannel.releaseAndRecycle(buf, datagramPackets);
                throw throwable;
            }
            EpollDatagramChannel.releaseAndRecycle(buf, datagramPackets);
            return readState;
        }
        buf.writerOffset(initialWriterOffset + bytesReceived);
        InetSocketAddress local = (InetSocketAddress)this.localAddress();
        DatagramPacket packet = msg.newDatagramPacket(buf, local);
        if (!(packet instanceof SegmentedDatagramPacket)) {
            readSink.processRead(attemptedBytesRead, bytesReceived, packet);
            buf = null;
        } else {
            datagramPackets = RecyclableArrayList.newInstance();
            EpollDatagramChannel.addDatagramPacketToOut(packet, datagramPackets);
            buf = null;
            EpollDatagramChannel.processPacketList(readSink, attemptedBytesRead, datagramPackets);
            datagramPackets.recycle();
            datagramPackets = null;
        }
        AbstractEpollChannel.ReadState readState = AbstractEpollChannel.ReadState.Partial;
        EpollDatagramChannel.releaseAndRecycle(buf, datagramPackets);
        return readState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractEpollChannel.ReadState scatteringRead(AbstractChannel.ReadSink readSink, NativeDatagramPacketArray array, Buffer buf, int datagramSize, int numDatagram) throws IOException {
        AbstractEpollChannel.ReadState readState;
        InetSocketAddress local;
        int received;
        NativeDatagramPacketArray.NativeDatagramPacket[] packets;
        int attemptedBytesRead;
        RecyclableArrayList datagramPackets;
        block7: {
            DatagramPacket packet;
            int initialWriterOffset;
            block6: {
                datagramPackets = null;
                initialWriterOffset = buf.writerOffset();
                for (int i = 0; i < numDatagram && array.addWritable(buf, datagramSize, null); ++i) {
                }
                attemptedBytesRead = buf.writerOffset() - initialWriterOffset;
                packets = array.packets();
                received = this.socket.recvmmsg(packets, 0, array.count());
                if (received != 0) break block6;
                readSink.processRead(attemptedBytesRead, 0, null);
                AbstractEpollChannel.ReadState readState2 = AbstractEpollChannel.ReadState.All;
                EpollDatagramChannel.releaseAndRecycle(buf, datagramPackets);
                return readState2;
            }
            int bytesReceived = received * datagramSize;
            buf.writerOffset(initialWriterOffset + bytesReceived);
            local = (InetSocketAddress)this.localAddress();
            if (received != 1 || (packet = packets[0].newDatagramPacket(buf, local)) instanceof SegmentedDatagramPacket) break block7;
            readSink.processRead(attemptedBytesRead, datagramSize, packet);
            buf = null;
            AbstractEpollChannel.ReadState readState3 = AbstractEpollChannel.ReadState.Partial;
            EpollDatagramChannel.releaseAndRecycle(buf, datagramPackets);
            return readState3;
        }
        try {
            datagramPackets = RecyclableArrayList.newInstance();
            for (int i = 0; i < received; ++i) {
                DatagramPacket packet = packets[i].newDatagramPacket(buf.readSplit(datagramSize), local);
                EpollDatagramChannel.addDatagramPacketToOut(packet, datagramPackets);
            }
            buf.close();
            buf = null;
            EpollDatagramChannel.processPacketList(readSink, attemptedBytesRead, datagramPackets);
            datagramPackets.recycle();
            datagramPackets = null;
            readState = AbstractEpollChannel.ReadState.Partial;
        }
        catch (Throwable throwable) {
            EpollDatagramChannel.releaseAndRecycle(buf, datagramPackets);
            throw throwable;
        }
        EpollDatagramChannel.releaseAndRecycle(buf, datagramPackets);
        return readState;
    }

    private NativeDatagramPacketArray cleanDatagramPacketArray() {
        return this.registration().cleanDatagramPacketArray();
    }

    @Override
    protected <T> T getExtendedOption(ChannelOption<T> option) {
        if (EpollDatagramChannel.isOptionSupported(this.socket.protocolFamily(), option)) {
            if (option == ChannelOption.SO_BROADCAST) {
                return (T)Boolean.valueOf(this.isBroadcast());
            }
            if (option == ChannelOption.SO_RCVBUF) {
                return (T)Integer.valueOf(this.getReceiveBufferSize());
            }
            if (option == ChannelOption.SO_SNDBUF) {
                return (T)Integer.valueOf(this.getSendBufferSize());
            }
            if (option == ChannelOption.SO_REUSEADDR) {
                return (T)Boolean.valueOf(this.isReuseAddress());
            }
            if (option == ChannelOption.IP_MULTICAST_LOOP_DISABLED) {
                return (T)Boolean.valueOf(this.isLoopbackModeDisabled());
            }
            if (option == ChannelOption.IP_MULTICAST_IF) {
                return (T)this.getNetworkInterface();
            }
            if (option == ChannelOption.IP_MULTICAST_TTL) {
                return (T)Integer.valueOf(this.getTimeToLive());
            }
            if (option == ChannelOption.IP_TOS) {
                return (T)Integer.valueOf(this.getTrafficClass());
            }
            if (option == ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) {
                return (T)Boolean.valueOf(this.activeOnOpen);
            }
            if (option == UnixChannelOption.SO_REUSEPORT) {
                return (T)Boolean.valueOf(this.isReusePort());
            }
            if (option == EpollChannelOption.IP_TRANSPARENT) {
                return (T)Boolean.valueOf(this.isIpTransparent());
            }
            if (option == EpollChannelOption.IP_FREEBIND) {
                return (T)Boolean.valueOf(this.isFreeBind());
            }
            if (option == EpollChannelOption.IP_RECVORIGDSTADDR) {
                return (T)Boolean.valueOf(this.isIpRecvOrigDestAddr());
            }
            if (option == EpollChannelOption.MAX_DATAGRAM_PAYLOAD_SIZE) {
                return (T)Integer.valueOf(this.getMaxDatagramPayloadSize());
            }
            if (option == EpollChannelOption.UDP_GRO) {
                return (T)Boolean.valueOf(this.isUdpGro());
            }
        }
        return super.getExtendedOption(option);
    }

    @Override
    protected <T> void setExtendedOption(ChannelOption<T> option, T value) {
        if (EpollDatagramChannel.isOptionSupported(this.socket.protocolFamily(), option)) {
            if (option == ChannelOption.SO_BROADCAST) {
                this.setBroadcast((Boolean)value);
            } else if (option == ChannelOption.SO_RCVBUF) {
                this.setReceiveBufferSize((Integer)value);
            } else if (option == ChannelOption.SO_SNDBUF) {
                this.setSendBufferSize((Integer)value);
            } else if (option == ChannelOption.SO_REUSEADDR) {
                this.setReuseAddress((Boolean)value);
            } else if (option == ChannelOption.IP_MULTICAST_LOOP_DISABLED) {
                this.setLoopbackModeDisabled((Boolean)value);
            } else if (option == ChannelOption.IP_MULTICAST_IF) {
                this.setNetworkInterface((NetworkInterface)value);
            } else if (option == ChannelOption.IP_MULTICAST_TTL) {
                this.setTimeToLive((Integer)value);
            } else if (option == ChannelOption.IP_TOS) {
                this.setTrafficClass((Integer)value);
            } else if (option == ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) {
                this.setActiveOnOpen((Boolean)value);
            } else if (option == UnixChannelOption.SO_REUSEPORT) {
                this.setReusePort((Boolean)value);
            } else if (option == EpollChannelOption.IP_FREEBIND) {
                this.setFreeBind((Boolean)value);
            } else if (option == EpollChannelOption.IP_TRANSPARENT) {
                this.setIpTransparent((Boolean)value);
            } else if (option == EpollChannelOption.IP_RECVORIGDSTADDR) {
                this.setIpRecvOrigDestAddr((Boolean)value);
            } else if (option == EpollChannelOption.MAX_DATAGRAM_PAYLOAD_SIZE) {
                this.setMaxDatagramPayloadSize((Integer)value);
            } else if (option == EpollChannelOption.UDP_GRO) {
                this.setUdpGro((Boolean)value);
            }
        } else {
            super.setExtendedOption(option, value);
        }
    }

    private static Set<ChannelOption<?>> supportedOptions() {
        return EpollDatagramChannel.newSupportedIdentityOptionsSet(ChannelOption.SO_BROADCAST, ChannelOption.SO_RCVBUF, ChannelOption.SO_SNDBUF, ChannelOption.SO_REUSEADDR, ChannelOption.IP_MULTICAST_LOOP_DISABLED, ChannelOption.IP_MULTICAST_IF, ChannelOption.IP_MULTICAST_TTL, ChannelOption.IP_TOS, ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, UnixChannelOption.SO_REUSEPORT, EpollChannelOption.IP_FREEBIND, EpollChannelOption.IP_TRANSPARENT, EpollChannelOption.IP_RECVORIGDSTADDR, EpollChannelOption.MAX_DATAGRAM_PAYLOAD_SIZE, EpollChannelOption.UDP_GRO);
    }

    private static Set<ChannelOption<?>> supportedOptionsDomainSocket() {
        return EpollDatagramChannel.newSupportedIdentityOptionsSet(ChannelOption.SO_RCVBUF, ChannelOption.SO_SNDBUF, ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION);
    }

    private static boolean isOptionSupported(SocketProtocolFamily family, ChannelOption<?> option) {
        if (family == SocketProtocolFamily.UNIX) {
            return SUPPORTED_OPTIONS_DOMAIN_SOCKET.contains(option);
        }
        return SUPPORTED_OPTIONS.contains(option);
    }

    @Override
    protected boolean isExtendedOptionSupported(ChannelOption<?> option) {
        return EpollDatagramChannel.isOptionSupported(this.socket.protocolFamily(), option) || super.isExtendedOptionSupported(option);
    }

    private void setActiveOnOpen(boolean activeOnOpen) {
        if (this.isRegistered()) {
            throw new IllegalStateException("Can only changed before channel was registered");
        }
        this.activeOnOpen = activeOnOpen;
    }

    boolean getActiveOnOpen() {
        return this.activeOnOpen;
    }

    private int getSendBufferSize() {
        try {
            return this.socket.getSendBufferSize();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setSendBufferSize(int sendBufferSize) {
        try {
            this.socket.setSendBufferSize(sendBufferSize);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private int getReceiveBufferSize() {
        try {
            return this.socket.getReceiveBufferSize();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setReceiveBufferSize(int receiveBufferSize) {
        try {
            this.socket.setReceiveBufferSize(receiveBufferSize);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private int getTrafficClass() {
        try {
            return this.socket.getTrafficClass();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setTrafficClass(int trafficClass) {
        try {
            this.socket.setTrafficClass(trafficClass);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private boolean isReuseAddress() {
        try {
            return this.socket.isReuseAddress();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setReuseAddress(boolean reuseAddress) {
        try {
            this.socket.setReuseAddress(reuseAddress);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private boolean isBroadcast() {
        try {
            return this.socket.isBroadcast();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setBroadcast(boolean broadcast) {
        try {
            this.socket.setBroadcast(broadcast);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private boolean isLoopbackModeDisabled() {
        try {
            return this.socket.isLoopbackModeDisabled();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setLoopbackModeDisabled(boolean loopbackModeDisabled) {
        try {
            this.socket.setLoopbackModeDisabled(loopbackModeDisabled);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private int getTimeToLive() {
        try {
            return this.socket.getTimeToLive();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setTimeToLive(int ttl) {
        try {
            this.socket.setTimeToLive(ttl);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private NetworkInterface getNetworkInterface() {
        try {
            return this.socket.getNetworkInterface();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setNetworkInterface(NetworkInterface networkInterface) {
        try {
            this.socket.setNetworkInterface(networkInterface);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private boolean isReusePort() {
        try {
            return this.socket.isReusePort();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setReusePort(boolean reusePort) {
        try {
            this.socket.setReusePort(reusePort);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private boolean isIpTransparent() {
        try {
            return this.socket.isIpTransparent();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setIpTransparent(boolean ipTransparent) {
        try {
            this.socket.setIpTransparent(ipTransparent);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private boolean isFreeBind() {
        try {
            return this.socket.isIpFreeBind();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setFreeBind(boolean freeBind) {
        try {
            this.socket.setIpFreeBind(freeBind);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private boolean isIpRecvOrigDestAddr() {
        try {
            return this.socket.isIpRecvOrigDestAddr();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setIpRecvOrigDestAddr(boolean ipTransparent) {
        try {
            this.socket.setIpRecvOrigDestAddr(ipTransparent);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setMaxDatagramPayloadSize(int maxDatagramSize) {
        this.maxDatagramSize = ObjectUtil.checkPositiveOrZero(maxDatagramSize, "maxDatagramSize");
    }

    private int getMaxDatagramPayloadSize() {
        return this.maxDatagramSize;
    }

    private void setUdpGro(boolean gro) {
        try {
            this.socket.setUdpGro(gro);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
        this.gro = gro;
    }

    private boolean isUdpGro() {
        return this.gro;
    }
}

