/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.embedded;

import io.netty5.channel.Channel;
import io.netty5.channel.EventLoop;
import io.netty5.channel.IoHandle;
import io.netty5.channel.embedded.EmbeddedChannel;
import io.netty5.util.concurrent.AbstractScheduledEventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.concurrent.RunnableScheduledFuture;
import io.netty5.util.internal.StringUtil;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

final class EmbeddedEventLoop
extends AbstractScheduledEventExecutor
implements EventLoop {
    private long startTime = EmbeddedEventLoop.initialNanoTime();
    private long frozenTimestamp;
    private boolean timeFrozen;
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>(2);
    boolean running;

    EmbeddedEventLoop() {
    }

    private static EmbeddedChannel cast(IoHandle handle) {
        if (handle instanceof EmbeddedChannel) {
            return (EmbeddedChannel)handle;
        }
        throw new IllegalArgumentException("Channel of type " + StringUtil.simpleClassName(handle) + " not supported");
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    public Future<Void> registerForIo(IoHandle handle) {
        Promise<Void> promise = this.newPromise();
        EmbeddedChannel channel = EmbeddedEventLoop.cast(handle);
        if (this.inEventLoop()) {
            this.registerForIO0(channel, promise);
        } else {
            this.execute(() -> this.registerForIO0(channel, promise));
        }
        return promise.asFuture();
    }

    private void registerForIO0(EmbeddedChannel channel, Promise<Void> promise) {
        assert (this.inEventLoop());
        try {
            if (channel.isRegistered()) {
                throw new IllegalStateException("Channel already registered");
            }
            if (!channel.executor().inEventLoop()) {
                throw new IllegalStateException("Channel.executor() is not using the same Thread as this EventLoop");
            }
            channel.setActive();
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
            return;
        }
        promise.setSuccess(null);
    }

    @Override
    public Future<Void> deregisterForIo(IoHandle handle) {
        Promise<Void> promise = this.newPromise();
        EmbeddedChannel channel = EmbeddedEventLoop.cast(handle);
        if (this.inEventLoop()) {
            this.deregisterForIO0(channel, promise);
        } else {
            this.execute(() -> this.deregisterForIO0(channel, promise));
        }
        return promise.asFuture();
    }

    private void deregisterForIO0(Channel channel, Promise<Void> promise) {
        try {
            if (!channel.isRegistered()) {
                throw new IllegalStateException("Channel not registered");
            }
            if (!channel.executor().inEventLoop()) {
                throw new IllegalStateException("Channel.executor() is not using the same Thread as this EventLoop");
            }
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
            return;
        }
        promise.setSuccess(null);
    }

    @Override
    public void execute(Runnable task) {
        Objects.requireNonNull(task, "command");
        this.tasks.add(task);
        if (!this.running) {
            this.runTasks();
        }
    }

    void runTasks() {
        boolean wasRunning = this.running;
        try {
            while (true) {
                this.running = true;
                Runnable task = this.tasks.poll();
                if (task == null) {
                    break;
                }
                task.run();
            }
        }
        finally {
            if (!wasRunning) {
                this.running = false;
            }
        }
    }

    boolean hasPendingNormalTasks() {
        return !this.tasks.isEmpty();
    }

    long runScheduledTasks() {
        long time = this.getCurrentTimeNanos();
        boolean wasRunning = this.running;
        try {
            while (true) {
                this.running = true;
                RunnableScheduledFuture<?> task = this.pollScheduledTask(time);
                if (task == null) {
                    long l = this.nextScheduledTaskNano();
                    return l;
                }
                task.run();
            }
        }
        finally {
            if (!wasRunning) {
                this.running = false;
            }
        }
    }

    long nextScheduledTask() {
        return this.nextScheduledTaskNano();
    }

    void cancelScheduled() {
        this.running = true;
        try {
            this.cancelScheduledTasks();
        }
        finally {
            this.running = false;
        }
    }

    @Override
    protected long getCurrentTimeNanos() {
        if (this.timeFrozen) {
            return this.frozenTimestamp;
        }
        return System.nanoTime() - this.startTime;
    }

    void advanceTimeBy(long nanos) {
        if (this.timeFrozen) {
            this.frozenTimestamp += nanos;
        } else {
            this.startTime -= nanos;
        }
    }

    void freezeTime() {
        if (!this.timeFrozen) {
            this.frozenTimestamp = this.getCurrentTimeNanos();
            this.timeFrozen = true;
        }
    }

    void unfreezeTime() {
        if (this.timeFrozen) {
            this.startTime = System.nanoTime() - this.frozenTimestamp;
            this.timeFrozen = false;
        }
    }

    @Override
    public Future<Void> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<Void> terminationFuture() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShuttingDown() {
        return false;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        return false;
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return this.running;
    }

    @Override
    public boolean isCompatible(Class<? extends IoHandle> handleType) {
        return EmbeddedChannel.class.isAssignableFrom(handleType);
    }
}

