/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.embedded;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.internal.InternalBufferUtils;
import io.netty5.buffer.internal.ResourceSupport;
import io.netty5.channel.AbstractChannel;
import io.netty5.channel.AdaptiveReadHandleFactory;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelId;
import io.netty5.channel.ChannelInitializer;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.channel.DefaultChannelPipeline;
import io.netty5.channel.MaxMessagesWriteHandleFactory;
import io.netty5.channel.embedded.EmbeddedChannelId;
import io.netty5.channel.embedded.EmbeddedEventLoop;
import io.netty5.channel.embedded.EmbeddedSocketAddress;
import io.netty5.util.ReferenceCountUtil;
import io.netty5.util.Resource;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.RecyclableArrayList;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

public class EmbeddedChannel
extends AbstractChannel<Channel, SocketAddress, SocketAddress> {
    private static final SocketAddress LOCAL_ADDRESS = new EmbeddedSocketAddress();
    private static final SocketAddress REMOTE_ADDRESS = new EmbeddedSocketAddress();
    private static final ChannelHandler[] EMPTY_HANDLERS = new ChannelHandler[0];
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EmbeddedChannel.class);
    private final FutureListener<Void> recordExceptionListener = this::recordException;
    private Queue<Object> inboundMessages;
    private Queue<Object> outboundMessages;
    private Throwable lastException;
    private State state;
    private boolean inputShutdown;
    private boolean outputShutdown;

    public EmbeddedChannel() {
        this(EMPTY_HANDLERS);
    }

    public EmbeddedChannel(ChannelId channelId) {
        this(channelId, EMPTY_HANDLERS);
    }

    public EmbeddedChannel(ChannelHandler ... handlers) {
        this(EmbeddedChannelId.INSTANCE, handlers);
    }

    public EmbeddedChannel(boolean hasDisconnect, ChannelHandler ... handlers) {
        this(EmbeddedChannelId.INSTANCE, hasDisconnect, handlers);
    }

    public EmbeddedChannel(boolean register, boolean hasDisconnect, ChannelHandler ... handlers) {
        this(EmbeddedChannelId.INSTANCE, register, hasDisconnect, handlers);
    }

    public EmbeddedChannel(ChannelId channelId, ChannelHandler ... handlers) {
        this(channelId, false, handlers);
    }

    public EmbeddedChannel(ChannelId channelId, boolean hasDisconnect, ChannelHandler ... handlers) {
        this(channelId, true, hasDisconnect, handlers);
    }

    public EmbeddedChannel(ChannelId channelId, boolean register, boolean hasDisconnect, ChannelHandler ... handlers) {
        this(null, channelId, register, hasDisconnect, handlers);
    }

    public EmbeddedChannel(Channel parent, ChannelId channelId, boolean register, boolean hasDisconnect, ChannelHandler ... handlers) {
        super(parent, new EmbeddedEventLoop(), hasDisconnect, new AdaptiveReadHandleFactory(), new MaxMessagesWriteHandleFactory(Integer.MAX_VALUE), channelId);
        this.setup(register, handlers);
    }

    private void setup(boolean register, final ChannelHandler ... handlers) {
        Objects.requireNonNull(handlers, "handlers");
        ChannelPipeline p = this.pipeline();
        p.addLast(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                for (ChannelHandler h : handlers) {
                    if (h == null) break;
                    pipeline.addLast(h);
                }
            }
        });
        if (register) {
            Future<Void> future = this.register();
            assert (future.isDone());
        }
    }

    @Override
    public Future<Void> register() {
        Future<Void> future = super.register();
        assert (future.isDone());
        Throwable cause = future.cause();
        if (cause != null) {
            PlatformDependent.throwException(cause);
        }
        return future;
    }

    @Override
    protected final DefaultChannelPipeline newChannelPipeline() {
        return new EmbeddedChannelPipeline(this);
    }

    @Override
    public boolean isOpen() {
        return this.state != State.CLOSED;
    }

    @Override
    public boolean isActive() {
        return this.state == State.ACTIVE;
    }

    public Queue<Object> inboundMessages() {
        if (this.inboundMessages == null) {
            this.inboundMessages = new ArrayDeque<Object>();
        }
        return this.inboundMessages;
    }

    public Queue<Object> outboundMessages() {
        if (this.outboundMessages == null) {
            this.outboundMessages = new ArrayDeque<Object>();
        }
        return this.outboundMessages;
    }

    public <T> T readInbound() {
        Object message = EmbeddedChannel.poll(this.inboundMessages);
        if (message != null) {
            Resource.touch(message, "Caller of readInbound() will handle the message from this point");
        }
        return (T)message;
    }

    public <T> T readOutbound() {
        Object message = EmbeddedChannel.poll(this.outboundMessages);
        if (message != null) {
            Resource.touch(message, "Caller of readOutbound() will handle the message from this point.");
        }
        return (T)message;
    }

    public boolean writeInbound(Object ... msgs) {
        this.ensureOpen();
        if (msgs.length == 0) {
            return EmbeddedChannel.isNotEmpty(this.inboundMessages);
        }
        ChannelPipeline p = this.pipeline();
        for (Object m : msgs) {
            p.fireChannelRead(m);
        }
        this.flushInbound(false);
        return EmbeddedChannel.isNotEmpty(this.inboundMessages);
    }

    public Future<Void> writeOneInbound(Object msg) {
        if (this.checkOpen(true)) {
            this.pipeline().fireChannelRead(msg);
        }
        return this.checkException0();
    }

    public EmbeddedChannel flushInbound() {
        this.flushInbound(true);
        return this;
    }

    private void flushInbound(boolean recordException) {
        if (this.checkOpen(recordException)) {
            this.pipeline().fireChannelReadComplete();
            this.embeddedEventLoop().execute(this::readIfIsAutoRead);
            this.runPendingTasks();
        }
        this.checkException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeOutbound(Object ... msgs) {
        this.ensureOpen();
        if (msgs.length == 0) {
            return EmbeddedChannel.isNotEmpty(this.outboundMessages);
        }
        RecyclableArrayList futures = RecyclableArrayList.newInstance(msgs.length);
        try {
            for (Object m : msgs) {
                if (m == null) break;
                futures.add(this.write(m));
            }
            this.flushOutbound0();
            int size = futures.size();
            for (int i = 0; i < size; ++i) {
                Future future = (Future)futures.get(i);
                if (future.isDone()) {
                    this.recordException(future);
                    continue;
                }
                future.addListener(this.recordExceptionListener);
            }
            this.checkException();
            int n = EmbeddedChannel.isNotEmpty(this.outboundMessages) ? 1 : 0;
            return n != 0;
        }
        finally {
            futures.recycle();
        }
    }

    public Future<Void> writeOneOutbound(Object msg) {
        if (this.checkOpen(true)) {
            return this.write(msg);
        }
        return this.checkException0();
    }

    public EmbeddedChannel flushOutbound() {
        if (this.checkOpen(true)) {
            this.flushOutbound0();
        }
        this.checkException();
        return this;
    }

    private void flushOutbound0() {
        this.runPendingTasks();
        this.flush();
    }

    public boolean finish() {
        return this.finish(false);
    }

    public boolean finishAndReleaseAll() {
        return this.finish(true);
    }

    private boolean finish(boolean releaseAll) {
        this.close();
        try {
            this.checkException();
            boolean bl = EmbeddedChannel.isNotEmpty(this.inboundMessages) || EmbeddedChannel.isNotEmpty(this.outboundMessages);
            return bl;
        }
        finally {
            if (releaseAll) {
                EmbeddedChannel.releaseAll(this.inboundMessages);
                EmbeddedChannel.releaseAll(this.outboundMessages);
            }
        }
    }

    public boolean releaseInbound() {
        return EmbeddedChannel.releaseAll(this.inboundMessages);
    }

    public boolean releaseOutbound() {
        return EmbeddedChannel.releaseAll(this.outboundMessages);
    }

    private static boolean releaseAll(Queue<Object> queue) {
        Exception closeFailed = null;
        if (EmbeddedChannel.isNotEmpty(queue)) {
            Object msg;
            while ((msg = queue.poll()) != null) {
                try {
                    Resource.dispose(msg);
                }
                catch (Exception e) {
                    if (closeFailed == null) {
                        closeFailed = e;
                        continue;
                    }
                    closeFailed.addSuppressed(e);
                }
            }
            if (closeFailed != null) {
                PlatformDependent.throwException(closeFailed);
            }
            return true;
        }
        return false;
    }

    private void finishPendingTasks(boolean cancel) {
        this.runPendingTasks();
        if (cancel) {
            ((EmbeddedEventLoop)this.executor()).cancelScheduled();
        }
    }

    @Override
    public final Future<Void> close() {
        this.runPendingTasks();
        Future<Void> future = super.close();
        this.finishPendingTasks(true);
        return future;
    }

    @Override
    public final Future<Void> disconnect() {
        Future<Void> future = super.disconnect();
        this.finishPendingTasks(!this.isSupportingDisconnect());
        return future;
    }

    private static boolean isNotEmpty(Queue<Object> queue) {
        return queue != null && !queue.isEmpty();
    }

    private static Object poll(Queue<Object> queue) {
        return queue != null ? queue.poll() : null;
    }

    public void runPendingTasks() {
        EmbeddedEventLoop embeddedEventLoop = (EmbeddedEventLoop)this.executor();
        try {
            embeddedEventLoop.runTasks();
        }
        catch (Exception e) {
            this.recordException(e);
        }
        this.runScheduledPendingTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long runScheduledPendingTasks() {
        EmbeddedEventLoop embeddedEventLoop = (EmbeddedEventLoop)this.executor();
        try {
            long l = embeddedEventLoop.runScheduledTasks();
            return l;
        }
        catch (Exception e) {
            this.recordException(e);
            long l = embeddedEventLoop.nextScheduledTask();
            return l;
        }
        finally {
            embeddedEventLoop.runTasks();
        }
    }

    public boolean hasPendingTasks() {
        return this.embeddedEventLoop().hasPendingNormalTasks() || this.embeddedEventLoop().nextScheduledTask() == 0L;
    }

    private void recordException(Future<?> future) {
        if (future.isFailed()) {
            this.recordException(future.cause());
        }
    }

    private void recordException(Throwable cause) {
        if (this.lastException == null) {
            this.lastException = cause;
        } else {
            logger.warn("More than one exception was raised. Will report only the first one and log others.", cause);
        }
    }

    private EmbeddedEventLoop embeddedEventLoop() {
        return (EmbeddedEventLoop)this.executor();
    }

    public void advanceTimeBy(long duration, TimeUnit unit) {
        this.embeddedEventLoop().advanceTimeBy(unit.toNanos(duration));
    }

    public void freezeTime() {
        this.embeddedEventLoop().freezeTime();
    }

    public void unfreezeTime() {
        this.embeddedEventLoop().unfreezeTime();
    }

    private Future<Void> checkException0() {
        try {
            this.checkException();
        }
        catch (Throwable cause) {
            return this.newFailedFuture(cause);
        }
        return this.newSucceededFuture();
    }

    public void checkException() {
        Throwable t = this.lastException;
        if (t != null) {
            this.lastException = null;
            PlatformDependent.throwException(t);
        }
    }

    private boolean checkOpen(boolean recordException) {
        if (!this.isOpen()) {
            if (recordException) {
                this.recordException(new ClosedChannelException());
            }
            return false;
        }
        return true;
    }

    protected final void ensureOpen() {
        if (!this.checkOpen(true)) {
            this.checkException();
        }
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.isActive() ? LOCAL_ADDRESS : null;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.isActive() ? REMOTE_ADDRESS : null;
    }

    void setActive() {
        this.state = State.ACTIVE;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
    }

    @Override
    protected void doShutdown(ChannelShutdownDirection direction) {
        switch (direction) {
            case Inbound: {
                this.inputShutdown = true;
                break;
            }
            case Outbound: {
                this.outputShutdown = true;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public boolean isShutdown(ChannelShutdownDirection direction) {
        if (!this.isActive()) {
            return true;
        }
        switch (direction) {
            case Inbound: {
                return this.inputShutdown;
            }
            case Outbound: {
                return this.outputShutdown;
            }
        }
        throw new AssertionError();
    }

    @Override
    protected void doDisconnect() throws Exception {
        if (!this.isSupportingDisconnect()) {
            this.doClose();
        }
    }

    @Override
    protected void doClose() throws Exception {
        this.state = State.CLOSED;
    }

    @Override
    protected void doRead(boolean wasReadPendingAlready) throws Exception {
    }

    @Override
    protected boolean doReadNow(AbstractChannel.ReadSink readSink) {
        return false;
    }

    @Override
    protected void doWriteNow(AbstractChannel.WriteSink writeSink) throws Exception {
        Object msg = writeSink.currentFlushedMessage();
        if (msg instanceof ResourceSupport) {
            this.handleOutboundMessage(InternalBufferUtils.acquire((ResourceSupport)msg));
        } else if (msg instanceof Resource) {
            this.handleOutboundMessage(((Resource)msg).send().receive());
        } else {
            this.handleOutboundMessage(ReferenceCountUtil.retain(msg));
        }
        writeSink.complete(0L, 0L, 1, true);
    }

    protected void handleOutboundMessage(Object msg) {
        this.outboundMessages().add(msg);
    }

    protected void handleInboundMessage(Object msg) {
        this.inboundMessages().add(msg);
    }

    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress, Buffer initialData) {
        return true;
    }

    @Override
    protected boolean doFinishConnect(SocketAddress requestedRemoteAddress) {
        return true;
    }

    private final class EmbeddedChannelPipeline
    extends AbstractChannel.DefaultAbstractChannelPipeline {
        EmbeddedChannelPipeline(EmbeddedChannel channel) {
            super(channel);
        }

        @Override
        protected void onUnhandledInboundException(Throwable cause) {
            EmbeddedChannel.this.recordException(cause);
        }

        @Override
        protected void onUnhandledInboundMessage(ChannelHandlerContext ctx, Object msg) {
            EmbeddedChannel.this.handleInboundMessage(msg);
        }

        @Override
        protected void runAfterTransportOperation() {
            super.runAfterTransportOperation();
            if (!((EmbeddedEventLoop)this.executor()).running) {
                EmbeddedChannel.this.runPendingTasks();
            }
        }
    }

    private static enum State {
        OPEN,
        ACTIVE,
        CLOSED;

    }
}

