/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel;

import io.netty5.channel.Channel;
import io.netty5.channel.EventLoop;
import io.netty5.channel.IoExecutionContext;
import io.netty5.channel.IoHandle;
import io.netty5.channel.IoHandler;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.concurrent.RejectedExecutionHandler;
import io.netty5.util.concurrent.RejectedExecutionHandlers;
import io.netty5.util.concurrent.SingleThreadEventExecutor;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.SystemPropertyUtil;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

public class SingleThreadEventLoop
extends SingleThreadEventExecutor
implements EventLoop {
    protected static final int DEFAULT_MAX_PENDING_TASKS = Math.max(16, SystemPropertyUtil.getInt("io.netty5.eventLoop.maxPendingTasks", Integer.MAX_VALUE));
    protected static final int DEFAULT_MAX_TASKS_PER_RUN = Math.max(1, SystemPropertyUtil.getInt("io.netty5.eventLoop.maxTaskPerRun", 4096));
    private final IoExecutionContext context = new IoExecutionContext(){

        @Override
        public boolean canBlock() {
            assert (SingleThreadEventLoop.this.inEventLoop());
            return !SingleThreadEventLoop.this.hasTasks() && !SingleThreadEventLoop.this.hasScheduledTasks();
        }

        @Override
        public long delayNanos(long currentTimeNanos) {
            assert (SingleThreadEventLoop.this.inEventLoop());
            return SingleThreadEventLoop.this.delayNanos(currentTimeNanos);
        }

        @Override
        public long deadlineNanos() {
            assert (SingleThreadEventLoop.this.inEventLoop());
            return SingleThreadEventLoop.this.deadlineNanos();
        }
    };
    private final IoHandler ioHandler;
    private final int maxTasksPerRun;

    public SingleThreadEventLoop(ThreadFactory threadFactory, IoHandler ioHandler) {
        this(threadFactory, ioHandler, DEFAULT_MAX_PENDING_TASKS, RejectedExecutionHandlers.reject());
    }

    public SingleThreadEventLoop(Executor executor, IoHandler ioHandler) {
        this(executor, ioHandler, DEFAULT_MAX_PENDING_TASKS, RejectedExecutionHandlers.reject());
    }

    public SingleThreadEventLoop(ThreadFactory threadFactory, IoHandler ioHandler, int maxPendingTasks, RejectedExecutionHandler rejectedHandler) {
        this(threadFactory, ioHandler, maxPendingTasks, rejectedHandler, DEFAULT_MAX_TASKS_PER_RUN);
    }

    public SingleThreadEventLoop(Executor executor, IoHandler ioHandler, int maxPendingTasks, RejectedExecutionHandler rejectedHandler) {
        this(executor, ioHandler, maxPendingTasks, rejectedHandler, DEFAULT_MAX_TASKS_PER_RUN);
    }

    public SingleThreadEventLoop(ThreadFactory threadFactory, IoHandler ioHandler, int maxPendingTasks, RejectedExecutionHandler rejectedHandler, int maxTasksPerRun) {
        super(threadFactory, maxPendingTasks, rejectedHandler);
        this.ioHandler = Objects.requireNonNull(ioHandler, "ioHandler");
        this.maxTasksPerRun = ObjectUtil.checkPositive(maxTasksPerRun, "maxTasksPerRun");
    }

    public SingleThreadEventLoop(Executor executor, IoHandler ioHandler, int maxPendingTasks, RejectedExecutionHandler rejectedHandler, int maxTasksPerRun) {
        super(executor, maxPendingTasks, rejectedHandler);
        this.ioHandler = Objects.requireNonNull(ioHandler, "ioHandler");
        this.maxTasksPerRun = ObjectUtil.checkPositive(maxTasksPerRun, "maxTasksPerRun");
    }

    @Override
    protected Queue<Runnable> newTaskQueue(int maxPendingTasks) {
        return maxPendingTasks == Integer.MAX_VALUE ? PlatformDependent.newMpscQueue() : PlatformDependent.newMpscQueue(maxPendingTasks);
    }

    @Override
    protected final boolean wakesUpForTask(Runnable task) {
        return !(task instanceof NonWakeupRunnable);
    }

    @Override
    protected void run() {
        assert (this.inEventLoop());
        do {
            this.runIO();
            if (this.isShuttingDown()) {
                this.ioHandler.prepareToDestroy();
            }
            this.runAllTasks(this.maxTasksPerRun);
        } while (!this.confirmShutdown());
    }

    protected int runIO() {
        assert (this.inEventLoop());
        return this.ioHandler.run(this.context);
    }

    @Override
    public final Future<Void> registerForIo(IoHandle handle) {
        Promise<Void> promise = this.newPromise();
        if (this.inEventLoop()) {
            this.registerForIO0(handle, promise);
        } else {
            this.execute(() -> this.registerForIO0(handle, promise));
        }
        return promise.asFuture();
    }

    private void registerForIO0(IoHandle handle, Promise<Void> promise) {
        try {
            if (handle.isRegistered()) {
                throw new IllegalStateException("IoHandle already registered");
            }
            SingleThreadEventLoop.checkInEventLoopIfPossible(handle);
            this.ioHandler.register(handle);
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
            return;
        }
        promise.setSuccess(null);
    }

    @Override
    public final Future<Void> deregisterForIo(IoHandle handle) {
        Promise<Void> promise = this.newPromise();
        if (this.inEventLoop()) {
            this.deregisterForIO(handle, promise);
        } else {
            this.execute(() -> this.deregisterForIO(handle, promise));
        }
        return promise.asFuture();
    }

    private void deregisterForIO(IoHandle handle, Promise<Void> promise) {
        try {
            if (!handle.isRegistered()) {
                throw new IllegalStateException("Channel not registered");
            }
            SingleThreadEventLoop.checkInEventLoopIfPossible(handle);
            this.ioHandler.deregister(handle);
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
            return;
        }
        promise.setSuccess(null);
    }

    private static void checkInEventLoopIfPossible(IoHandle handle) {
        if (handle instanceof Channel && !((Channel)handle).executor().inEventLoop()) {
            throw new IllegalStateException("Channel.executor() is not using the same Thread as this EventLoop");
        }
    }

    @Override
    protected final void wakeup(boolean inEventLoop) {
        this.ioHandler.wakeup(inEventLoop);
    }

    @Override
    protected final void cleanup() {
        assert (this.inEventLoop());
        this.ioHandler.destroy();
    }

    @Override
    public boolean isCompatible(Class<? extends IoHandle> handleType) {
        return this.ioHandler.isCompatible(handleType);
    }

    static interface NonWakeupRunnable
    extends Runnable {
    }
}

